/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.image;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.model.AvatarAttachment;

public class ImageUtils {
    public static final String KEY_SEPARATOR = "_";
    public static final String KEY_DIMENSION_SEPARATOR = "x";
    public static final String GIF_EXTENDSION = "gif";
    private static final Log LOG = ExoLogger.getLogger(ImageUtils.class);

    private static void makeNotNull(String ... str) {
        for (String string : str) {
            if (string != null) continue;
            string = "";
        }
    }

    public static String buildFileName(String oldFileName, String subfix, String postfix) {
        ImageUtils.makeNotNull(oldFileName, subfix, postfix);
        if (oldFileName.equals("")) {
            return subfix + postfix;
        }
        int dotIndex = oldFileName.lastIndexOf(46);
        if (dotIndex < 0) {
            return subfix + oldFileName + postfix;
        }
        String nameOnly = oldFileName.substring(0, dotIndex);
        String extendtionAndDot = oldFileName.substring(dotIndex);
        return subfix + nameOnly + postfix + extendtionAndDot;
    }

    public static String buildImagePostfix(int width, int height) {
        return KEY_SEPARATOR + (width < 0 ? 0 : width) + KEY_DIMENSION_SEPARATOR + (height < 0 ? 0 : height);
    }

    public static AvatarAttachment createResizedAvatarAttachment(InputStream imageStream, int width, int height, String avatarId, String avatarFileName, String avatarMimeType, String avatarWorkspace) {
        try {
            MimeTypeResolver mimeTypeResolver = new MimeTypeResolver();
            BufferedImage image = null;
            int minSize = 0;
            String extension = mimeTypeResolver.getExtension(avatarMimeType);
            if (extension.equalsIgnoreCase(GIF_EXTENDSION)) {
                return null;
            }
            image = ImageIO.read(imageStream);
            if (height <= minSize & width <= minSize) {
                LOG.warn((Object)"Fail to resize image to avatar attachment with dimention <= 0x0");
                return null;
            }
            if (height <= minSize) {
                height = image.getHeight() * width / image.getWidth();
            } else if (width <= minSize) {
                width = image.getWidth() * height / image.getHeight();
            }
            File tmp = File.createTempFile("RESIZED", null);
            image = org.apache.shindig.gadgets.rewrite.image.ImageUtils.getScaledInstance((BufferedImage)image, (int)width, (int)height, (Object)RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR, (boolean)false, (int)1);
            int imgWidth = image.getWidth();
            int imgHeight = image.getHeight();
            if (imgWidth != imgHeight) {
                int h;
                int w;
                int y;
                int x;
                int offset;
                int cropDimension = imgWidth > imgHeight ? imgHeight : imgWidth;
                int n = offset = cropDimension == imgWidth ? imgHeight - cropDimension : imgWidth - cropDimension;
                if (imgWidth < imgHeight) {
                    x = 0;
                    y = offset / 2;
                    w = imgWidth;
                    h = imgHeight - offset;
                } else {
                    x = offset / 2;
                    y = 0;
                    w = imgWidth - offset;
                    h = imgHeight;
                }
                image = image.getSubimage(x, y, w, h);
            }
            ImageIO.write((RenderedImage)image, extension, tmp);
            AvatarAttachment newAvatarAttachment = new AvatarAttachment(avatarId, avatarFileName, avatarMimeType, new FileInputStream(tmp), avatarWorkspace, System.currentTimeMillis());
            tmp.delete();
            return newAvatarAttachment;
        }
        catch (Exception e) {
            LOG.error((Object)("Fail to resize image to avatar attachment: " + e));
            return null;
        }
    }
}

