/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.updater;

import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.chromattic.api.ChromatticSession;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.lifecycle.SocialChromatticLifeCycle;
import org.exoplatform.social.core.chromattic.entity.ProviderRootEntity;

public abstract class AbstractUpdaterPlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(AbstractUpdaterPlugin.class);
    protected final SocialChromatticLifeCycle lifeCycle = this.lifecycleLookup();
    protected static final String NODETYPE_PROVIDERS = "soc:providers";

    public AbstractUpdaterPlugin(InitParams initParams) {
        super(initParams);
    }

    protected ProviderRootEntity getProviderRoot() {
        if (this.lifeCycle.getProviderRoot().get() == null) {
            this.lifeCycle.getProviderRoot().set(this.getRoot(NODETYPE_PROVIDERS, ProviderRootEntity.class));
        }
        return (ProviderRootEntity)this.lifeCycle.getProviderRoot().get();
    }

    private <T> T getRoot(String nodetypeName, Class<T> t) {
        Object got = this.getSession().findByPath(t, nodetypeName);
        if (got == null) {
            got = this.getSession().insert(t, nodetypeName);
        }
        return (T)got;
    }

    protected NodeIterator nodes(String statement) {
        if (statement == null) {
            return null;
        }
        try {
            QueryManager queryMgr = this.getJCRSession().getWorkspace().getQueryManager();
            Query query = queryMgr.createQuery(statement, "sql");
            if (query instanceof QueryImpl) {
                QueryImpl impl = (QueryImpl)query;
                return impl.execute().getNodes();
            }
            return query.execute().getNodes();
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            return null;
        }
    }

    protected NodeIterator nodes(String statement, long offset, long limit) {
        if (statement == null) {
            return null;
        }
        try {
            QueryManager queryMgr = this.getJCRSession().getWorkspace().getQueryManager();
            Query query = queryMgr.createQuery(statement, "sql");
            if (query instanceof QueryImpl) {
                QueryImpl impl = (QueryImpl)query;
                impl.setOffset(offset);
                impl.setLimit(limit);
                return impl.execute().getNodes();
            }
            return query.execute().getNodes();
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            return null;
        }
    }

    private SocialChromatticLifeCycle lifecycleLookup() {
        PortalContainer container = PortalContainer.getInstance();
        ChromatticManager manager = (ChromatticManager)container.getComponentInstanceOfType(ChromatticManager.class);
        return (SocialChromatticLifeCycle)manager.getLifeCycle("soc");
    }

    private Session getJCRSession() {
        return this.lifeCycle.getSession().getJCRSession();
    }

    private ChromatticSession getSession() {
        return this.lifeCycle.getSession();
    }
}

