/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.userrelationship;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.api.UsersRelationshipsRestResources;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.rest.entity.RelationshipEntity;

@Path(value="v1/social/usersRelationships")
@Api(tags={"v1/social/usersRelationships"}, value="v1/social/usersRelationships", description="Managing relationships of users")
public class UsersRelationshipsRestResourcesV1
implements UsersRelationshipsRestResources {
    @Override
    @RolesAllowed(value={"users"})
    @GET
    @ApiOperation(value="Gets all user relationships", httpMethod="GET", response=Response.class, notes="This returns a list of relationships in the following cases: <br/><ul><li>if the query param \"user\" is not defined: returns the relationships of the authenticated user</li><li>if the \"user\" is defined and the authenticated user is not an administrator: returns the relationships of the authenticated user</li><li>if the \"user\" is defined and the authenticated user is an administrator: returns the relationships of the defined user</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getUsersRelationships(@Context UriInfo uriInfo, @ApiParam(value="Specific status of relationships: pending, confirmed or all", defaultValue="all") @QueryParam(value="status") String status, @ApiParam(value="User name to get relationships") @QueryParam(value="user") String user, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit, @ApiParam(value="Returning the number of relationships or not", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @ApiParam(value="Asking for a full representation of a specific subresource, ex: sender or receiver", required=false) @QueryParam(value="expand") String expand) throws Exception {
        Relationship.Type type;
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        RelationshipManager relationshipManager = (RelationshipManager)CommonsUtils.getService(RelationshipManager.class);
        try {
            type = Relationship.Type.valueOf((String)status.toUpperCase());
        }
        catch (Exception e) {
            type = Relationship.Type.ALL;
        }
        ArrayList<Relationship> relationships = new ArrayList();
        int size = 0;
        if (user != null & RestUtils.isMemberOfAdminGroup()) {
            Identity givenUser = identityManager.getOrCreateIdentity("organization", user, true);
            relationships = relationshipManager.getRelationshipsByStatus(givenUser, type, offset, limit);
            size = returnSize ? relationshipManager.getRelationshipsCountByStatus(givenUser, type) : -1;
        } else {
            Identity authenticatedUser = identityManager.getOrCreateIdentity("organization", ConversationState.getCurrent().getIdentity().getUserId(), true);
            relationships = relationshipManager.getRelationshipsByStatus(authenticatedUser, type, offset, limit);
            size = returnSize ? relationshipManager.getRelationshipsCountByStatus(authenticatedUser, type) : -1;
        }
        List<DataEntity> relationshipEntities = EntityBuilder.buildRelationshipEntities(relationships, uriInfo);
        CollectionEntity collectionRelationship = new CollectionEntity(relationshipEntities, "usersRelationships", offset, limit);
        if (returnSize) {
            collectionRelationship.setSize(size);
        }
        return EntityBuilder.getResponse(collectionRelationship, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @POST
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Creates a relationship between two specific users", httpMethod="POST", response=Response.class, notes="This creates the relationship in the following cases: <br/><ul><li>the sender or the receiver of the user relationship is the authenticated user</li><li>the authenticated user is in the group /platform/administrators</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response createUsersRelationships(@Context UriInfo uriInfo, @ApiParam(value="Asking for a full representation of a specific subresource, ex: sender or receiver", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="Relationship object to be created, required fields: <br/>sender - user name of the sender,<br/>receiver - user name of the receiver,<br/>status - pending or confirmed", required=true) RelationshipEntity model) throws Exception {
        if (model == null || model.getReceiver() == null || model.getSender() == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (!(RestUtils.isMemberOfAdminGroup() || model.getReceiver().equals(authenticatedUser) || model.getSender().equals(authenticatedUser))) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        Identity sender = identityManager.getOrCreateIdentity("organization", model.getSender(), true);
        Identity receiver = identityManager.getOrCreateIdentity("organization", model.getReceiver(), true);
        if (sender == null || receiver == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        Relationship.Type status = model.getStatus() != null && model.getStatus().equalsIgnoreCase("pending") ? Relationship.Type.PENDING : Relationship.Type.CONFIRMED;
        RelationshipManager relationshipManager = (RelationshipManager)CommonsUtils.getService(RelationshipManager.class);
        if (relationshipManager.get(sender, receiver) != null && !Relationship.Type.CONFIRMED.equals((Object)status)) {
            throw new WebApplicationException(Response.Status.PRECONDITION_FAILED);
        }
        Relationship relationship = this.createRelationshipByStatus(sender, receiver, status);
        return EntityBuilder.getResponse(EntityBuilder.buildEntityRelationship(relationship, uriInfo.getPath(), expand, false), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @GET
    @RolesAllowed(value={"users"})
    @Path(value="{id}")
    @ApiOperation(value="Gets a specific relationship of user by id", httpMethod="GET", response=Response.class, notes="This returns the relationship in the following cases: <br/><ul><li>the sender or the receiver of the user relationship is the authenticated user</li><li>the authenticated user is in the group /platform/administrators</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getUsersRelationshipsById(@Context UriInfo uriInfo, @ApiParam(value="Relationship id", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a specific subresource, ex: sender or receiver", required=false) @QueryParam(value="expand") String expand) throws Exception {
        Identity authenticatedUser = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", ConversationState.getCurrent().getIdentity().getUserId(), true);
        RelationshipManager relationshipManager = (RelationshipManager)CommonsUtils.getService(RelationshipManager.class);
        Relationship relationship = relationshipManager.get(id);
        if (relationship == null || !this.hasPermissionOnRelationship(authenticatedUser, relationship)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        return EntityBuilder.getResponse(EntityBuilder.buildEntityRelationship(relationship, uriInfo.getPath(), expand, false), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @PUT
    @RolesAllowed(value={"users"})
    @Path(value="{id}")
    @ApiOperation(value="Updates a specific relationship of user by id", httpMethod="PUT", response=Response.class, notes="This updates the relationship in the following cases: <br/><ul><li>the sender or the receiver of the user relationship is the authenticated user</li><li>the authenticated user is in the group /platform/administrators</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response updateUsersRelationshipsById(@Context UriInfo uriInfo, @ApiParam(value="Relationship id", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a specific subresource, ex: sender or receiver", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="Relationship object to be updated", required=true) RelationshipEntity model) throws Exception {
        Relationship.Type status;
        if (model == null || model.getStatus() == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        Identity authenticatedUser = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", ConversationState.getCurrent().getIdentity().getUserId(), true);
        RelationshipManager relationshipManager = (RelationshipManager)CommonsUtils.getService(RelationshipManager.class);
        Relationship relationship = relationshipManager.get(id);
        if (relationship == null || !this.hasPermissionOnRelationship(authenticatedUser, relationship)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        try {
            status = Relationship.Type.valueOf((String)model.getStatus().toUpperCase());
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (Relationship.Type.CONFIRMED.equals((Object)status) && !RestUtils.isMemberOfAdminGroup() && !authenticatedUser.getId().equals(relationship.getReceiver().getId())) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        this.updateRelationshipByStatus(relationship, status, relationshipManager);
        return EntityBuilder.getResponse(EntityBuilder.buildEntityRelationship(relationship, uriInfo.getPath(), expand, false), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @DELETE
    @RolesAllowed(value={"users"})
    @Path(value="{id}")
    @ApiOperation(value="Deletes a specific relationship of user by id", httpMethod="DELETE", response=Response.class, notes="This deletes the relationship in the following cases: <br/><ul><li>the sender or the receiver of the user relationship is the authenticated user</li><li>the authenticated user is in the group /platform/administrators</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response deleteUsersRelationshipsById(@Context UriInfo uriInfo, @ApiParam(value="Relationship id", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        Identity authenticatedUser = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", ConversationState.getCurrent().getIdentity().getUserId(), true);
        RelationshipManager relationshipManager = (RelationshipManager)CommonsUtils.getService(RelationshipManager.class);
        Relationship relationship = relationshipManager.get(id);
        if (relationship == null || !this.hasPermissionOnRelationship(authenticatedUser, relationship)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        relationshipManager.delete(relationship);
        return EntityBuilder.getResponse(EntityBuilder.buildEntityRelationship(relationship, uriInfo.getPath(), expand, false), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    private boolean hasPermissionOnRelationship(Identity authenticatedUser, Relationship relationship) {
        if (RestUtils.isMemberOfAdminGroup()) {
            return true;
        }
        return authenticatedUser.getId().equals(relationship.getSender().getId()) || authenticatedUser.getId().equals(relationship.getReceiver().getId());
    }

    private void updateRelationshipByStatus(Relationship relationship, Relationship.Type status, RelationshipManager relationshipManager) {
        switch (status) {
            case IGNORED: {
                relationshipManager.delete(relationship);
                break;
            }
            case PENDING: {
                break;
            }
            case CONFIRMED: {
                relationship.setStatus(status);
                relationshipManager.confirm(relationship.getReceiver(), relationship.getSender());
                break;
            }
        }
    }

    private Relationship createRelationshipByStatus(Identity sender, Identity receiver, Relationship.Type status) {
        RelationshipManager relationshipManager = (RelationshipManager)CommonsUtils.getService(RelationshipManager.class);
        switch (status) {
            case IGNORED: {
                break;
            }
            case PENDING: {
                return relationshipManager.inviteToConnect(sender, receiver);
            }
            case CONFIRMED: {
                Relationship relationship = relationshipManager.get(sender, receiver);
                if (relationship == null) {
                    relationshipManager.inviteToConnect(sender, receiver);
                    relationshipManager.confirm(receiver, sender);
                } else {
                    relationshipManager.confirm(receiver, sender);
                }
                return relationshipManager.get(sender, receiver);
            }
        }
        return new Relationship(sender, receiver, status);
    }
}

