/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.viewer;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.artofsolving.jodconverter.office.OfficeException;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.jodconverter.JodConverterService;
import org.exoplatform.services.cms.mimetype.DMSMimeTypeResolver;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.pdfviewer.ObjectKey;
import org.exoplatform.services.pdfviewer.PDFViewerService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.icepdf.core.exceptions.PDFException;
import org.icepdf.core.exceptions.PDFSecurityException;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.Stream;

@Path(value="/pdfviewer/{repoName}/")
public class PDFViewerRESTService
implements ResourceContainer {
    private static final int MAX_NAME_LENGTH = 150;
    private static final String LASTMODIFIED = "Last-Modified";
    private RepositoryService repositoryService_;
    private ExoCache<Serializable, Object> pdfCache;
    private JodConverterService jodConverter_;
    private static final Log LOG = ExoLogger.getLogger((String)PDFViewerRESTService.class.getName());

    public PDFViewerRESTService(RepositoryService repositoryService, CacheService caService, JodConverterService jodConverter) throws Exception {
        this.repositoryService_ = repositoryService;
        this.jodConverter_ = jodConverter;
        PDFViewerService pdfViewerService = (PDFViewerService)WCMCoreUtils.getService(PDFViewerService.class);
        this.pdfCache = pdfViewerService != null ? pdfViewerService.getCache() : caService.getCacheInstance(PDFViewerRESTService.class.getName());
    }

    @GET
    @Path(value="/{workspaceName}/{pageNumber}/{rotation}/{scale}/{uuid}/")
    public Response getCoverImage(@PathParam(value="repoName") String repoName, @PathParam(value="workspaceName") String wsName, @PathParam(value="uuid") String uuid, @PathParam(value="pageNumber") String pageNumber, @PathParam(value="rotation") String rotation, @PathParam(value="scale") String scale) throws Exception {
        return this.getImageByPageNumber(repoName, wsName, uuid, pageNumber, rotation, scale);
    }

    @GET
    @Path(value="/{workspaceName}/{uuid}/")
    public Response getPDFFile(@PathParam(value="repoName") String repoName, @PathParam(value="workspaceName") String wsName, @PathParam(value="uuid") String uuid) throws Exception {
        String fileName;
        FileInputStream is;
        block2: {
            Session session = null;
            is = null;
            fileName = null;
            try {
                ManageableRepository repository = this.repositoryService_.getCurrentRepository();
                session = this.getSystemProvider().getSession(wsName, repository);
                Node currentNode = session.getNodeByUUID(uuid);
                fileName = Utils.getTitle((Node)currentNode);
                File pdfFile = this.getPDFDocumentFile(currentNode, repoName);
                is = new FileInputStream(pdfFile);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)e);
            }
        }
        return Response.ok(is).header("Content-Disposition", (Object)("attachment; filename=\"" + fileName + "\"")).build();
    }

    private Response getImageByPageNumber(String repoName, String wsName, String uuid, String pageNumber, String strRotation, String strScale) throws Exception {
        StringBuilder bd = new StringBuilder();
        StringBuilder bd1 = new StringBuilder();
        bd.append(repoName).append("/").append(wsName).append("/").append(uuid);
        Session session = null;
        try {
            Object objCache = this.pdfCache.get((Serializable)new ObjectKey(bd.toString()));
            InputStream is = null;
            ManageableRepository repository = this.repositoryService_.getCurrentRepository();
            session = this.getSystemProvider().getSession(wsName, repository);
            Node currentNode = session.getNodeByUUID(uuid);
            String lastModified = (String)this.pdfCache.get((Serializable)new ObjectKey(bd1.append(bd.toString()).append("/jcr:lastModified").toString()));
            if (objCache != null) {
                File content = new File((String)this.pdfCache.get((Serializable)new ObjectKey(bd.toString())));
                if (!content.exists()) {
                    this.initDocument(currentNode, repoName);
                }
                is = this.pushToCache(new File((String)this.pdfCache.get((Serializable)new ObjectKey(bd.toString()))), repoName, wsName, uuid, pageNumber, strRotation, strScale, lastModified);
            } else {
                File file = this.getPDFDocumentFile(currentNode, repoName);
                is = this.pushToCache(file, repoName, wsName, uuid, pageNumber, strRotation, strScale, lastModified);
            }
            return Response.ok((Object)is, (String)"image").header(LASTMODIFIED, (Object)lastModified).build();
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e);
            }
            return Response.ok().build();
        }
    }

    private SessionProvider getSystemProvider() {
        SessionProviderService service = (SessionProviderService)WCMCoreUtils.getService(SessionProviderService.class);
        return service.getSystemSessionProvider(null);
    }

    private InputStream pushToCache(File content, String repoName, String wsName, String uuid, String pageNumber, String strRotation, String strScale, String lastModified) throws FileNotFoundException {
        StringBuilder bd = new StringBuilder();
        bd.append(repoName).append("/").append(wsName).append("/").append(uuid).append("/").append(pageNumber).append("/").append(strRotation).append("/").append(strScale);
        StringBuilder bd1 = new StringBuilder().append((CharSequence)bd).append("/jcr:lastModified");
        String filePath = (String)this.pdfCache.get((Serializable)new ObjectKey(bd.toString()));
        String fileModifiedTime = (String)this.pdfCache.get((Serializable)new ObjectKey(bd1.toString()));
        if (filePath == null || !new File(filePath).exists() || !StringUtils.equals((String)lastModified, (String)fileModifiedTime)) {
            File file = this.buildFileImage(content, uuid, pageNumber, strRotation, strScale);
            filePath = file.getPath();
            this.pdfCache.put((Serializable)new ObjectKey(bd.toString()), (Object)filePath);
            this.pdfCache.put((Serializable)new ObjectKey(bd1.toString()), (Object)lastModified);
        }
        return new BufferedInputStream(new FileInputStream(new File(filePath)));
    }

    private Document buildDocumentImage(File input, String name) {
        Document document;
        block8: {
            document = new Document();
            Logger.getLogger(Document.class.toString()).setLevel(Level.OFF);
            try {
                name = this.reduceFileNameSize(name);
                document.setInputStream((InputStream)new BufferedInputStream(new FileInputStream(input)), name);
            }
            catch (PDFException ex) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)("Error parsing PDF document " + (Object)((Object)ex)));
                }
            }
            catch (PDFSecurityException ex) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)("Error encryption not supported " + (Object)((Object)ex)));
                }
            }
            catch (FileNotFoundException ex) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)("Error file not found " + ex));
                }
            }
            catch (IOException ex) {
                if (!LOG.isDebugEnabled()) break block8;
                LOG.debug("Error handling PDF document: {} {}", new Object[]{name, ex.toString()});
            }
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File buildFileImage(File input, String path, String pageNumber, String strRotation, String strScale) {
        BufferedImage image;
        Document document = this.buildDocumentImage(input, path);
        Logger.getLogger(Stream.class.toString()).setLevel(Level.OFF);
        float scale = 1.0f;
        try {
            scale = Float.parseFloat(strScale);
            if (scale > 3.0f) {
                scale = 3.0f;
            }
        }
        catch (NumberFormatException e) {
            scale = 1.0f;
        }
        float rotation = 0.0f;
        try {
            rotation = Float.parseFloat(strRotation);
        }
        catch (NumberFormatException e) {
            rotation = 0.0f;
        }
        int maximumOfPage = document.getNumberOfPages();
        int pageNum = 1;
        try {
            pageNum = Integer.parseInt(pageNumber);
        }
        catch (NumberFormatException e) {
            pageNum = 1;
        }
        if (pageNum >= maximumOfPage) {
            pageNum = maximumOfPage;
        } else if (pageNum < 1) {
            pageNum = 1;
        }
        BufferedImage rendImage = image = (BufferedImage)document.getPageImage(pageNum - 1, 1, 2, rotation, scale);
        File file = null;
        try {
            file = File.createTempFile("imageCapture1_" + pageNum, ".png");
            ImageIO.write((RenderedImage)rendImage, "png", file);
        }
        catch (IOException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e);
            }
        }
        finally {
            image.flush();
            document.dispose();
        }
        return file;
    }

    public Document initDocument(Node currentNode, String repoName) throws Exception {
        return this.buildDocumentImage(this.getPDFDocumentFile(currentNode, repoName), currentNode.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getPDFDocumentFile(Node currentNode, String repoName) throws Exception {
        String wsName = currentNode.getSession().getWorkspace().getName();
        String uuid = currentNode.getUUID();
        StringBuilder bd = new StringBuilder();
        StringBuilder bd1 = new StringBuilder();
        bd.append(repoName).append("/").append(wsName).append("/").append(uuid);
        bd1.append((CharSequence)bd).append("/jcr:lastModified");
        String path = (String)this.pdfCache.get((Serializable)new ObjectKey(bd.toString()));
        String lastModifiedTime = (String)this.pdfCache.get((Serializable)new ObjectKey(bd1.toString()));
        File content = null;
        String name = currentNode.getName().replaceAll(":", "_");
        Node contentNode = currentNode.getNode("jcr:content");
        String lastModified = this.getJcrLastModified(currentNode);
        if (path == null || !(content = new File(path)).exists() || !lastModified.equals(lastModifiedTime)) {
            String mimeType = contentNode.getProperty("jcr:mimeType").getString();
            BufferedInputStream input = new BufferedInputStream(contentNode.getProperty("jcr:data").getStream());
            if (name.indexOf(".") > 0) {
                name = name.substring(0, name.lastIndexOf("."));
            }
            name = this.reduceFileNameSize(name);
            content = File.createTempFile(name + "_tmp", ".pdf");
            String extension = DMSMimeTypeResolver.getInstance().getExtension(mimeType);
            if ("pdf".equals(extension)) {
                this.read(input, new BufferedOutputStream(new FileOutputStream(content)));
            } else {
                File in = File.createTempFile(name + "_tmp", "." + extension);
                this.read(input, new BufferedOutputStream(new FileOutputStream(in)));
                try {
                    boolean success = this.jodConverter_.convert(in, content, "pdf");
                    if (!success) {
                        content.delete();
                    }
                }
                catch (OfficeException connection) {
                    content.delete();
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)"Exception when using Office Service");
                    }
                }
                finally {
                    in.delete();
                }
            }
            if (content.exists()) {
                this.pdfCache.put((Serializable)new ObjectKey(bd.toString()), (Object)content.getPath());
                this.pdfCache.put((Serializable)new ObjectKey(bd1.toString()), (Object)lastModified);
            }
        }
        return content;
    }

    private String getJcrLastModified(Node node) throws Exception {
        Node checkedNode = node;
        if (node.isNodeType("nt:frozenNode")) {
            checkedNode = node.getSession().getNodeByUUID(node.getProperty("jcr:frozenUuid").getString());
        }
        return Utils.getJcrContentLastModified((Node)checkedNode);
    }

    private void read(InputStream is, OutputStream os) throws Exception {
        int bufferLength = 1024;
        int readLength = 0;
        while (readLength > -1) {
            byte[] chunk = new byte[bufferLength];
            readLength = is.read(chunk);
            if (readLength <= 0) continue;
            os.write(chunk, 0, readLength);
        }
        os.flush();
        os.close();
    }

    private String reduceFileNameSize(String name) {
        return name != null && name.length() > 150 ? name.substring(0, 150) : name;
    }
}

