/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import uk.ac.ed.ph.snuggletex.ErrorCode;
import uk.ac.ed.ph.snuggletex.InputError;
import uk.ac.ed.ph.snuggletex.SnuggleLogicException;
import uk.ac.ed.ph.snuggletex.definitions.BuiltinCommand;
import uk.ac.ed.ph.snuggletex.definitions.BuiltinEnvironment;
import uk.ac.ed.ph.snuggletex.definitions.GlobalBuiltins;
import uk.ac.ed.ph.snuggletex.definitions.LaTeXMode;
import uk.ac.ed.ph.snuggletex.definitions.TextFlowContext;
import uk.ac.ed.ph.snuggletex.internal.FrozenSlice;
import uk.ac.ed.ph.snuggletex.internal.SessionContext;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.semantics.InterpretationType;
import uk.ac.ed.ph.snuggletex.semantics.MathBracketOperatorInterpretation;
import uk.ac.ed.ph.snuggletex.semantics.MathIdentifierInterpretation;
import uk.ac.ed.ph.snuggletex.semantics.MathMLOperator;
import uk.ac.ed.ph.snuggletex.semantics.MathNumberInterpretation;
import uk.ac.ed.ph.snuggletex.semantics.MathOperatorInterpretation;
import uk.ac.ed.ph.snuggletex.semantics.SimpleMathOperatorInterpretation;
import uk.ac.ed.ph.snuggletex.tokens.ArgumentContainerToken;
import uk.ac.ed.ph.snuggletex.tokens.BraceContainerToken;
import uk.ac.ed.ph.snuggletex.tokens.CommandToken;
import uk.ac.ed.ph.snuggletex.tokens.EnvironmentToken;
import uk.ac.ed.ph.snuggletex.tokens.ErrorToken;
import uk.ac.ed.ph.snuggletex.tokens.FlowToken;
import uk.ac.ed.ph.snuggletex.tokens.SimpleToken;
import uk.ac.ed.ph.snuggletex.tokens.Token;
import uk.ac.ed.ph.snuggletex.tokens.TokenType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenFixer {
    private final SessionContext sessionContext;
    public boolean tryInferStructure = true;

    public TokenFixer(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public void fixTokenTree(ArgumentContainerToken token) throws SnuggleParseException {
        this.visitBranch(token);
    }

    private void visitBranch(Token rootToken) throws SnuggleParseException {
        switch (rootToken.getType()) {
            case ARGUMENT_CONTAINER: {
                this.visitContainerContent((ArgumentContainerToken)rootToken);
                break;
            }
            case COMMAND: {
                this.visitCommand((CommandToken)rootToken);
                break;
            }
            case ENVIRONMENT: {
                this.visitEnvironment((EnvironmentToken)rootToken);
                break;
            }
            case TEXT_MODE_TEXT: {
                break;
            }
            case BRACE_CONTAINER: {
                this.visitContainerContent(((BraceContainerToken)rootToken).getBraceContent());
                break;
            }
            case VERBATIM_MODE_TEXT: 
            case LR_MODE_NEW_PARAGRAPH: 
            case MATH_NUMBER: 
            case SINGLE_CHARACTER_MATH_IDENTIFIER: 
            case SINGLE_CHARACTER_MATH_SPECIAL: 
            case ERROR: 
            case TAB_CHARACTER: {
                break;
            }
            case NEW_PARAGRAPH: {
                throw new SnuggleLogicException("Unfixed " + (Object)((Object)rootToken.getType()) + " token: " + rootToken);
            }
            default: {
                throw new SnuggleLogicException("Unhandled type " + (Object)((Object)rootToken.getType()));
            }
        }
    }

    private void visitEnvironment(EnvironmentToken environmentToken) throws SnuggleParseException {
        BuiltinEnvironment environment = environmentToken.getEnvironment();
        if (environment == GlobalBuiltins.ENV_ITEMIZE || environment == GlobalBuiltins.ENV_ENUMERATE) {
            this.fixListEnvironmentContent(environmentToken);
        } else if (environment == GlobalBuiltins.ENV_TABULAR || environment == GlobalBuiltins.ENV_ARRAY || environment == GlobalBuiltins.ENV_EQNARRAY || environment == GlobalBuiltins.ENV_EQNARRAYSTAR) {
            this.fixTabularEnvironmentContent(environmentToken);
        }
        if (environment != GlobalBuiltins.ENV_BRACKETED) {
            ArgumentContainerToken[] arguments;
            ArgumentContainerToken optArgument = environmentToken.getOptionalArgument();
            if (optArgument != null) {
                this.visitContainerContent(optArgument);
            }
            if ((arguments = environmentToken.getArguments()) != null) {
                for (ArgumentContainerToken argument : arguments) {
                    this.visitContainerContent(argument);
                }
            }
        }
        this.visitContainerContent(environmentToken.getContent());
    }

    private void visitCommand(CommandToken commandToken) throws SnuggleParseException {
        ArgumentContainerToken[] arguments;
        ArgumentContainerToken optArgument = commandToken.getOptionalArgument();
        if (optArgument != null) {
            this.visitContainerContent(optArgument);
        }
        if ((arguments = commandToken.getArguments()) != null) {
            for (ArgumentContainerToken argument : arguments) {
                this.visitContainerContent(argument);
            }
        }
    }

    private void visitContainerContent(ArgumentContainerToken parent) throws SnuggleParseException {
        List<FlowToken> content = parent.getContents();
        switch (parent.getLatexMode()) {
            case PARAGRAPH: {
                this.visitSiblingsParagraphMode(parent, content);
                break;
            }
            case LR: {
                this.visitSiblingsLRMode(parent, content);
                break;
            }
            case MATH: {
                this.visitSiblingsMathMode(parent, content);
                break;
            }
            case VERBATIM: {
                break;
            }
            default: {
                throw new SnuggleLogicException("Unhandled mode " + (Object)((Object)parent.getLatexMode()));
            }
        }
    }

    private void visitSiblingsParagraphMode(Token parentToken, List<FlowToken> tokens) throws SnuggleParseException {
        this.groupStyleCommands(parentToken, tokens);
        this.stripRedundantWhitespaceTokens(tokens);
        this.inferParagraphs(tokens);
        for (FlowToken token : tokens) {
            this.visitBranch(token);
        }
    }

    private void groupStyleCommands(Token parentToken, List<FlowToken> tokens) {
        for (int i = 0; i < tokens.size(); ++i) {
            FlowToken token = tokens.get(i);
            if (token.getType() != TokenType.COMMAND || !token.isInterpretationType(InterpretationType.STYLE_DECLARATION) || ((CommandToken)token).getCommand().getArgumentCount() != 0) continue;
            CommandToken commandToken = (CommandToken)token;
            BuiltinCommand command = commandToken.getCommand();
            BuiltinEnvironment environment = this.sessionContext.getEnvironmentByTeXName(command.getTeXName());
            if (environment == null) {
                throw new SnuggleLogicException("No environment defined to replace old TeX command " + command);
            }
            if (i + 1 < tokens.size()) {
                FlowToken lastToken = tokens.get(tokens.size() - 1);
                ArgumentContainerToken contentToken = ArgumentContainerToken.createFromContiguousTokens(parentToken, token.getLatexMode(), tokens, i + 1, tokens.size());
                FrozenSlice replacementSlice = token.getSlice().rightOuterSpan(lastToken.getSlice());
                EnvironmentToken replacement = new EnvironmentToken(replacementSlice, token.getLatexMode(), environment, contentToken);
                tokens.set(i, replacement);
                tokens.subList(i + 1, tokens.size()).clear();
                break;
            }
            ArgumentContainerToken contentToken = ArgumentContainerToken.createEmptyContainer(token, token.getLatexMode());
            EnvironmentToken replacement = new EnvironmentToken(token.getSlice(), token.getLatexMode(), environment, contentToken);
            tokens.set(i, replacement);
            break;
        }
    }

    private void stripRedundantWhitespaceTokens(List<FlowToken> tokens) {
        int i = 0;
        while (i < tokens.size()) {
            FlowToken token = tokens.get(i);
            if (token.getType() == TokenType.TEXT_MODE_TEXT) {
                boolean blockAfter;
                if ((i == 0 || i == tokens.size() - 1) && token.getSlice().isWhitespace()) {
                    tokens.remove(i);
                    continue;
                }
                boolean blockBefore = i == 0 || tokens.get(i - 1).getTextFlowContext() == TextFlowContext.START_NEW_XHTML_BLOCK;
                boolean bl = blockAfter = i == tokens.size() - 1 || tokens.get(i + 1).getTextFlowContext() == TextFlowContext.START_NEW_XHTML_BLOCK;
                if (blockBefore && blockAfter && token.getSlice().isWhitespace()) {
                    tokens.remove(i);
                    continue;
                }
            }
            ++i;
        }
    }

    private void inferParagraphs(List<FlowToken> tokens) {
        ArrayList<FlowToken> paragraphBuilder = new ArrayList<FlowToken>();
        ArrayList<FlowToken> resultBuilder = new ArrayList<FlowToken>();
        int paragraphCount = 0;
        boolean hasParagraphs = false;
        for (int i = 0; i < tokens.size(); ++i) {
            FlowToken token = tokens.get(i);
            if (token.getType() == TokenType.NEW_PARAGRAPH || token.isCommand(GlobalBuiltins.CMD_PAR)) {
                hasParagraphs = true;
                if (paragraphBuilder.isEmpty()) continue;
                resultBuilder.add(this.buildGroupedCommandToken(token, GlobalBuiltins.CMD_PARAGRAPH, paragraphBuilder));
                ++paragraphCount;
                continue;
            }
            if (token.getTextFlowContext() == TextFlowContext.START_NEW_XHTML_BLOCK) {
                hasParagraphs = true;
                if (!paragraphBuilder.isEmpty()) {
                    CommandToken leftOver = this.buildGroupedCommandToken(tokens.get(0), GlobalBuiltins.CMD_PARAGRAPH, paragraphBuilder);
                    resultBuilder.add(leftOver);
                    ++paragraphCount;
                }
                resultBuilder.add(token);
                continue;
            }
            if (token.getTextFlowContext() == TextFlowContext.IGNORE && paragraphBuilder.isEmpty()) {
                resultBuilder.add(token);
                continue;
            }
            paragraphBuilder.add(token);
        }
        if (!hasParagraphs) {
            return;
        }
        if (!paragraphBuilder.isEmpty()) {
            CommandToken leftOver = this.buildGroupedCommandToken(tokens.get(0), GlobalBuiltins.CMD_PARAGRAPH, paragraphBuilder);
            resultBuilder.add(leftOver);
            ++paragraphCount;
        }
        tokens.clear();
        if (paragraphCount > 1) {
            tokens.addAll(resultBuilder);
        } else {
            for (FlowToken resultToken : resultBuilder) {
                if (resultToken.isCommand(GlobalBuiltins.CMD_PARAGRAPH)) {
                    tokens.addAll(((CommandToken)resultToken).getArguments()[0].getContents());
                    continue;
                }
                tokens.add(resultToken);
            }
        }
    }

    private void visitSiblingsLRMode(Token parentToken, List<FlowToken> tokens) throws SnuggleParseException {
        this.groupStyleCommands(parentToken, tokens);
        this.stripBlocks(tokens);
        for (FlowToken token : tokens) {
            this.visitBranch(token);
        }
    }

    private void stripBlocks(List<FlowToken> tokens) throws SnuggleParseException {
        for (int i = 0; i < tokens.size(); ++i) {
            FlowToken token = tokens.get(i);
            if (token.getType() == TokenType.NEW_PARAGRAPH || token.isCommand(GlobalBuiltins.CMD_PAR)) {
                tokens.set(i, new SimpleToken(token.getSlice(), TokenType.LR_MODE_NEW_PARAGRAPH, LaTeXMode.LR, TextFlowContext.ALLOW_INLINE));
                continue;
            }
            if (token.getType() == TokenType.ERROR || token.getTextFlowContext() != TextFlowContext.START_NEW_XHTML_BLOCK) continue;
            tokens.set(i, this.createError(token, ErrorCode.TFEG00, ((Object)token.getSlice().extract()).toString()));
        }
    }

    private void fixListEnvironmentContent(EnvironmentToken environmentToken) throws SnuggleParseException {
        List<FlowToken> contents = environmentToken.getContent().getContents();
        ArrayList<FlowToken> itemBuilder = new ArrayList<FlowToken>();
        ArrayList<FlowToken> resultBuilder = new ArrayList<FlowToken>();
        boolean foundItem = false;
        int size = contents.size();
        for (int i = 0; i < size; ++i) {
            FlowToken token = contents.get(i);
            if (token.isCommand(GlobalBuiltins.CMD_ITEM)) {
                if (foundItem) {
                    CommandToken itemBefore = this.buildGroupedCommandToken(environmentToken, GlobalBuiltins.CMD_LIST_ITEM, itemBuilder);
                    resultBuilder.add(itemBefore);
                }
                foundItem = true;
                continue;
            }
            if (!foundItem) {
                if (token.getType() == TokenType.TEXT_MODE_TEXT && token.getSlice().isWhitespace() || token.getType() == TokenType.NEW_PARAGRAPH) continue;
                resultBuilder.add(this.createError(token, ErrorCode.TFEL00, new Object[0]));
                continue;
            }
            itemBuilder.add(token);
        }
        if (foundItem) {
            resultBuilder.add(this.buildGroupedCommandToken(environmentToken, GlobalBuiltins.CMD_LIST_ITEM, itemBuilder));
        }
        contents.clear();
        contents.addAll(resultBuilder);
    }

    private void fixTabularEnvironmentContent(EnvironmentToken environmentToken) throws SnuggleParseException {
        ArrayList<FlowToken> resultBuilder = new ArrayList<FlowToken>();
        ArrayList<CommandToken> rowBuilder = new ArrayList<CommandToken>();
        ArrayList<FlowToken> columnBuilder = new ArrayList<FlowToken>();
        List<FlowToken> contents = environmentToken.getContent().getContents();
        List<FlowToken> entries = contents;
        if (entries.size() > 0 && !entries.get(entries.size() - 1).isCommand(GlobalBuiltins.CMD_CHAR_BACKSLASH)) {
            entries = new ArrayList<FlowToken>(entries);
            entries.add(null);
        }
        Token lastGoodToken = null;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            FlowToken token = entries.get(i);
            if (token == null || token.isCommand(GlobalBuiltins.CMD_CHAR_BACKSLASH)) {
                if (token == null && lastGoodToken != null && lastGoodToken.isCommand(GlobalBuiltins.CMD_HLINE)) break;
                rowBuilder.add(this.buildGroupedCommandToken(environmentToken, GlobalBuiltins.CMD_TABLE_COLUMN, columnBuilder));
                resultBuilder.add(this.buildGroupedCommandToken(environmentToken, GlobalBuiltins.CMD_TABLE_ROW, rowBuilder));
            } else {
                if (token.getType() == TokenType.TEXT_MODE_TEXT && token.getSlice().isWhitespace()) continue;
                if (token.getType() == TokenType.TAB_CHARACTER) {
                    rowBuilder.add(this.buildGroupedCommandToken(environmentToken, GlobalBuiltins.CMD_TABLE_COLUMN, columnBuilder));
                } else if (token.isCommand(GlobalBuiltins.CMD_HLINE)) {
                    if (!columnBuilder.isEmpty()) {
                        resultBuilder.add(this.createError((FlowToken)columnBuilder.get(0), ErrorCode.TFETB0, new Object[0]));
                        columnBuilder.clear();
                    } else if (!rowBuilder.isEmpty()) {
                        resultBuilder.add(this.createError((FlowToken)rowBuilder.get(0), ErrorCode.TFETB0, new Object[0]));
                        rowBuilder.clear();
                    }
                    resultBuilder.add(token);
                } else {
                    columnBuilder.add(token);
                }
            }
            lastGoodToken = token;
        }
        contents.clear();
        contents.addAll(resultBuilder);
    }

    private void visitSiblingsMathMode(ArgumentContainerToken parentToken, List<FlowToken> tokens) throws SnuggleParseException {
        BuiltinCommand command;
        if (tokens.isEmpty()) {
            return;
        }
        boolean isStructural = false;
        FlowToken firstToken = tokens.get(0);
        if (firstToken.getType() == TokenType.COMMAND && ((command = ((CommandToken)firstToken).getCommand()) == GlobalBuiltins.CMD_TABLE_ROW || command == GlobalBuiltins.CMD_TABLE_COLUMN)) {
            isStructural = true;
        }
        if (!isStructural) {
            this.fixLeadingNegativeNumber(tokens);
            this.groupStyleCommands(parentToken, tokens);
            this.fencePairedParentheses(parentToken, tokens);
            this.fixOverInstances(parentToken, tokens);
            this.inferParenthesisFences(parentToken, tokens);
            this.fixSubscriptAndSuperscripts(parentToken, tokens);
            this.fixPrimes(tokens);
        }
        for (FlowToken token : tokens) {
            this.visitBranch(token);
        }
    }

    private void fixLeadingNegativeNumber(List<FlowToken> tokens) {
        if (tokens.size() < 2) {
            return;
        }
        FlowToken firstToken = tokens.get(0);
        FlowToken secondToken = tokens.get(1);
        if (firstToken.isInterpretationType(InterpretationType.MATH_OPERATOR) && ((MathOperatorInterpretation)firstToken.getInterpretation()).getOperator() == MathMLOperator.SUBTRACT && secondToken.isInterpretationType(InterpretationType.MATH_NUMBER)) {
            String negation = "-" + ((MathNumberInterpretation)secondToken.getInterpretation()).getNumber();
            SimpleToken replacementToken = new SimpleToken(firstToken.getSlice().rightOuterSpan(secondToken.getSlice()), TokenType.MATH_NUMBER, firstToken.getLatexMode(), new MathNumberInterpretation(negation), null);
            tokens.remove(0);
            tokens.set(0, replacementToken);
        }
    }

    private void fixOverInstances(ArgumentContainerToken parentToken, List<FlowToken> tokens) throws SnuggleParseException {
        int overIndex = -1;
        for (int i = 0; i < tokens.size(); ++i) {
            FlowToken token = tokens.get(i);
            if (!token.isCommand(GlobalBuiltins.CMD_OVER)) continue;
            if (overIndex != -1) {
                tokens.clear();
                tokens.add(this.createError(token, ErrorCode.TFEM00, new Object[0]));
                return;
            }
            overIndex = i;
        }
        if (overIndex != -1) {
            ArrayList<FlowToken> beforeTokens = new ArrayList<FlowToken>(tokens.subList(0, overIndex));
            ArrayList<FlowToken> afterTokens = new ArrayList<FlowToken>(tokens.subList(overIndex + 1, tokens.size()));
            CommandToken replacement = new CommandToken(parentToken.getSlice(), LaTeXMode.MATH, GlobalBuiltins.CMD_FRAC, null, new ArgumentContainerToken[]{ArgumentContainerToken.createFromContiguousTokens(parentToken, LaTeXMode.MATH, beforeTokens), ArgumentContainerToken.createFromContiguousTokens(parentToken, LaTeXMode.MATH, afterTokens)});
            tokens.clear();
            tokens.add(replacement);
        }
    }

    private void fixPrimes(List<FlowToken> tokens) {
        for (int i = 0; i < tokens.size() - 1; ++i) {
            FlowToken maybePrimeToken = tokens.get(i + 1);
            if (!maybePrimeToken.isInterpretationType(InterpretationType.MATH_IDENTIFIER) || !((MathIdentifierInterpretation)maybePrimeToken.getInterpretation()).getName().equals("'")) continue;
            FlowToken leftToken = tokens.get(i);
            FrozenSlice replacementSlice = leftToken.getSlice().rightOuterSpan(maybePrimeToken.getSlice());
            CommandToken replacementToken = new CommandToken(replacementSlice, LaTeXMode.MATH, GlobalBuiltins.CMD_MSUP_OR_MOVER, null, new ArgumentContainerToken[]{ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, leftToken), ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, maybePrimeToken)});
            tokens.set(i, replacementToken);
            tokens.remove(i + 1);
        }
    }

    private void fixSubscriptAndSuperscripts(Token parentToken, List<FlowToken> tokens) throws SnuggleParseException {
        MathMLOperator tokenOperator = null;
        for (int i = 0; i < tokens.size(); ++i) {
            CommandToken replacement;
            BuiltinCommand replacementCommand;
            FrozenSlice replacementSlice;
            int startModifyIndex;
            FlowToken t1;
            int size = tokens.size();
            FlowToken subOrSuperToken = tokens.get(i);
            boolean firstIsSuper = false;
            boolean isSubOrSuper = false;
            if (subOrSuperToken.isInterpretationType(InterpretationType.MATH_OPERATOR)) {
                SimpleMathOperatorInterpretation tokenInterp = (SimpleMathOperatorInterpretation)subOrSuperToken.getInterpretation();
                tokenOperator = tokenInterp.getOperator();
                boolean bl = isSubOrSuper = tokenOperator == MathMLOperator.SUPER || tokenOperator == MathMLOperator.SUB;
            }
            if (!isSubOrSuper) continue;
            if (i == size - 1) {
                tokens.set(i, this.createError(subOrSuperToken, ErrorCode.TFEM01, new Object[0]));
                continue;
            }
            if (i == 0) {
                ArgumentContainerToken emptyBeforeContainer = ArgumentContainerToken.createEmptyContainer(parentToken, LaTeXMode.MATH);
                t1 = new BraceContainerToken(emptyBeforeContainer.getSlice(), LaTeXMode.MATH, emptyBeforeContainer);
                startModifyIndex = i;
            } else {
                t1 = tokens.get(i - 1);
                startModifyIndex = i - 1;
            }
            FlowToken t2 = tokens.get(i + 1);
            Token t3 = null;
            MathMLOperator followingOperator = null;
            if (i + 2 < size && tokens.get(i + 2).isInterpretationType(InterpretationType.MATH_OPERATOR) && ((followingOperator = ((SimpleMathOperatorInterpretation)tokens.get(i + 2).getInterpretation()).getOperator()) == MathMLOperator.SUPER || followingOperator == MathMLOperator.SUB)) {
                if (i + 3 >= size) {
                    tokens.set(i - 1, this.createError(subOrSuperToken, ErrorCode.TFEM01, new Object[0]));
                    tokens.subList(i, i + 3).clear();
                    continue;
                }
                t3 = tokens.get(i + 3);
                if (tokenOperator == MathMLOperator.SUPER && followingOperator == MathMLOperator.SUPER || tokenOperator == MathMLOperator.SUB && followingOperator == MathMLOperator.SUB) {
                    tokens.set(i - 1, this.createError(subOrSuperToken, ErrorCode.TFEM02, new Object[0]));
                    tokens.subList(i, i + 3).clear();
                    continue;
                }
            }
            boolean bl = firstIsSuper = tokenOperator == MathMLOperator.SUPER;
            if (t3 != null) {
                replacementSlice = t1.getSlice().rightOuterSpan(t3.getSlice());
                replacementCommand = GlobalBuiltins.CMD_MSUBSUP_OR_MUNDEROVER;
                replacement = new CommandToken(replacementSlice, LaTeXMode.MATH, replacementCommand, null, new ArgumentContainerToken[]{ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, t1), firstIsSuper ? ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, (FlowToken)t3) : ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, t2), firstIsSuper ? ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, t2) : ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, (FlowToken)t3)});
                tokens.set(startModifyIndex, replacement);
                tokens.subList(startModifyIndex + 1, i + 4).clear();
                continue;
            }
            replacementSlice = t1.getSlice().rightOuterSpan(t2.getSlice());
            replacementCommand = firstIsSuper ? GlobalBuiltins.CMD_MSUP_OR_MOVER : GlobalBuiltins.CMD_MSUB_OR_MUNDER;
            replacement = new CommandToken(replacementSlice, LaTeXMode.MATH, replacementCommand, null, new ArgumentContainerToken[]{ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, t1), ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, t2)});
            tokens.set(startModifyIndex, replacement);
            tokens.subList(startModifyIndex + 1, i + 2).clear();
        }
    }

    private void fencePairedParentheses(Token parentToken, List<FlowToken> tokens) throws SnuggleParseException {
        for (int i = 0; i < tokens.size(); ++i) {
            FlowToken token = tokens.get(i);
            if (token.isCommand(GlobalBuiltins.CMD_RIGHT)) {
                tokens.set(i, this.createError(token, ErrorCode.TFEM03, new Object[0]));
                continue;
            }
            if (!token.isCommand(GlobalBuiltins.CMD_LEFT)) continue;
            ArrayList<FlowToken> innerTokens = new ArrayList<FlowToken>();
            CommandToken openBracketToken = (CommandToken)token;
            Token matchingCloseBracketToken = null;
            int matchingCloseBracketIndex = -1;
            int bracketLevel = 1;
            for (int j = i + 1; j < tokens.size(); ++j) {
                FlowToken innerToken = tokens.get(j);
                if (innerToken.isCommand(GlobalBuiltins.CMD_LEFT)) {
                    ++bracketLevel;
                } else if (innerToken.isCommand(GlobalBuiltins.CMD_RIGHT) && --bracketLevel == 0) {
                    matchingCloseBracketToken = (CommandToken)innerToken;
                    matchingCloseBracketIndex = j;
                    break;
                }
                innerTokens.add(innerToken);
            }
            if (matchingCloseBracketToken == null) {
                tokens.set(i, this.createError(token, ErrorCode.TFEM04, new Object[0]));
                tokens.subList(i + 1, tokens.size()).clear();
                break;
            }
            FrozenSlice replacementSlice = openBracketToken.getSlice().rightOuterSpan(matchingCloseBracketToken.getSlice());
            EnvironmentToken replacementToken = new EnvironmentToken(replacementSlice, LaTeXMode.MATH, GlobalBuiltins.ENV_BRACKETED, null, new ArgumentContainerToken[]{ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, openBracketToken.getCombinerTarget()), ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, ((CommandToken)matchingCloseBracketToken).getCombinerTarget())}, ArgumentContainerToken.createFromContiguousTokens(parentToken, LaTeXMode.MATH, innerTokens));
            tokens.set(i, replacementToken);
            tokens.subList(i + 1, matchingCloseBracketIndex + 1).clear();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void inferParenthesisFences(Token parentToken, List<FlowToken> tokens) {
        int i = 0;
        while (i < tokens.size()) {
            FlowToken token = tokens.get(i);
            if (token.isInterpretationType(InterpretationType.MATH_BRACKET_OPERATOR)) {
                MathBracketOperatorInterpretation interpretation = (MathBracketOperatorInterpretation)token.getInterpretation();
                MathBracketOperatorInterpretation.BracketType bracketType = interpretation.getBracketType();
                if (bracketType == MathBracketOperatorInterpretation.BracketType.CLOSER) {
                    FrozenSlice replacementSlice = tokens.get(0).getSlice().rightOuterSpan(token.getSlice());
                    ArrayList<FlowToken> innerTokens = new ArrayList<FlowToken>(tokens.subList(0, i));
                    EnvironmentToken replacementToken = new EnvironmentToken(replacementSlice, LaTeXMode.MATH, GlobalBuiltins.ENV_BRACKETED, null, new ArgumentContainerToken[]{ArgumentContainerToken.createEmptyContainer(parentToken, LaTeXMode.MATH), ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, token)}, ArgumentContainerToken.createFromContiguousTokens(parentToken, LaTeXMode.MATH, innerTokens));
                    tokens.set(0, replacementToken);
                    tokens.subList(1, i + 1).clear();
                    i = 0;
                } else if (bracketType != MathBracketOperatorInterpretation.BracketType.OPENER_OR_CLOSER) {
                    EnvironmentToken replacementToken;
                    FrozenSlice replacementSlice;
                    ArrayList<FlowToken> innerTokens = new ArrayList<FlowToken>();
                    FlowToken openBracketToken = token;
                    Token matchingCloseBracketToken = null;
                    int matchingCloseBracketIndex = -1;
                    Stack<MathBracketOperatorInterpretation> openerStack = new Stack<MathBracketOperatorInterpretation>();
                    openerStack.add(interpretation);
                    block6: for (int j = i + 1; j < tokens.size(); ++j) {
                        FlowToken afterToken = tokens.get(j);
                        if (afterToken.isInterpretationType(InterpretationType.MATH_BRACKET_OPERATOR)) {
                            MathBracketOperatorInterpretation afterInterpretation = (MathBracketOperatorInterpretation)afterToken.getInterpretation();
                            MathBracketOperatorInterpretation.BracketType afterBracketType = afterInterpretation.getBracketType();
                            switch (afterBracketType) {
                                case OPENER: {
                                    openerStack.add(afterInterpretation);
                                    break;
                                }
                                case OPENER_OR_CLOSER: {
                                    break;
                                }
                                case CLOSER: {
                                    openerStack.pop();
                                    if (!openerStack.isEmpty()) break;
                                    matchingCloseBracketToken = afterToken;
                                    matchingCloseBracketIndex = j;
                                    break block6;
                                }
                            }
                        }
                        innerTokens.add(afterToken);
                    }
                    if (matchingCloseBracketToken != null) {
                        replacementSlice = openBracketToken.getSlice().rightOuterSpan(matchingCloseBracketToken.getSlice());
                        replacementToken = new EnvironmentToken(replacementSlice, LaTeXMode.MATH, GlobalBuiltins.ENV_BRACKETED, null, new ArgumentContainerToken[]{ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, openBracketToken), ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, (FlowToken)matchingCloseBracketToken)}, ArgumentContainerToken.createFromContiguousTokens(parentToken, LaTeXMode.MATH, innerTokens));
                        tokens.set(i, replacementToken);
                        tokens.subList(i + 1, matchingCloseBracketIndex + 1).clear();
                    } else {
                        replacementSlice = openBracketToken.getSlice().rightOuterSpan(tokens.get(tokens.size() - 1).getSlice());
                        replacementToken = new EnvironmentToken(replacementSlice, LaTeXMode.MATH, GlobalBuiltins.ENV_BRACKETED, null, new ArgumentContainerToken[]{ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, openBracketToken), ArgumentContainerToken.createEmptyContainer(parentToken, LaTeXMode.MATH)}, ArgumentContainerToken.createFromContiguousTokens(parentToken, LaTeXMode.MATH, innerTokens));
                        tokens.set(i, replacementToken);
                        tokens.subList(i + 1, tokens.size()).clear();
                    }
                }
            }
            ++i;
        }
        return;
    }

    private CommandToken buildGroupedCommandToken(Token parentToken, BuiltinCommand command, List<? extends FlowToken> itemBuilder) {
        ArgumentContainerToken contentToken = itemBuilder.isEmpty() ? ArgumentContainerToken.createEmptyContainer(parentToken, parentToken.getLatexMode()) : ArgumentContainerToken.createFromContiguousTokens(parentToken, itemBuilder.get(0).getLatexMode(), itemBuilder);
        CommandToken result = new CommandToken(contentToken.getSlice(), contentToken.getLatexMode(), command, null, new ArgumentContainerToken[]{contentToken});
        itemBuilder.clear();
        return result;
    }

    private ErrorToken createError(FlowToken token, ErrorCode errorCode, Object ... arguments) throws SnuggleParseException {
        FrozenSlice slice = token.getSlice();
        InputError error = new InputError(errorCode, slice, arguments);
        this.sessionContext.registerError(error);
        return new ErrorToken(error, token.getLatexMode());
    }
}

