/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.gadget.core;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Names;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.util.ResourceLoader;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.oauth.BasicOAuthStore;
import org.apache.shindig.gadgets.oauth.BasicOAuthStoreConsumerKeyAndSecret;
import org.apache.shindig.gadgets.oauth.OAuthModule;
import org.apache.shindig.gadgets.oauth.OAuthRequest;
import org.apache.shindig.gadgets.oauth.OAuthStore;
import org.exoplatform.portal.gadget.core.ExoOAuthStore;
import org.exoplatform.portal.gadget.core.GateInContainerConfigLoader;
import org.exoplatform.portal.gadget.core.GateInGuiceServletContextListener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ExoOAuthModule
extends OAuthModule {
    public static final String SIGNING_KEY_FILE = "gadgets.signingKeyFile";
    private static final String SIGNING_KEY_NAME = "gadgets.signingKeyName";
    private static final String CALLBACK_URL = "gadgets.signing.global-callback-url";
    private static final String OAUTH_CONFIG = "config/oauth.json";
    private static final Log log = ExoLogger.getLogger(OAuthModule.class);

    protected void configure() {
        this.bind(BlobCrypter.class).annotatedWith((Annotation)Names.named((String)"shindig.oauth.state-crypter")).toProvider(OAuthModule.OAuthCrypterProvider.class);
        this.bind(OAuthStore.class).toProvider(ExoOAuthStoreProvider.class);
        this.bind(OAuthRequest.class).toProvider(OAuthModule.OAuthRequestProvider.class);
        this.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)"shindig.allowUnauthenticated")).toInstance((Object)Boolean.TRUE);
    }

    @Singleton
    public static class ExoOAuthStoreProvider
    implements Provider<OAuthStore> {
        private final ExoOAuthStore store = new ExoOAuthStore();

        @Inject
        public ExoOAuthStoreProvider(ContainerConfig config) {
            String signingKeyFile = config.getString("default", ExoOAuthModule.SIGNING_KEY_FILE);
            String signingKeyName = config.getString("default", ExoOAuthModule.SIGNING_KEY_NAME);
            this.loadDefaultKey(signingKeyFile, signingKeyName);
            String defaultCallbackUrl = config.getString("default", ExoOAuthModule.CALLBACK_URL);
            this.store.setDefaultCallbackUrl(defaultCallbackUrl);
            this.loadConsumers();
        }

        private void loadDefaultKey(String signingKeyFile, String signingKeyName) {
            BasicOAuthStoreConsumerKeyAndSecret key = null;
            if (!StringUtils.isBlank((String)signingKeyFile)) {
                try {
                    log.info((Object)("Loading OAuth signing key from " + signingKeyFile));
                    String privateKey = IOUtils.toString((InputStream)ResourceLoader.open((String)signingKeyFile), (String)"UTF-8");
                    privateKey = BasicOAuthStore.convertFromOpenSsl((String)privateKey);
                    key = new BasicOAuthStoreConsumerKeyAndSecret(null, privateKey, BasicOAuthStoreConsumerKeyAndSecret.KeyType.RSA_PRIVATE, signingKeyName, null);
                }
                catch (Throwable t) {
                    log.warn((Object)("Couldn't load key file " + signingKeyFile));
                }
            }
            if (key != null) {
                this.store.setDefaultKey(key);
            } else {
                log.warn((Object)"Couldn't load OAuth signing key.  To create a key, run:\n  openssl req -newkey rsa:1024 -days 365 -nodes -x509 -keyout testkey.pem \\\n     -out testkey.pem -subj '/CN=mytestkey'\n  openssl pkcs8 -in testkey.pem -out oauthkey.pem -topk8 -nocrypt -outform PEM\n\nThen edit gadgets.properties and add these lines:\ngadgets.signingKeyFile=<path-to-oauthkey.pem>\n");
            }
        }

        private void loadConsumers() {
            try {
                GateInContainerConfigLoader currentLoader = GateInGuiceServletContextListener.getCurrentLoader();
                String oauthConfigString = currentLoader.loadContentAsString(ExoOAuthModule.OAUTH_CONFIG, "UTF-8");
                this.store.initFromConfigString(oauthConfigString);
            }
            catch (Throwable t) {
                log.warn((Object)"Failed to initialize OAuth consumers from config/oauth.json", t);
            }
        }

        public OAuthStore get() {
            return this.store;
        }
    }
}

