/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Sets;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.JSError;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.SortedSet;

public abstract class BasicErrorManager
implements ErrorManager {
    private final SortedSet<ErrorWithLevel> messages = Sets.newTreeSet((Comparator)new LeveledJSErrorComparator());
    private int errorCount = 0;
    private int warningCount = 0;
    private double typedPercent = 0.0;

    @Override
    public void report(CheckLevel level, JSError error) {
        if (this.messages.add(new ErrorWithLevel(error, level))) {
            if (level == CheckLevel.ERROR) {
                ++this.errorCount;
            } else if (level == CheckLevel.WARNING) {
                ++this.warningCount;
            }
        }
    }

    @Override
    public void generateReport() {
        for (ErrorWithLevel message : this.messages) {
            this.println(message.level, message.error);
        }
        this.printSummary();
    }

    public abstract void println(CheckLevel var1, JSError var2);

    protected abstract void printSummary();

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public int getWarningCount() {
        return this.warningCount;
    }

    @Override
    public JSError[] getErrors() {
        return this.toArray(CheckLevel.ERROR);
    }

    @Override
    public JSError[] getWarnings() {
        return this.toArray(CheckLevel.WARNING);
    }

    @Override
    public void setTypedPercent(double typedPercent) {
        this.typedPercent = typedPercent;
    }

    @Override
    public double getTypedPercent() {
        return this.typedPercent;
    }

    private JSError[] toArray(CheckLevel level) {
        ArrayList<JSError> errors = new ArrayList<JSError>(this.messages.size());
        for (ErrorWithLevel p : this.messages) {
            if (p.level != level) continue;
            errors.add(p.error);
        }
        return errors.toArray(new JSError[errors.size()]);
    }

    static class ErrorWithLevel {
        final JSError error;
        final CheckLevel level;

        ErrorWithLevel(JSError error, CheckLevel level) {
            this.error = error;
            this.level = level;
        }
    }

    static final class LeveledJSErrorComparator
    implements Comparator<ErrorWithLevel> {
        private static final int P1_LT_P2 = -1;
        private static final int P1_GT_P2 = 1;

        LeveledJSErrorComparator() {
        }

        @Override
        public int compare(ErrorWithLevel p1, ErrorWithLevel p2) {
            int charno2;
            int lineno2;
            int lineno1;
            if (p2 == null) {
                if (p1 == null) {
                    return 0;
                }
                return 1;
            }
            if (p1.level != p2.level) {
                return p2.level.compareTo(p1.level);
            }
            String source1 = p1.error.sourceName;
            String source2 = p2.error.sourceName;
            if (source1 != null && source2 != null) {
                int sourceCompare = source1.compareTo(source2);
                if (sourceCompare != 0) {
                    return sourceCompare;
                }
            } else {
                if (source1 == null && source2 != null) {
                    return -1;
                }
                if (source1 != null && source2 == null) {
                    return 1;
                }
            }
            if ((lineno1 = p1.error.lineNumber) != (lineno2 = p2.error.lineNumber)) {
                return lineno1 - lineno2;
            }
            if (lineno1 < 0 && 0 <= lineno2) {
                return -1;
            }
            if (0 <= lineno1 && lineno2 < 0) {
                return 1;
            }
            int charno1 = p1.error.getCharno();
            if (charno1 != (charno2 = p2.error.getCharno())) {
                return charno1 - charno2;
            }
            if (charno1 < 0 && 0 <= charno2) {
                return -1;
            }
            if (0 <= charno1 && charno2 < 0) {
                return 1;
            }
            return p1.error.description.compareTo(p2.error.description);
        }
    }
}

