/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.ispn;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.transaction.TransactionManager;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoMode;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeHandler;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeListener;
import org.exoplatform.services.jcr.impl.core.query.ispn.IndexUpdateKey;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexUpdateMonitor;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexUpdateMonitorListener;
import org.exoplatform.services.jcr.infinispan.PrivilegedISPNCacheHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.transaction.ActionNonTxAware;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Listener
public class ISPNIndexUpdateMonitor
implements IndexUpdateMonitor,
IndexerIoModeListener {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.ISPNIndexUpdateMonitor");
    private final Cache<Serializable, Object> cache;
    private volatile boolean localUpdateInProgress;
    private static final String INDEX_PARAMETERS = "$index_parameters".intern();
    private static final String SYSINDEX_PARAMETERS = "$sysindex_parameters".intern();
    public final IndexerIoModeHandler modeHandler;
    private final ActionNonTxAware<Void, Boolean, RuntimeException> setUpdateInProgress = new ActionNonTxAware<Void, Boolean, RuntimeException>(){

        @Override
        protected TransactionManager getTransactionManager() {
            return ISPNIndexUpdateMonitor.this.cache.getAdvancedCache().getTransactionManager();
        }

        @Override
        protected Void execute(Boolean updateInProgress) {
            PrivilegedISPNCacheHelper.put((Cache<Serializable, Object>)ISPNIndexUpdateMonitor.this.cache, ISPNIndexUpdateMonitor.this.updateKey, updateInProgress);
            return null;
        }
    };
    private final List<IndexUpdateMonitorListener> listeners;
    private final IndexUpdateKey updateKey;

    public ISPNIndexUpdateMonitor(String wsId, Cache<Serializable, Object> cache, boolean system, IndexerIoModeHandler modeHandler) {
        this.cache = cache;
        this.modeHandler = modeHandler;
        this.listeners = new CopyOnWriteArrayList<IndexUpdateMonitorListener>();
        this.modeHandler.addIndexerIoModeListener(this);
        this.updateKey = new IndexUpdateKey(wsId + (system ? SYSINDEX_PARAMETERS : INDEX_PARAMETERS));
        if (IndexerIoMode.READ_WRITE == modeHandler.getMode()) {
            this.setUpdateInProgress(false, true);
        } else {
            cache.addListener((Object)this);
            Object value = cache.get((Object)this.updateKey);
            this.localUpdateInProgress = value != null ? (Boolean)value : false;
        }
    }

    @Override
    public void onChangeMode(IndexerIoMode mode) {
        if (mode == IndexerIoMode.READ_WRITE) {
            this.cache.removeListener((Object)this);
        } else {
            this.cache.addListener((Object)this);
        }
    }

    @Override
    public boolean getUpdateInProgress() {
        return this.localUpdateInProgress;
    }

    @Override
    public void setUpdateInProgress(boolean updateInProgress, boolean persitentUpdate) {
        if (IndexerIoMode.READ_ONLY == this.modeHandler.getMode()) {
            throw new IllegalStateException("Unable to set updateInProgress value in IndexerIoMode.READ_ONLY mode");
        }
        try {
            this.localUpdateInProgress = updateInProgress;
            if (persitentUpdate) {
                this.setUpdateInProgress.run((Boolean[])new Boolean[]{new Boolean(updateInProgress)});
            }
            for (IndexUpdateMonitorListener listener : this.listeners) {
                listener.onUpdateInProgressChange(updateInProgress);
            }
        }
        catch (CacheException e) {
            LOG.error((Object)("Fail to change updateInProgress mode to " + updateInProgress), (Throwable)e);
        }
    }

    @Override
    public void addIndexUpdateMonitorListener(IndexUpdateMonitorListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeIndexUpdateMonitorListener(IndexUpdateMonitorListener listener) {
        this.listeners.remove(listener);
    }

    @CacheEntryModified
    public void cacheEntryModified(CacheEntryModifiedEvent<Serializable, Object> event) {
        if (!event.isPre() && ((Serializable)event.getKey()).equals(this.updateKey)) {
            Object value = event.getValue();
            this.localUpdateInProgress = value != null ? (Boolean)value : false;
            for (IndexUpdateMonitorListener listener : this.listeners) {
                listener.onUpdateInProgressChange(this.localUpdateInProgress);
            }
        }
    }
}

