/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.util.ToStringUtils;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.OffsetCharSequence;
import org.exoplatform.services.jcr.impl.core.query.lucene.RangeScan;
import org.exoplatform.services.jcr.impl.core.query.lucene.TransformConstants;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

abstract class CaseTermQuery
extends MultiTermQuery
implements TransformConstants {
    private static final long serialVersionUID = -4178467977221437090L;
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.CaseTermQuery");
    protected final int transform;
    private final Term term;

    CaseTermQuery(Term term, int transform) {
        this.term = term;
        this.transform = transform;
    }

    protected FilteredTermEnum getEnum(IndexReader reader) throws IOException {
        return new CaseTermEnum(reader);
    }

    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(':');
        }
        buffer.append(this.term.text());
        buffer.append(ToStringUtils.boost((float)this.getBoost()));
        return buffer.toString();
    }

    private final class CaseTermEnum
    extends FilteredTermEnum {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CaseTermEnum(IndexReader reader) throws IOException {
            final LinkedHashMap<Term, Integer> orderedTerms = new LinkedHashMap<Term, Integer>();
            ArrayList<RangeScan> rangeScans = new ArrayList<RangeScan>(2);
            int nameLength = FieldNames.getNameLength(CaseTermQuery.this.term.text());
            String propName = CaseTermQuery.this.term.text().substring(0, nameLength);
            OffsetCharSequence termText = new OffsetCharSequence(nameLength, CaseTermQuery.this.term.text());
            OffsetCharSequence currentTerm = new OffsetCharSequence(nameLength, CaseTermQuery.this.term.text(), CaseTermQuery.this.transform);
            try {
                if (CaseTermQuery.this.term.text().length() > nameLength) {
                    StringBuilder lowerLimit = new StringBuilder(propName);
                    String termStr = termText.toString();
                    String upperTermStr = termStr.toUpperCase();
                    String lowerTermStr = termStr.toLowerCase();
                    lowerLimit.append(upperTermStr);
                    lowerLimit.setCharAt(nameLength, Character.toLowerCase(lowerLimit.charAt(nameLength)));
                    StringBuilder upperLimit = new StringBuilder(propName);
                    upperLimit.append(lowerTermStr);
                    rangeScans.add(new RangeScan(reader, new Term(CaseTermQuery.this.term.field(), lowerLimit.toString()), new Term(CaseTermQuery.this.term.field(), upperLimit.toString())));
                    lowerLimit = new StringBuilder(propName);
                    lowerLimit.append(upperTermStr);
                    upperLimit = new StringBuilder(propName);
                    upperLimit.append(lowerTermStr);
                    upperLimit.setCharAt(nameLength, Character.toUpperCase(upperLimit.charAt(nameLength)));
                    rangeScans.add(new RangeScan(reader, new Term(CaseTermQuery.this.term.field(), lowerLimit.toString()), new Term(CaseTermQuery.this.term.field(), upperLimit.toString())));
                } else {
                    rangeScans.add(new RangeScan(reader, CaseTermQuery.this.term, CaseTermQuery.this.term));
                }
                block5: for (RangeScan terms : rangeScans) {
                    Term t;
                    while ((t = terms.term()) != null) {
                        currentTerm.setBase(t.text());
                        int compare = currentTerm.compareTo(termText);
                        if (compare == 0) {
                            orderedTerms.put(t, terms.docFreq());
                        } else if (compare < 0) {
                            // empty if block
                        }
                        if (terms.next()) continue;
                        continue block5;
                    }
                }
                Object var15_15 = null;
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                for (RangeScan terms : rangeScans) {
                    try {
                        terms.close();
                    }
                    catch (IOException e) {
                        if (!LOG.isTraceEnabled()) continue;
                        LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                    }
                }
                throw throwable;
            }
            for (RangeScan terms : rangeScans) {
                try {
                    terms.close();
                }
                catch (IOException e) {
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                }
            }
            final Iterator it = orderedTerms.keySet().iterator();
            this.setEnum(new TermEnum(){
                private Term current;
                {
                    this.getNext();
                }

                public boolean next() {
                    this.getNext();
                    return this.current != null;
                }

                public Term term() {
                    return this.current;
                }

                public int docFreq() {
                    Integer docFreq = (Integer)orderedTerms.get(this.current);
                    return docFreq != null ? docFreq : 0;
                }

                public void close() {
                }

                private void getNext() {
                    this.current = it.hasNext() ? (Term)it.next() : null;
                }
            });
        }

        protected boolean termCompare(Term term) {
            return true;
        }

        public float difference() {
            return 1.0f;
        }

        protected boolean endEnum() {
            return false;
        }
    }

    static final class Lower
    extends CaseTermQuery {
        private static final long serialVersionUID = -2496607808944458354L;

        Lower(Term term) {
            super(term, 1);
        }
    }

    static final class Upper
    extends CaseTermQuery {
        private static final long serialVersionUID = 4125411301640753714L;

        Upper(Term term) {
            super(term, 2);
        }
    }
}

