/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNode;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNodeIterator;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNodeIteratorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DocOrderScoreNodeIterator
implements ScoreNodeIterator {
    private static final Logger LOG = LoggerFactory.getLogger((String)"exo.jcr.component.core.DocOrderScoreNodeIterator");
    private ScoreNodeIterator orderedNodes;
    private final List<ScoreNode[]> scoreNodes;
    protected final ItemDataConsumer itemMgr;
    private final int selectorIndex;

    DocOrderScoreNodeIterator(ItemDataConsumer itemMgr, List<ScoreNode[]> scoreNodes, int selectorIndex) {
        this.itemMgr = itemMgr;
        this.scoreNodes = scoreNodes;
        this.selectorIndex = selectorIndex;
    }

    public Object next() {
        return this.nextScoreNodes();
    }

    @Override
    public ScoreNode[] nextScoreNodes() {
        this.initOrderedIterator();
        return this.orderedNodes.nextScoreNodes();
    }

    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public void skip(long skipNum) {
        this.initOrderedIterator();
        this.orderedNodes.skip(skipNum);
    }

    @Override
    public void skipBack(long skipNum) {
        this.initOrderedIterator();
        this.orderedNodes.skipBack(skipNum);
    }

    public long getSize() {
        if (this.orderedNodes != null) {
            return this.orderedNodes.getSize();
        }
        return this.scoreNodes.size();
    }

    public long getPosition() {
        this.initOrderedIterator();
        return this.orderedNodes.getPosition();
    }

    public boolean hasNext() {
        this.initOrderedIterator();
        return this.orderedNodes.hasNext();
    }

    private void initOrderedIterator() {
        if (this.orderedNodes != null) {
            return;
        }
        long time = 0L;
        if (LOG.isDebugEnabled()) {
            time = System.currentTimeMillis();
        }
        ScoreNode[][] nodes = (ScoreNode[][])this.scoreNodes.toArray((T[])new ScoreNode[this.scoreNodes.size()][]);
        HashSet<String> invalidIDs = new HashSet<String>(2);
        HashMap<String, NodeData> lcache = new HashMap<String, NodeData>();
        do {
            if (invalidIDs.size() > 0) {
                ArrayList<ScoreNode[]> tmp = new ArrayList<ScoreNode[]>();
                for (int i = 0; i < nodes.length; ++i) {
                    if (invalidIDs.contains(nodes[i][this.selectorIndex].getNodeId())) continue;
                    tmp.add(nodes[i]);
                }
                nodes = (ScoreNode[][])tmp.toArray((T[])new ScoreNode[tmp.size()][]);
                invalidIDs.clear();
            }
            try {
                Arrays.sort(nodes, new ScoreNodeComparator(lcache, invalidIDs));
            }
            catch (SortFailedException e) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("An exception occurred: " + e.getMessage());
            }
        } while (invalidIDs.size() > 0);
        if (LOG.isDebugEnabled()) {
            LOG.debug("" + nodes.length + " node(s) ordered in " + (System.currentTimeMillis() - time) + " ms");
        }
        this.orderedNodes = new ScoreNodeIteratorImpl(nodes);
    }

    private static final class SortFailedException
    extends RuntimeException {
        private static final long serialVersionUID = 3079054269187311527L;

        private SortFailedException() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ScoreNodeComparator
    implements Comparator<ScoreNode[]> {
        private final Map<String, NodeData> lcache;
        private final Set<String> invalidIDs;

        public ScoreNodeComparator(Map<String, NodeData> lcache, Set<String> invalidIDs) {
            this.lcache = lcache;
            this.invalidIDs = invalidIDs;
        }

        private NodeData getNode(String id) throws RepositoryException {
            NodeData node = this.lcache.get(id);
            if (node == null && (node = (NodeData)DocOrderScoreNodeIterator.this.itemMgr.getItemData(id)) != null) {
                this.lcache.put(id, node);
            }
            return node;
        }

        @Override
        public int compare(ScoreNode[] nodes1, ScoreNode[] nodes2) {
            ScoreNode n2;
            ScoreNode n1 = nodes1[DocOrderScoreNodeIterator.this.selectorIndex];
            if (n1.equals(n2 = nodes2[DocOrderScoreNodeIterator.this.selectorIndex])) {
                return 0;
            }
            if (n1 == null) {
                return -1;
            }
            if (n2 == null) {
                return 1;
            }
            try {
                String id;
                int commonDepth;
                NodeData ndata2;
                NodeData ndata1;
                try {
                    ndata1 = this.getNode(n1.getNodeId());
                    if (ndata1 == null) {
                        throw new RepositoryException("Node not found for " + n1.getNodeId());
                    }
                }
                catch (RepositoryException e) {
                    this.invalidIDs.add(n1.getNodeId());
                    throw new SortFailedException();
                }
                try {
                    ndata2 = this.getNode(n2.getNodeId());
                    if (ndata2 == null) {
                        throw new RepositoryException("Node not found for " + n2.getNodeId());
                    }
                }
                catch (RepositoryException e) {
                    this.invalidIDs.add(n2.getNodeId());
                    throw new SortFailedException();
                }
                QPath path1 = ndata1.getQPath();
                QPath path2 = ndata2.getQPath();
                QPathEntry[] pentries1 = path1.getEntries();
                QPathEntry[] pentries2 = path2.getEntries();
                for (commonDepth = 0; pentries1.length > commonDepth && pentries2.length > commonDepth && pentries1[commonDepth].equals(pentries2[commonDepth]); ++commonDepth) {
                }
                if (pentries1.length - 1 == --commonDepth) {
                    return -1;
                }
                if (pentries2.length - 1 == commonDepth) {
                    return 1;
                }
                while (pentries1.length - 1 > commonDepth + 1) {
                    id = ndata1.getParentIdentifier();
                    try {
                        ndata1 = this.getNode(id);
                        if (ndata1 == null) {
                            throw new RepositoryException("Node not found for " + id);
                        }
                        pentries1 = ndata1.getQPath().getEntries();
                    }
                    catch (RepositoryException e) {
                        this.invalidIDs.add(id);
                        throw new SortFailedException();
                    }
                }
                while (pentries2.length - 1 > commonDepth + 1) {
                    id = ndata2.getParentIdentifier();
                    try {
                        ndata2 = this.getNode(id);
                        if (ndata2 == null) {
                            throw new RepositoryException("Node not found for " + id);
                        }
                        pentries2 = ndata2.getQPath().getEntries();
                    }
                    catch (RepositoryException e) {
                        this.invalidIDs.add(id);
                        throw new SortFailedException();
                    }
                }
                return ndata1.getOrderNumber() - ndata2.getOrderNumber();
            }
            catch (SortFailedException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error("Exception while sorting nodes in document order: " + e.toString(), (Throwable)e);
                this.invalidIDs.add(n1.getNodeId());
                this.invalidIDs.add(n2.getNodeId());
                throw new SortFailedException();
            }
        }
    }
}

