/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.init;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.database.utils.JDBCUtils;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.StorageDBInitializer;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializerHelper;

public class SybaseDBInitializer
extends StorageDBInitializer {
    public SybaseDBInitializer(Connection connection, JDBCDataContainerConfig containerConfig) throws IOException {
        super(connection, containerConfig);
    }

    protected boolean isProcedureExists(final Connection conn, final String procedureName) throws SQLException {
        return (Boolean)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return SybaseDBInitializer.this.procedureExists(procedureName, conn);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean procedureExists(String procedureName, Connection con) {
        boolean bl;
        Statement stmt = null;
        ResultSet trs = null;
        try {
            String query = "select count(*) from sysobjects where type='P' and name='" + procedureName + "'";
            stmt = con.createStatement();
            trs = stmt.executeQuery(query);
            bl = trs.next() && trs.getInt(1) >= 1;
            Object var8_9 = null;
        }
        catch (SQLException e) {
            boolean bl2;
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("SQLException occurs while checking the procedure " + procedureName), (Throwable)e);
                }
                bl2 = false;
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                JDBCUtils.freeResources(trs, stmt, null);
                throw throwable;
            }
            JDBCUtils.freeResources(trs, (Statement)stmt, null);
            return bl2;
        }
        JDBCUtils.freeResources((ResultSet)trs, (Statement)stmt, null);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postInit(Connection connection) throws SQLException {
        super.postInit(connection);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            if (this.containerConfig.useSequenceForOrderNumber) {
                String select = "select * from JCR_" + DBInitializerHelper.getItemTableSuffix(this.containerConfig) + "_SEQ  where name='LAST_N_ORDER_NUM'";
                stmt = connection.createStatement();
                rs = stmt.executeQuery(select);
                if (!rs.next()) {
                    String insert = "INSERT INTO JCR_" + DBInitializerHelper.getItemTableSuffix(this.containerConfig) + "_SEQ  (name, nextVal) VALUES ('LAST_N_ORDER_NUM'," + this.getStartValue(connection) + ")";
                    stmt.executeUpdate(insert);
                }
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            JDBCUtils.freeResources(rs, stmt, null);
            throw throwable;
        }
        JDBCUtils.freeResources(rs, stmt, null);
    }
}

