/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.portlet.ActionResponse;
import javax.xml.namespace.QName;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.management.operations.page.PageUtils;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.page.PageIterator;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageFactory;
import org.exoplatform.portal.webui.page.UIPageForm;
import org.exoplatform.portal.webui.page.UIPageSearchForm;
import org.exoplatform.portal.webui.portal.PageNodeEvent;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.config.annotation.ParamConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIRepeater;
import org.exoplatform.webui.core.UIVirtualList;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfigs(value={@ComponentConfig(template="system:/groovy/portal/webui/page/UIPageBrowser.gtmpl", events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UIPageBrowse.deletePage"), @EventConfig(listeners={EditInfoActionListener.class}), @EventConfig(listeners={AddNewActionListener.class})}), @ComponentConfig(id="UIBrowserPageForm", type=UIPageForm.class, lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={SavePageActionListener.class}, name="Save"), @EventConfig(listeners={UIPageForm.ChangeOwnerTypeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageForm.ChangeOwnerIdActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageForm.SelectMembershipActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIMaskWorkspace.CloseActionListener.class}, phase=Event.Phase.DECODE)}, initParams={@ParamConfig(name="PageTemplate", value="system:/WEB-INF/conf/uiconf/portal/webui/page/PageTemplate.groovy")}), @ComponentConfig(type=UIFormInputSet.class, id="PermissionSetting", template="system:/groovy/webui/core/UITabSelector.gtmpl", events={@EventConfig(listeners={UIFormInputSet.SelectComponentActionListener.class})})})
@Serialized
public class UIPageBrowser
extends UIContainer {
    public static final String[] BEAN_FIELD = new String[]{"pageId", "title", "accessPermissions", "editPermission"};
    public static final String[] ACTIONS = new String[]{"EditInfo", "Delete"};
    private boolean showAddNewPage = false;
    protected String pageSelectedId_;
    private List<SelectItemOption<String>> OPTIONS = new ArrayList<SelectItemOption<String>>(2);
    private Query<Page> lastQuery_;

    public UIPageBrowser() throws Exception {
        WebuiRequestContext contextui = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = contextui.getApplicationResourceBundle();
        this.OPTIONS.add((SelectItemOption<String>)new SelectItemOption(res.getString("UIPageSearchForm.label.option.portal"), (Object)"portal"));
        this.OPTIONS.add((SelectItemOption<String>)new SelectItemOption(res.getString("UIPageSearchForm.label.option.group"), (Object)"group"));
        UIPageSearchForm uiSearchForm = (UIPageSearchForm)this.addChild(UIPageSearchForm.class, null, null);
        uiSearchForm.setOptions(this.OPTIONS);
        uiSearchForm.setId("UIPageSearchForm");
        UIRepeater uiRepeater = (UIRepeater)this.createUIComponent(UIRepeater.class, null, null);
        uiRepeater.configure("pageId", BEAN_FIELD, ACTIONS);
        this.lastQuery_ = new Query(null, null, null, null, Page.class);
        this.lastQuery_.setOwnerType((String)this.OPTIONS.get(0).getValue());
        UIVirtualList virtualList = (UIVirtualList)this.addChild(UIVirtualList.class, null, null);
        virtualList.setUIComponent((UIComponent)uiRepeater);
    }

    public Query<Page> getLastQuery() {
        return this.lastQuery_;
    }

    public Query<Page> getQuery(UIFormInputSet searchInputs) {
        Query query = new Query(null, null, null, null, Page.class);
        UIFormStringInput titleInput = (UIFormStringInput)searchInputs.getChild(0);
        UIFormStringInput siteNameInput = (UIFormStringInput)searchInputs.getChild(1);
        UIFormSelectBox select = (UIFormSelectBox)searchInputs.getChild(2);
        String siteName = (String)siteNameInput.getValue();
        String title = (String)titleInput.getValue();
        String ownerType = (String)select.getValue();
        if (title != null) {
            query.setTitle(title.trim());
        }
        if (siteName != null && !siteName.trim().equals("")) {
            query.setOwnerId(siteName.trim());
        }
        query.setOwnerType(ownerType);
        query.setName(null);
        return query;
    }

    public boolean feedDataWithQuery(Query<Page> query) throws Exception {
        this.lastQuery_ = query;
        UIVirtualList virtualList = (UIVirtualList)this.getChild(UIVirtualList.class);
        if (this.lastQuery_ == null) {
            this.lastQuery_ = new Query(null, null, null, null, Page.class);
        }
        virtualList.dataBind((Iterator)new PageIterator(this.lastQuery_.getOwnerType(), this.lastQuery_.getOwnerId(), this.lastQuery_.getName(), this.lastQuery_.getTitle(), 10));
        UIRepeater repeater = virtualList.getRepeater();
        return repeater.hasNext();
    }

    public static void showNoResultMessagePopup() {
        UIApplication uiApp = Util.getPortalRequestContext().getUIApplication();
        uiApp.addMessage(new ApplicationMessage("UISearchForm.msg.empty", null));
    }

    public void quickSearch(UIFormInputSet quickSearchInput) throws Exception {
        this.lastQuery_ = this.getQuery(quickSearchInput);
        boolean dataAvailable = this.feedDataWithQuery(this.lastQuery_);
        if (!dataAvailable) {
            UIPageBrowser.showNoResultMessagePopup();
        }
        if (this.getParent() instanceof UIPopupWindow) {
            UIPopupWindow popupWindow = (UIPopupWindow)this.getParent();
            popupWindow.setShow(true);
        }
    }

    public boolean isShowAddNewPage() {
        return this.showAddNewPage;
    }

    public void setShowAddNewPage(boolean showAddNewPage) {
        this.showAddNewPage = showAddNewPage;
    }

    public void processDecode(WebuiRequestContext context) throws Exception {
        super.processDecode(context);
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        String action = null;
        action = uiForm != null ? uiForm.getSubmitAction() : context.getRequestParameter("formOp");
        if (action == null) {
            return;
        }
        Event event = this.createEvent(action, Event.Phase.PROCESS, context);
        if (event != null) {
            event.broadcast();
        }
    }

    public void advancedSearch(UIFormInputSet advancedSearchInput) {
    }

    public static class SavePageActionListener
    extends UIPageForm.SaveActionListener {
        @Override
        public void execute(Event<UIPageForm> event) throws Exception {
            UIPageForm uiPageForm = (UIPageForm)((Object)event.getSource());
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiPageForm.getAncestorOfType(UIPortalApplication.class);
            PortalRequestContext pcontext = Util.getPortalRequestContext();
            UIPage uiPage = uiPageForm.getUIPage();
            Page page = new Page();
            uiPageForm.invokeSetBindingBean(page);
            DataStorage dataService = (DataStorage)uiPageForm.getApplicationComponent(DataStorage.class);
            if (uiPage == null) {
                PageService pageService = (PageService)uiPageForm.getApplicationComponent(PageService.class);
                PageContext existPage = pageService.loadPage(page.getPageKey());
                if (existPage != null) {
                    uiPortalApp.addMessage(new ApplicationMessage("UIPageForm.msg.sameName", null));
                    return;
                }
                page.setModifiable(true);
                if (page.getChildren() == null) {
                    page.setChildren(new ArrayList());
                }
                PageState pageState = PageUtils.toPageState((Page)page);
                pageService.savePage(new PageContext(page.getPageKey(), pageState));
                dataService.save(page);
                this.postSave(uiPortalApp, pcontext);
                return;
            }
            page.setOwnerType(uiPage.getSiteKey().getTypeName());
            ArrayList<UIPortlet> uiPortlets = new ArrayList<UIPortlet>();
            this.findAllPortlet(uiPortlets, uiPage);
            ArrayList<ModelObject> applications = new ArrayList<ModelObject>();
            for (UIPortlet uiPortlet : uiPortlets) {
                applications.add(PortalDataMapper.buildModelObject((UIComponent)uiPortlet));
            }
            List uiChildren = uiPage.getChildren();
            if (uiChildren == null) {
                return;
            }
            ArrayList<ModelObject> children = new ArrayList<ModelObject>();
            for (UIComponent child : uiChildren) {
                ModelObject component = PortalDataMapper.buildModelObject(child);
                if (component == null) continue;
                children.add(component);
            }
            page.setChildren(children);
            uiPage.getChildren().clear();
            PortalDataMapper.toUIPage(uiPage, page);
            if (page.getChildren() == null) {
                page.setChildren(new ArrayList());
            }
        }

        private void postSave(UIPortalApplication uiPortalApp, WebuiRequestContext context) throws Exception {
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiPortalApp.getChildById("UIMaskWorkspace");
            uiMaskWS.createEvent("Close", Event.Phase.DECODE, context).broadcast();
            UIWorkingWorkspace uiWorkWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
            uiWorkWS.updatePortletsByName("PageManagementPortlet");
        }
    }

    public static class AddNewActionListener
    extends EventListener<UIPageBrowser> {
        public void execute(Event<UIPageBrowser> event) throws Exception {
            PortalRequestContext prContext = Util.getPortalRequestContext();
            UIPortalApplication uiApp = (UIPortalApplication)prContext.getUIApplication();
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            boolean hasPermission = false;
            String currentUser = prContext.getRemoteUser();
            if (currentUser != null) {
                UIPageForm uiPageForm = uiMaskWS.createUIComponent(UIPageForm.class, "UIBrowserPageForm", "UIPageForm");
                uiPageForm.buildForm(null);
                UIFormSelectBox slcOwnerType = uiPageForm.getUIFormSelectBox("ownerType");
                List types = slcOwnerType.getOptions();
                for (int i = 0; i < types.size(); ++i) {
                    if (!PortalConfig.USER_TYPE.equals(((SelectItemOption)types.get(i)).getValue())) continue;
                    types.remove(types.get(i));
                    break;
                }
                if (!types.isEmpty()) {
                    hasPermission = true;
                    slcOwnerType.setOptions(types);
                    Event slcEvent = uiPageForm.createEvent("ChangeOwnerType", Event.Phase.DECODE, event.getRequestContext());
                    slcEvent.broadcast();
                    uiMaskWS.setUIComponent((UIComponent)uiPageForm);
                    uiMaskWS.setShow(true);
                    prContext.addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
                }
            }
            if (!hasPermission) {
                uiMaskWS.setUIComponent(null);
                uiApp.addMessage(new ApplicationMessage("UIPortalManagement.msg.Invalid-CreatePage-Permission", null));
            }
        }
    }

    public static class EditInfoActionListener
    extends EventListener<UIPageBrowser> {
        public void execute(Event<UIPageBrowser> event) throws Exception {
            PageContext pageContext;
            UIPageBrowser uiPageBrowser = (UIPageBrowser)((Object)event.getSource());
            WebuiRequestContext context = event.getRequestContext();
            PortalRequestContext pcontext = (PortalRequestContext)context.getParentAppRequestContext();
            UIPortalApplication uiPortalApp = (UIPortalApplication)pcontext.getUIApplication();
            String id = context.getRequestParameter("objectId");
            UserPortalConfigService service = (UserPortalConfigService)uiPageBrowser.getApplicationComponent(UserPortalConfigService.class);
            PageContext pageContext2 = pageContext = id != null ? service.getPage(PageKey.parse((String)id)) : null;
            if (pageContext == null) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageBrowser.msg.PageNotExist", (Object[])new String[]{id}, 1));
                return;
            }
            UserACL userACL = (UserACL)uiPageBrowser.getApplicationComponent(UserACL.class);
            if (!userACL.hasEditPermission(pageContext)) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageBrowser.msg.edit.NotEditPage", (Object[])new String[]{id}, 1));
                return;
            }
            UIPageFactory clazz = UIPageFactory.getInstance(pageContext.getState().getFactoryId());
            UIPage uipage = clazz.createUIPage(null);
            Page page = service.getDataStorage().getPage(id);
            pageContext.update(page);
            uipage.switchToEditMode(page);
        }
    }

    public static class DeleteActionListener
    extends EventListener<UIPageBrowser> {
        public void execute(Event<UIPageBrowser> event) throws Exception {
            PageContext page;
            UIPageBrowser uiPageBrowser = (UIPageBrowser)((Object)event.getSource());
            WebuiRequestContext context = event.getRequestContext();
            String id = context.getRequestParameter("objectId");
            UserPortalConfigService service = (UserPortalConfigService)uiPageBrowser.getApplicationComponent(UserPortalConfigService.class);
            UIApplication uiApp = context.getUIApplication();
            PageContext pageContext = page = id != null ? service.getPageService().loadPage(PageKey.parse((String)id)) : null;
            if (page == null) {
                uiApp.addMessage(new ApplicationMessage("UIPageBrowser.msg.PageNotExist", (Object[])new String[]{id}, 1));
                return;
            }
            UserACL userACL = (UserACL)uiPageBrowser.getApplicationComponent(UserACL.class);
            if (!userACL.hasEditPermission(page)) {
                uiApp.addMessage(new ApplicationMessage("UIPageBrowser.msg.delete.NotDelete", (Object[])new String[]{id}, 1));
                return;
            }
            UIPortal uiPortal = Util.getUIPortal();
            UserNode userNode = uiPortal.getSelectedUserNode();
            boolean isDeleteCurrentPage = page.getKey().equals((Object)userNode.getPageRef());
            service.getPageService().destroyPage(page.getKey());
            if (isDeleteCurrentPage) {
                SiteKey siteKey = userNode.getNavigation().getKey();
                PageNodeEvent<UIPortalApplication> pnevent = new PageNodeEvent<UIPortalApplication>(Util.getUIPortalApplication(), "ChangeNode", siteKey, userNode.getURI());
                uiPortal.broadcast(pnevent, Event.Phase.PROCESS);
            } else {
                boolean dataAvailable = uiPageBrowser.feedDataWithQuery(uiPageBrowser.getLastQuery());
                if (!dataAvailable) {
                    UIPageBrowser.showNoResultMessagePopup();
                }
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPageBrowser);
            }
        }

        private void removePageNode(PageContext page, Event<UIPageBrowser> event) throws Exception {
            UserNavigation userNav;
            PortalRequestContext prc = Util.getPortalRequestContext();
            UserPortal userPortal = prc.getUserPortalConfig().getUserPortal();
            UserNode rootNode = userPortal.getNode(userNav = userPortal.getNavigation(SiteKey.user((String)event.getRequestContext().getRemoteUser())), Scope.CHILDREN, null, null);
            if (rootNode == null) {
                return;
            }
            for (UserNode userNode : rootNode.getChildren()) {
                if (!page.getKey().equals((Object)userNode.getPageRef())) continue;
                rootNode.removeChild(userNode.getName());
                userPortal.saveNode(rootNode, null);
                String pageRef = page.getKey().format();
                if (pageRef != null && pageRef.length() > 0) {
                    UIPortal uiPortal = Util.getUIPortal();
                    uiPortal.clearUIPage(pageRef);
                }
                ActionResponse actResponse = (ActionResponse)event.getRequestContext().getResponse();
                actResponse.setEvent(new QName("NavigationChange"), (Serializable)((Object)userNode.getName()));
                return;
            }
        }
    }
}

