/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jaxrs.utils;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;

public class ReflectionUtils {
    private static final Set<Class<? extends Annotation>> CONSTRUCTOR_ANNOTATIONS;

    public static boolean isOverriddenMethod(Method methodToFind, Class<?> cls) {
        Class<?> superClass = cls.getSuperclass();
        if (superClass != null && !superClass.getClass().equals(Object.class)) {
            for (Method method : superClass.getMethods()) {
                if (!method.getName().equals(methodToFind.getName()) || !method.getReturnType().isAssignableFrom(methodToFind.getReturnType()) || !Arrays.equals(method.getParameterTypes(), methodToFind.getParameterTypes()) || Arrays.equals(method.getGenericParameterTypes(), methodToFind.getGenericParameterTypes())) continue;
                return true;
            }
            return ReflectionUtils.isOverriddenMethod(methodToFind, superClass);
        }
        return false;
    }

    public static Method getOverriddenMethod(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        Class<?> superClass = declaringClass.getSuperclass();
        if (superClass != null && !superClass.getClass().equals(Object.class)) {
            Method result = ReflectionUtils.findMethod(method, superClass);
            if (result == null) {
                for (Class<?> anInterface : declaringClass.getInterfaces()) {
                    result = ReflectionUtils.findMethod(method, anInterface);
                    if (result == null) continue;
                    return result;
                }
            } else {
                return result;
            }
        }
        return null;
    }

    public static Method findMethod(Method methodToFind, Class<?> cls) {
        String methodToSearch = methodToFind.getName();
        Class<?>[] pTypes = methodToFind.getParameterTypes();
        Type[] gpTypes = methodToFind.getGenericParameterTypes();
        block0: for (Method method : cls.getMethods()) {
            if (!method.getName().equals(methodToSearch) || !method.getReturnType().isAssignableFrom(methodToFind.getReturnType())) continue;
            Class<?>[] pt = method.getParameterTypes();
            Type[] gpt = method.getGenericParameterTypes();
            for (int j = 0; j < pTypes.length; ++j) {
                Class<?> parameterType = pTypes[j];
                if (!pt[j].equals(parameterType) && (gpt[j].equals(gpTypes[j]) || !pt[j].isAssignableFrom(parameterType))) continue block0;
            }
            return method;
        }
        return null;
    }

    public static Constructor<?> findConstructor(Class<?> cls) {
        if (cls.isLocalClass() || cls.isMemberClass() && !Modifier.isStatic(cls.getModifiers())) {
            return null;
        }
        Constructor<?> selected = null;
        int selectedCount = 0;
        int maxParams = -1;
        for (Constructor<?> constructor : cls.getDeclaredConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length < maxParams || !ReflectionUtils.isCompatible(constructor)) continue;
            if (parameterTypes.length > maxParams) {
                maxParams = parameterTypes.length;
                selectedCount = 0;
            }
            selected = constructor;
            ++selectedCount;
        }
        return selectedCount == 1 ? selected : null;
    }

    public static Function<Annotation, Class<? extends Annotation>> createAnnotationTypeGetter() {
        return new Function<Annotation, Class<? extends Annotation>>(){

            public Class<? extends Annotation> apply(Annotation annotation) {
                return annotation.annotationType();
            }
        };
    }

    private static boolean isCompatible(Constructor<?> constructor) {
        for (Annotation annotation : constructor.getAnnotations()) {
            if (!"javax.inject.Inject".equals(annotation.annotationType().getName())) continue;
            return true;
        }
        if (!Modifier.isPublic(constructor.getModifiers())) {
            int access = 7;
            return constructor.getParameterTypes().length == 0 && (constructor.getDeclaringClass().getModifiers() & 7) == constructor.getModifiers();
        }
        for (Annotation annotation : constructor.getParameterAnnotations()) {
            Collection tmp = Collections2.transform(Arrays.asList(annotation), ReflectionUtils.createAnnotationTypeGetter());
            if (!Collections.disjoint(tmp, CONSTRUCTOR_ANNOTATIONS)) continue;
            return false;
        }
        return true;
    }

    static {
        HashSet<Class<HeaderParam>> constructorAnnotations = new HashSet<Class<HeaderParam>>();
        constructorAnnotations.add(PathParam.class);
        constructorAnnotations.add(QueryParam.class);
        constructorAnnotations.add(HeaderParam.class);
        CONSTRUCTOR_ANNOTATIONS = Collections.unmodifiableSet(constructorAnnotations);
    }
}

