/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.management.binding.xml;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.PageBody;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.Properties;
import org.exoplatform.portal.mop.management.binding.xml.AbstractMarshaller;
import org.exoplatform.portal.mop.management.binding.xml.Element;
import org.exoplatform.portal.mop.management.binding.xml.portal.redirects.PortalRedirectXmlHandler;
import org.gatein.common.xml.stax.navigator.Exceptions;
import org.gatein.common.xml.stax.navigator.StaxNavUtils;
import org.gatein.common.xml.stax.writer.StaxWriter;
import org.gatein.common.xml.stax.writer.StaxWriterUtils;
import org.gatein.common.xml.stax.writer.builder.StaxWriterBuilder;
import org.gatein.management.api.binding.BindingException;
import org.staxnav.Axis;
import org.staxnav.StaxNavException;
import org.staxnav.StaxNavigator;

public class SiteLayoutMarshaller
extends AbstractMarshaller<PortalConfig> {
    private final PortalRedirectXmlHandler redirectXmlHandler = new PortalRedirectXmlHandler();

    public void marshal(PortalConfig object, OutputStream outputStream, boolean pretty) throws BindingException {
        try {
            StaxWriterBuilder builder = StaxWriterUtils.buildDefaultWriter((OutputStream)outputStream);
            if (!pretty) {
                builder.withFormatting(null);
            }
            StaxWriter writer = builder.build(Element.class);
            writer.writeStartElement((Object)Element.PORTAL_CONFIG);
            this.writeGateinObjectsNamespace((StaxWriter<Element>)writer);
            this.marshalPortalConfig((StaxWriter<Element>)writer, object);
            writer.finish();
        }
        catch (StaxNavException e) {
            throw new BindingException((Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new BindingException((Throwable)e);
        }
    }

    public PortalConfig unmarshal(InputStream is) throws BindingException {
        try {
            StaxNavigator navigator = StaxNavUtils.createNavigator(Element.class, (Enum)Element.UNKNOWN, (InputStream)is);
            if (navigator.getName() == Element.PORTAL_CONFIG) {
                return this.unmarshalPortalConfig((StaxNavigator<Element>)navigator);
            }
            throw Exceptions.unknownElement((StaxNavigator)navigator);
        }
        catch (StaxNavException e) {
            throw new BindingException((Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new BindingException((Throwable)e);
        }
    }

    private void marshalPortalConfig(StaxWriter<Element> writer, PortalConfig portalConfig) throws XMLStreamException {
        writer.writeElement((Object)Element.PORTAL_NAME, portalConfig.getName());
        StaxWriterUtils.writeOptionalElement(writer, (Object)((Object)Element.LABEL), (String)portalConfig.getLabel());
        StaxWriterUtils.writeOptionalElement(writer, (Object)((Object)Element.DESCRIPTION), (String)portalConfig.getDescription());
        StaxWriterUtils.writeOptionalElement(writer, (Object)((Object)Element.LOCALE), (String)portalConfig.getLocale());
        this.marshalAccessPermissions(writer, portalConfig.getAccessPermissions());
        this.marshalEditPermission(writer, portalConfig.getEditPermission());
        StaxWriterUtils.writeOptionalElement(writer, (Object)((Object)Element.SKIN), (String)portalConfig.getSkin());
        boolean propertiesWritten = false;
        Properties properties = portalConfig.getProperties();
        if (properties != null) {
            for (String key : properties.keySet()) {
                String value;
                if (!propertiesWritten) {
                    writer.writeStartElement((Object)Element.PROPERTIES);
                    propertiesWritten = true;
                }
                if ((value = (String)properties.get(key)) == null) continue;
                writer.writeStartElement((Object)Element.PROPERTIES_ENTRY);
                writer.writeAttribute(Attribute.PROPERTIES_KEY.getLocalName(), key);
                writer.writeContent(value).writeEndElement();
            }
            if (propertiesWritten) {
                writer.writeEndElement();
            }
        }
        this.redirectXmlHandler.write(writer, portalConfig.getPortalRedirects());
        Container container = portalConfig.getPortalLayout();
        if (container != null) {
            writer.writeStartElement((Object)Element.PORTAL_LAYOUT);
            this.marshalPermissions(writer, Element.MOVE_APPLICATIONS_PERMISSIONS, container.getMoveAppsPermissions());
            this.marshalPermissions(writer, Element.MOVE_CONTAINERS_PERMISSIONS, container.getMoveContainersPermissions());
            ArrayList<ModelObject> children = container.getChildren();
            if (children != null && !children.isEmpty()) {
                for (ModelObject child : children) {
                    this.marshalModelObject(writer, child);
                }
            }
            writer.writeEndElement();
        }
    }

    private PortalConfig unmarshalPortalConfig(StaxNavigator<Element> navigator) throws XMLStreamException {
        PortalConfig portalConfig = new PortalConfig();
        Container portalLayout = null;
        Element current = (Element)((Object)navigator.child());
        block19: while (current != null) {
            switch (current) {
                case PORTAL_NAME: {
                    portalConfig.setName(navigator.getContent());
                    current = (Element)((Object)navigator.sibling());
                    continue block19;
                }
                case LOCALE: {
                    portalConfig.setLocale(navigator.getContent());
                    current = (Element)((Object)navigator.sibling());
                    continue block19;
                }
                case LABEL: {
                    portalConfig.setLabel(navigator.getContent());
                    current = (Element)((Object)navigator.sibling());
                    continue block19;
                }
                case DESCRIPTION: {
                    portalConfig.setDescription(navigator.getContent());
                    current = (Element)((Object)navigator.sibling());
                    continue block19;
                }
                case SKIN: {
                    portalConfig.setSkin(navigator.getContent());
                    current = (Element)((Object)navigator.sibling());
                    continue block19;
                }
                case PROPERTIES: {
                    Properties properties = new Properties();
                    if (navigator.navigate(Axis.CHILD, (Object)Element.PROPERTIES_ENTRY)) {
                        for (StaxNavigator fork : navigator.fork((Object)Element.PROPERTIES_ENTRY)) {
                            String key = StaxNavUtils.getRequiredAttribute((StaxNavigator)fork, (String)Attribute.PROPERTIES_KEY.getLocalName());
                            String value = StaxNavUtils.getRequiredContent((StaxNavigator)fork, (boolean)false);
                            properties.put(key, value);
                        }
                    } else {
                        throw Exceptions.expectedElement(navigator, (Object)((Object)Element.PROPERTIES_ENTRY));
                    }
                    portalConfig.setProperties(properties);
                    current = (Element)((Object)navigator.next());
                    continue block19;
                }
                case ACCESS_PERMISSIONS: {
                    portalConfig.setAccessPermissions(this.unmarshalAccessPermissions(navigator, false));
                    current = (Element)((Object)navigator.sibling());
                    continue block19;
                }
                case EDIT_PERMISSION: {
                    portalConfig.setEditPermission(this.unmarshalEditPermission(navigator));
                    current = (Element)((Object)navigator.sibling());
                    continue block19;
                }
                case PORTAL_REDIRECTS: {
                    portalConfig.setPortalRedirects((ArrayList)this.redirectXmlHandler.read(navigator.fork()));
                    current = (Element)((Object)navigator.sibling());
                    continue block19;
                }
                case PORTAL_LAYOUT: {
                    portalLayout = new Container();
                    current = (Element)((Object)navigator.child());
                    continue block19;
                }
                case MOVE_APPLICATIONS_PERMISSIONS: {
                    if (portalLayout == null) {
                        throw Exceptions.expectedElement(navigator, (Object)((Object)Element.PORTAL_LAYOUT));
                    }
                    portalLayout.setMoveAppsPermissions(this.unmarshalPermissions(navigator, false));
                    current = (Element)((Object)navigator.sibling());
                    continue block19;
                }
                case MOVE_CONTAINERS_PERMISSIONS: {
                    if (portalLayout == null) {
                        throw Exceptions.expectedElement(navigator, (Object)((Object)Element.PORTAL_LAYOUT));
                    }
                    portalLayout.setMoveContainersPermissions(this.unmarshalPermissions(navigator, false));
                    current = (Element)((Object)navigator.sibling());
                    continue block19;
                }
                case PAGE_BODY: {
                    if (portalLayout == null) {
                        throw Exceptions.expectedElement(navigator, (Object)((Object)Element.PORTAL_LAYOUT));
                    }
                    portalLayout.getChildren().add(new PageBody());
                    current = (Element)((Object)navigator.sibling());
                    continue block19;
                }
                case PORTLET_APPLICATION: {
                    if (portalLayout == null) {
                        throw Exceptions.expectedElement(navigator, (Object)((Object)Element.PORTAL_LAYOUT));
                    }
                    portalLayout.getChildren().add(this.unmarshalPortletApplication((StaxNavigator<Element>)navigator.fork()));
                    current = (Element)((Object)navigator.sibling());
                    continue block19;
                }
                case GADGET_APPLICATION: {
                    if (portalLayout == null) {
                        throw Exceptions.expectedElement(navigator, (Object)((Object)Element.PORTAL_LAYOUT));
                    }
                    portalLayout.getChildren().add(this.unmarshalGadgetApplication((StaxNavigator<Element>)navigator.fork()));
                    current = (Element)((Object)navigator.sibling());
                    continue block19;
                }
                case CONTAINER: {
                    if (portalLayout == null) {
                        throw Exceptions.expectedElement(navigator, (Object)((Object)Element.PORTAL_LAYOUT));
                    }
                    portalLayout.getChildren().add(this.unmarshalContainer((StaxNavigator<Element>)navigator.fork()));
                    current = (Element)((Object)navigator.sibling());
                    continue block19;
                }
                case UNKNOWN: {
                    throw Exceptions.unknownElement(navigator);
                }
            }
            throw Exceptions.unexpectedElement(navigator);
        }
        if (portalConfig.getAccessPermissions() == null) {
            throw Exceptions.expectedElement(navigator, (Object)((Object)Element.ACCESS_PERMISSIONS));
        }
        if (portalLayout == null) {
            portalLayout = PortalConfig.DEFAULT_LAYOUT;
        } else {
            int count = SiteLayoutMarshaller.countPageBodyElements(portalLayout, 0);
            if (count < 1) {
                throw new StaxNavException("No page-body element found.");
            }
            if (count > 1) {
                throw new StaxNavException("Multiple page-body elements found.");
            }
        }
        portalConfig.setPortalLayout(portalLayout);
        return portalConfig;
    }

    private static int countPageBodyElements(Container container, int pageBodyCount) {
        if (container.getChildren() != null) {
            for (ModelObject child : container.getChildren()) {
                if (child instanceof PageBody) {
                    ++pageBodyCount;
                    continue;
                }
                if (!(child instanceof Container)) continue;
                pageBodyCount = SiteLayoutMarshaller.countPageBodyElements((Container)child, pageBodyCount);
            }
        }
        return pageBodyCount;
    }

    private static enum Attribute {
        PROPERTIES_KEY("key");

        private final String name;

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }
    }
}

