/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.config;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.SimpleParameterEntry;
import org.exoplatform.services.jcr.util.StringNumberParser;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MappedParametrizedObjectEntry {
    private static final Log LOG = ExoLogger.getLogger((String)"org.exoplatform.services.jcr.config.MappedParametrizedObjectEntry");
    protected String type;
    protected Map<String, SimpleParameterEntry> parameters = new LinkedHashMap<String, SimpleParameterEntry>();

    public MappedParametrizedObjectEntry() {
    }

    public MappedParametrizedObjectEntry(String type, List<SimpleParameterEntry> parameters) {
        this.type = type;
        this.setParameters(parameters);
    }

    public Collection<SimpleParameterEntry> getParameters() {
        return this.parameters.values();
    }

    public Iterator<SimpleParameterEntry> getParameterIterator() {
        return this.parameters.values().iterator();
    }

    public boolean hasParameters() {
        return !this.parameters.isEmpty();
    }

    public boolean hasParameter(String name) {
        return this.parameters.containsKey(name);
    }

    public String getParameterValue(String name) throws RepositoryConfigurationException {
        String value = this.getParameterValue(name, null);
        if (value == null) {
            throw new RepositoryConfigurationException("Parameter " + name + " not found ");
        }
        return value;
    }

    public String getParameterValue(String name, String defaultValue) {
        String value = defaultValue;
        SimpleParameterEntry p = this.parameters.get(name);
        if (p != null) {
            value = p.getValue();
        }
        return value;
    }

    public void putParameterValue(String name, String value) {
        SimpleParameterEntry p = this.parameters.get(name);
        if (p != null) {
            p.setValue(value);
            return;
        }
        SimpleParameterEntry newParam = new SimpleParameterEntry(name, value);
        this.addParameter(newParam);
    }

    public Integer getParameterInteger(String name, Integer defaultValue) {
        block3: {
            String value = this.getParameterValue(name, null);
            if (value != null) {
                try {
                    return StringNumberParser.parseInt(value);
                }
                catch (NumberFormatException e) {
                    if (!LOG.isTraceEnabled()) break block3;
                    LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                }
            }
        }
        return defaultValue;
    }

    public void putIntegerParameter(String name, Integer value) {
        this.putParameterValue(name, value.toString());
    }

    public Integer getParameterInteger(String name) throws RepositoryConfigurationException {
        try {
            return StringNumberParser.parseInt(this.getParameterValue(name));
        }
        catch (NumberFormatException e) {
            throw new RepositoryConfigurationException(name + ": unparseable Integer. " + e, e);
        }
    }

    public Long getParameterLong(String name, Long defaultValue) {
        block3: {
            String value = this.getParameterValue(name, null);
            if (value != null) {
                try {
                    return StringNumberParser.parseLong(value);
                }
                catch (NumberFormatException e) {
                    if (!LOG.isTraceEnabled()) break block3;
                    LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                }
            }
        }
        return defaultValue;
    }

    public Long getParameterLong(String name) throws RepositoryConfigurationException {
        try {
            return StringNumberParser.parseLong(this.getParameterValue(name));
        }
        catch (NumberFormatException e) {
            throw new RepositoryConfigurationException(name + ": unparseable Long. " + e, e);
        }
    }

    public Double getParameterDouble(String name, Double defaultValue) {
        block3: {
            String value = this.getParameterValue(name, null);
            if (value != null) {
                try {
                    return StringNumberParser.parseDouble(value);
                }
                catch (NumberFormatException e) {
                    if (!LOG.isTraceEnabled()) break block3;
                    LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                }
            }
        }
        return defaultValue;
    }

    public Double getParameterDouble(String name) throws RepositoryConfigurationException {
        try {
            return StringNumberParser.parseDouble(this.getParameterValue(name));
        }
        catch (NumberFormatException e) {
            throw new RepositoryConfigurationException(name + ": unparseable Long. " + e, e);
        }
    }

    public Long getParameterTime(String name, Long defaultValue) {
        block3: {
            String value = this.getParameterValue(name, null);
            if (value != null) {
                try {
                    return StringNumberParser.parseTime(value);
                }
                catch (NumberFormatException e) {
                    if (!LOG.isTraceEnabled()) break block3;
                    LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                }
            }
        }
        return defaultValue;
    }

    public Long getParameterTime(String name) throws RepositoryConfigurationException {
        try {
            return StringNumberParser.parseTime(this.getParameterValue(name));
        }
        catch (NumberFormatException e) {
            throw new RepositoryConfigurationException(name + ": unparseable time (as Long). " + e, e);
        }
    }

    public Boolean getParameterBoolean(String name, Boolean defaultValue) {
        String value = this.getParameterValue(name, null);
        if (value != null) {
            return new Boolean(value);
        }
        return defaultValue;
    }

    public void putBooleanParameter(String name, Boolean value) {
        this.putParameterValue(name, value.toString());
    }

    public Boolean getParameterBoolean(String name) throws RepositoryConfigurationException {
        return new Boolean(this.getParameterValue(name));
    }

    public String getType() {
        return this.type;
    }

    public void setParameters(List<SimpleParameterEntry> parameters) {
        LinkedHashMap<String, SimpleParameterEntry> mParameters = new LinkedHashMap<String, SimpleParameterEntry>();
        if (parameters != null) {
            for (SimpleParameterEntry param : parameters) {
                mParameters.put(param.getName(), param);
            }
        }
        this.parameters = mParameters;
    }

    public void addParameter(SimpleParameterEntry param) {
        this.parameters.put(param.getName(), param);
    }

    public SimpleParameterEntry getParameter(String name) {
        return this.parameters.get(name);
    }

    public void setType(String type) {
        this.type = type;
    }
}

