/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl;

import java.io.InputStream;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.component.ThreadContext;
import org.exoplatform.container.component.ThreadContextHolder;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.RepositoryServiceConfiguration;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.core.security.JCRRuntimePermissions;
import org.exoplatform.services.jcr.impl.AddNamespacesPlugin;
import org.exoplatform.services.jcr.impl.AddNodeTypePlugin;
import org.exoplatform.services.jcr.impl.RepositoryContainer;
import org.exoplatform.services.jcr.impl.RepositoryCreationSynchronizer;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.SessionRegistry;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class RepositoryServiceImpl
implements RepositoryService,
Startable,
ThreadContextHolder {
    protected static Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.RepositoryServiceImpl");
    private final RepositoryServiceConfiguration config;
    private final ThreadLocal<String> currentRepositoryName = new ThreadLocal();
    private final ConcurrentHashMap<String, RepositoryContainer> repositoryContainers = new ConcurrentHashMap();
    private final List<ComponentPlugin> addNodeTypePlugins;
    private final List<ComponentPlugin> addNamespacesPlugins;
    private final ExoContainerContext containerContext;
    private ExoContainer parentContainer;

    public RepositoryServiceImpl(RepositoryServiceConfiguration configuration) {
        this(configuration, null);
    }

    public RepositoryServiceImpl(RepositoryServiceConfiguration configuration, ExoContainerContext context) {
        this(configuration, context, null);
    }

    public RepositoryServiceImpl(RepositoryServiceConfiguration configuration, ExoContainerContext context, RepositoryCreationSynchronizer synchronizer) {
        this.config = configuration;
        this.addNodeTypePlugins = new ArrayList<ComponentPlugin>();
        this.addNamespacesPlugins = new ArrayList<ComponentPlugin>();
        this.containerContext = context;
        this.currentRepositoryName.set(this.config.getDefaultRepositoryName());
    }

    public void addPlugin(ComponentPlugin plugin) {
        if (plugin instanceof AddNodeTypePlugin) {
            this.addNodeTypePlugins.add(plugin);
        } else if (plugin instanceof AddNamespacesPlugin) {
            this.addNamespacesPlugins.add(plugin);
        }
    }

    public void createRepository(RepositoryEntry rEntry) throws RepositoryConfigurationException, RepositoryException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
        }
        if (this.repositoryContainers.containsKey(rEntry.getName())) {
            throw new RepositoryConfigurationException("Repository container " + rEntry.getName() + " already started");
        }
        final RepositoryContainer repositoryContainer = new RepositoryContainer(this.parentContainer, rEntry, this.addNamespacesPlugins);
        try {
            if (this.repositoryContainers.putIfAbsent(rEntry.getName(), repositoryContainer) != null) {
                throw new RepositoryConfigurationException("Repository container " + rEntry.getName() + " already started");
            }
            SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    repositoryContainer.start();
                    return null;
                }
            });
        }
        catch (Throwable t) {
            this.repositoryContainers.remove(rEntry.getName());
            throw new RepositoryConfigurationException("Repository container " + rEntry.getName() + " was not started.", t);
        }
        if (!this.config.getRepositoryConfigurations().contains(rEntry)) {
            this.config.getRepositoryConfigurations().add(rEntry);
        }
        this.registerNodeTypes(rEntry.getName());
        ManageableRepository mr = (ManageableRepository)repositoryContainer.getComponentInstanceOfType(ManageableRepository.class);
        mr.setState(1);
    }

    public RepositoryServiceConfiguration getConfig() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
        }
        return this.config;
    }

    public ThreadContext getThreadContext() {
        return new ThreadContext(new ThreadLocal[]{this.currentRepositoryName});
    }

    public String getCurrentRepositoryName() {
        return this.currentRepositoryName.get();
    }

    public ManageableRepository getCurrentRepository() throws RepositoryException {
        if (this.currentRepositoryName.get() == null) {
            return this.getDefaultRepository();
        }
        return this.getRepository(this.currentRepositoryName.get());
    }

    public ManageableRepository getDefaultRepository() throws RepositoryException {
        return this.getRepository(this.config.getDefaultRepositoryName());
    }

    public ManageableRepository getRepository(String name) throws RepositoryException {
        RepositoryContainer repositoryContainer = this.repositoryContainers.get(name);
        log.debug((Object)("RepositoryServiceimpl() getRepository " + name));
        if (repositoryContainer == null) {
            throw new RepositoryException("Repository '" + name + "' not found.");
        }
        return (ManageableRepository)repositoryContainer.getComponentInstanceOfType(ManageableRepository.class);
    }

    public RepositoryContainer getRepositoryContainer(String name) {
        return this.repositoryContainers.get(name);
    }

    public void setCurrentRepositoryName(String repositoryName) throws RepositoryConfigurationException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
        }
        if (!this.repositoryContainers.containsKey(repositoryName)) {
            throw new RepositoryConfigurationException("Repository is not configured. Name " + repositoryName);
        }
        this.currentRepositoryName.set(repositoryName);
    }

    public void start() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
        }
        try {
            Object container = null;
            container = this.containerContext == null ? PortalContainer.getInstance() : this.containerContext.getContainer();
            this.init((ExoContainer)container);
        }
        catch (RepositoryException e) {
            log.error((Object)"Error start repository service", (Throwable)e);
        }
        catch (RepositoryConfigurationException e) {
            log.error((Object)"Error start repository service", (Throwable)e);
        }
        catch (Throwable e) {
            log.error((Object)"Error start repository service", e);
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
        }
        for (Map.Entry<String, RepositoryContainer> entry : this.repositoryContainers.entrySet()) {
            entry.getValue().stop();
        }
        this.repositoryContainers.clear();
        this.addNamespacesPlugins.clear();
        this.addNodeTypePlugins.clear();
    }

    private void init(ExoContainer container) throws RepositoryConfigurationException, RepositoryException {
        this.parentContainer = container;
        List<RepositoryEntry> rEntries = this.config.getRepositoryConfigurations();
        for (int i = 0; i < rEntries.size(); ++i) {
            RepositoryEntry rEntry = rEntries.get(i);
            this.createRepository(rEntry);
        }
    }

    private void registerNodeTypes(String repositoryName) throws RepositoryException {
        ConfigurationManager configService = (ConfigurationManager)this.parentContainer.getComponentInstanceOfType(ConfigurationManager.class);
        ExtendedNodeTypeManager ntManager = this.getRepository(repositoryName).getNodeTypeManager();
        for (int j = 0; j < this.addNodeTypePlugins.size(); ++j) {
            AddNodeTypePlugin plugin = (AddNodeTypePlugin)this.addNodeTypePlugins.get(j);
            List<String> autoNodeTypesFiles = plugin.getNodeTypesFiles("autoCreatedInNewRepository");
            if (autoNodeTypesFiles == null || autoNodeTypesFiles.size() <= 0) continue;
            for (String nodeTypeFilesName : autoNodeTypesFiles) {
                InputStream inXml;
                try {
                    inXml = configService.getInputStream(nodeTypeFilesName);
                }
                catch (Exception e) {
                    throw new RepositoryException((Throwable)e);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Trying register node types from xml-file " + nodeTypeFilesName));
                }
                ntManager.registerNodeTypes(inXml, 0, "text/xml");
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Node types is registered from xml-file " + nodeTypeFilesName));
            }
            List<String> defaultNodeTypesFiles = plugin.getNodeTypesFiles(repositoryName);
            if (defaultNodeTypesFiles == null || defaultNodeTypesFiles.size() <= 0) continue;
            for (String nodeTypeFilesName : defaultNodeTypesFiles) {
                InputStream inXml;
                try {
                    inXml = configService.getInputStream(nodeTypeFilesName);
                }
                catch (Exception e) {
                    throw new RepositoryException((Throwable)e);
                }
                log.info((Object)("Trying register node types (" + repositoryName + ") from xml-file " + nodeTypeFilesName));
                ntManager.registerNodeTypes(inXml, 0, "text/xml");
                log.info((Object)("Node types is registered (" + repositoryName + ") from xml-file " + nodeTypeFilesName));
            }
        }
    }

    public void removeRepository(String name) throws RepositoryException {
        this.removeRepository(name, false);
    }

    public void removeRepository(final String name, boolean forceRemove) throws RepositoryException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
        }
        if (!forceRemove && !this.canRemoveRepository(name)) {
            throw new RepositoryException("Repository " + name + " in use. If you want to " + " remove repository close all open sessions");
        }
        try {
            final RepositoryEntry repconfig = this.config.getRepositoryConfiguration(name);
            final RepositoryImpl repo = (RepositoryImpl)this.getRepository(name);
            repo.setState(0);
            SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws RepositoryException {
                    ArrayList<WorkspaceEntry> workspaces = new ArrayList<WorkspaceEntry>(repconfig.getWorkspaceEntries());
                    for (WorkspaceEntry entry : workspaces) {
                        repo.internalRemoveWorkspace(entry.getName());
                    }
                    RepositoryContainer repositoryContainer = (RepositoryContainer)((Object)RepositoryServiceImpl.this.repositoryContainers.get(name));
                    repositoryContainer.stop();
                    RepositoryServiceImpl.this.repositoryContainers.remove(name);
                    RepositoryServiceImpl.this.config.getRepositoryConfigurations().remove(repconfig);
                    RepositoryServiceImpl.this.parentContainer.unregisterComponent((Object)repositoryContainer.getName());
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RepositoryException) {
                throw (RepositoryException)cause;
            }
            throw new RepositoryException(cause);
        }
        catch (RepositoryConfigurationException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public boolean canRemoveRepository(String name) throws RepositoryException {
        RepositoryImpl repo = (RepositoryImpl)this.getRepository(name);
        try {
            RepositoryEntry repconfig = this.config.getRepositoryConfiguration(name);
            for (WorkspaceEntry wsEntry : repconfig.getWorkspaceEntries()) {
                if (repo.getSystemWorkspaceName().equals(wsEntry.getName()) || repo.canRemoveWorkspace(wsEntry.getName())) continue;
                return false;
            }
            RepositoryContainer repositoryContainer = this.repositoryContainers.get(name);
            SessionRegistry sessionRegistry = (SessionRegistry)repositoryContainer.getComponentInstance(SessionRegistry.class);
            if (sessionRegistry == null || sessionRegistry.isInUse(repo.getSystemWorkspaceName())) {
                return false;
            }
        }
        catch (RepositoryConfigurationException e) {
            throw new RepositoryException((Throwable)e);
        }
        return true;
    }
}

