/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.SingleDbJDBCConnection;

public class DB2SingleDbJDBCConnection
extends SingleDbJDBCConnection {
    public DB2SingleDbJDBCConnection(Connection dbConnection, boolean readOnly, JDBCDataContainerConfig containerConfig) throws SQLException {
        super(dbConnection, readOnly, containerConfig);
    }

    protected void prepareQueries() throws SQLException {
        super.prepareQueries();
        this.FIND_NODES_AND_PROPERTIES = "select J.*, P.ID AS P_ID, P.NAME AS P_NAME, P.VERSION AS P_VERSION, P.P_TYPE, P.P_MULTIVALUED, V.DATA, V.ORDER_NUM, V.STORAGE_DESC from JCR_SVALUE V, JCR_SITEM P join (select I.ID, I.PARENT_ID, I.NAME, I.VERSION, I.I_INDEX, I.N_ORDER_NUM from JCR_SITEM I where I.CONTAINER_NAME=? AND I.I_CLASS=1 AND I.ID > ? order by I.ID FETCH FIRST $rowNb ROWS ONLY) J on P.PARENT_ID = J.ID where P.I_CLASS=2 and P.CONTAINER_NAME=? and V.PROPERTY_ID=P.ID order by J.ID";
        if (this.containerConfig.useSequenceForOrderNumber) {
            this.FIND_LAST_ORDER_NUMBER = "SELECT " + this.JCR_ITEM_NEXT_VAL + " ('" + this.JCR_ITEM_SEQ + "', ?, ?) FROM SYSIBM.SYSDUMMY1";
            this.FIND_NODES_BY_PARENTID_LAZILY_CQ = "select I.*, P.NAME AS PROP_NAME, V.ORDER_NUM, V.DATA from JCR_SVALUE V, JCR_SITEM P  join (select J.* from JCR_SITEM J where J.CONTAINER_NAME=? AND J.I_CLASS=1 and J.PARENT_ID=? AND J.N_ORDER_NUM  >= ? order by J.N_ORDER_NUM, J.ID FETCH FIRST $rowNb ROWS ONLY) I on P.PARENT_ID = I.ID where P.I_CLASS=2 and P.CONTAINER_NAME=? and P.PARENT_ID=I.ID and (P.NAME='[http://www.jcp.org/jcr/1.0]primaryType' or P.NAME='[http://www.jcp.org/jcr/1.0]mixinTypes' or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]owner' or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]permissions') and V.PROPERTY_ID=P.ID order by I.N_ORDER_NUM, I.ID";
        }
    }

    protected ResultSet findNodesAndProperties(String lastNodeId, int offset, int limit) throws SQLException {
        if (this.findNodesAndProperties == null) {
            this.FIND_NODES_AND_PROPERTIES = this.FIND_NODES_AND_PROPERTIES.replace("$rowNb", Integer.toString(limit));
            this.findNodesAndProperties = this.dbConnection.prepareStatement(this.FIND_NODES_AND_PROPERTIES);
        } else {
            this.findNodesAndProperties.clearParameters();
        }
        this.findNodesAndProperties.setString(1, this.containerConfig.containerName);
        this.findNodesAndProperties.setString(2, this.getInternalId(lastNodeId));
        this.findNodesAndProperties.setString(3, this.containerConfig.containerName);
        return this.findNodesAndProperties.executeQuery();
    }

    protected ResultSet findChildNodesByParentIdentifier(String parentCid, int fromOrderNum, int offset, int limit) throws SQLException {
        if (!this.containerConfig.useSequenceForOrderNumber) {
            return super.findChildNodesByParentIdentifier(parentCid, fromOrderNum, offset, limit);
        }
        if (this.findNodesByParentIdLazilyCQ == null) {
            this.FIND_NODES_BY_PARENTID_LAZILY_CQ = this.FIND_NODES_BY_PARENTID_LAZILY_CQ.replace("$rowNb", Integer.toString(limit));
            this.findNodesByParentIdLazilyCQ = this.dbConnection.prepareStatement(this.FIND_NODES_BY_PARENTID_LAZILY_CQ);
        } else {
            this.findNodesByParentIdLazilyCQ.clearParameters();
        }
        this.findNodesByParentIdLazilyCQ.setString(1, this.containerConfig.containerName);
        this.findNodesByParentIdLazilyCQ.setString(2, parentCid);
        this.findNodesByParentIdLazilyCQ.setInt(3, fromOrderNum);
        this.findNodesByParentIdLazilyCQ.setString(4, this.containerConfig.containerName);
        return this.findNodesByParentIdLazilyCQ.executeQuery();
    }

    protected void startTxIfNeeded() throws SQLException {
        if (this.containerConfig.isManaged && this.dbConnection.getAutoCommit()) {
            this.dbConnection.setAutoCommit(false);
        }
    }
}

