/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.infinispan;

import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.jcr.RepositoryException;
import javax.management.MBeanServer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.database.utils.JDBCUtils;
import org.exoplatform.services.ispn.Utils;
import org.exoplatform.services.jcr.config.MappedParametrizedObjectEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.TemplateConfigurationHelper;
import org.exoplatform.services.jcr.infinispan.ISPNCacheHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.lookup.TransactionManagerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ISPNCacheFactory<K, V> {
    public static final String INFINISPAN_CONFIG = "infinispan-configuration";
    private final ConfigurationManager configurationManager;
    private final TransactionManager transactionManager;
    private final TemplateConfigurationHelper configurationHelper;
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.InfinispanCacheFactory");
    private static Map<String, CacheManagerInstance> CACHE_MANAGERS = new HashMap<String, CacheManagerInstance>();
    private static final MBeanServerLookup MBEAN_SERVER_LOOKUP = new MBeanServerLookup(){

        public MBeanServer getMBeanServer(Properties properties) {
            return ExoContainerContext.getTopContainer().getMBeanServer();
        }
    };

    public ISPNCacheFactory(ConfigurationManager configurationManager, TransactionManager transactionManager) {
        this.configurationManager = configurationManager;
        this.configurationHelper = new ISPNCacheHelper(configurationManager);
        this.transactionManager = transactionManager;
    }

    public ISPNCacheFactory(ConfigurationManager configurationManager) {
        this(configurationManager, null);
    }

    public Cache<K, V> createCache(String regionId, MappedParametrizedObjectEntry parameterEntry) throws RepositoryConfigurationException {
        EmbeddedCacheManager manager;
        InputStream configStream;
        String configurationPath = parameterEntry.getParameterValue(INFINISPAN_CONFIG);
        LOG.info((Object)("Infinispan Cache configuration used: " + configurationPath));
        final String regionIdEscaped = regionId.replace("-", "_");
        try {
            configStream = this.configurationHelper.fillTemplate(configurationPath, parameterEntry.getParameters());
        }
        catch (IOException e) {
            throw new RepositoryConfigurationException(e);
        }
        try {
            manager = (EmbeddedCacheManager)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<EmbeddedCacheManager>(){

                @Override
                public EmbeddedCacheManager run() throws Exception {
                    ParserRegistry parser = new ParserRegistry(Thread.currentThread().getContextClassLoader());
                    ConfigurationBuilderHolder holder = parser.parse(configStream);
                    GlobalConfigurationBuilder configBuilder = holder.getGlobalConfigurationBuilder();
                    Utils.loadJGroupsConfig((ConfigurationManager)ISPNCacheFactory.this.configurationManager, (GlobalConfiguration)configBuilder.build(), (GlobalConfigurationBuilder)configBuilder);
                    return ISPNCacheFactory.getUniqueInstance(regionIdEscaped, holder, ISPNCacheFactory.this.transactionManager);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            throw new RepositoryConfigurationException(cause);
        }
        PrivilegedAction action = new PrivilegedAction<Cache<K, V>>(){

            @Override
            public Cache<K, V> run() {
                Cache cache = manager.getCache(regionIdEscaped);
                if (cache.getStatus() == ComponentStatus.TERMINATED) {
                    cache.start();
                    LOG.info("The cache corresponding to the region {} was in state Terminated, so it has been restarted", new Object[]{regionIdEscaped});
                }
                return cache;
            }
        };
        Cache cache = (Cache)SecurityHelper.doPrivilegedAction((PrivilegedAction)action);
        return cache;
    }

    private static synchronized EmbeddedCacheManager getUniqueInstance(String regionId, ConfigurationBuilderHolder holder, final TransactionManager tm) {
        DefaultCacheManager manager;
        CacheManagerInstance cacheManagerInstance;
        GlobalConfigurationBuilder configBuilder = holder.getGlobalConfigurationBuilder();
        GlobalConfiguration gc = configBuilder.build();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        configBuilder.transport().clusterName(gc.transport().clusterName() + "_" + container.getContext().getName()).globalJmxStatistics().cacheManagerName(gc.globalJmxStatistics().cacheManagerName() + "_" + container.getContext().getName()).mBeanServerLookup(MBEAN_SERVER_LOOKUP);
        gc = configBuilder.build();
        String clusterName = gc.transport().clusterName();
        if (CACHE_MANAGERS.containsKey(clusterName)) {
            cacheManagerInstance = CACHE_MANAGERS.get(clusterName);
            cacheManagerInstance.acquire();
            manager = cacheManagerInstance.cacheManager;
        } else {
            manager = new DefaultCacheManager(gc);
            cacheManagerInstance = new CacheManagerInstance((EmbeddedCacheManager)manager);
            cacheManagerInstance.acquire();
            CACHE_MANAGERS.put(clusterName, cacheManagerInstance);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("A new ISPN Cache Manager instance has been registered for the region " + regionId + " and the container " + container.getContext().getName()));
            }
        }
        ConfigurationBuilder confBuilder = holder.getDefaultConfigurationBuilder();
        if (tm != null) {
            TransactionManagerLookup tml = new TransactionManagerLookup(){

                public TransactionManager getTransactionManager() throws Exception {
                    return tm;
                }
            };
            confBuilder.transaction().transactionManagerLookup(tml);
        }
        Configuration conf = holder.getDefaultConfigurationBuilder().build();
        manager.defineConfiguration(regionId, conf);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("The region " + regionId + " has been registered for the container " + container.getContext().getName()));
        }
        return manager;
    }

    public static synchronized void releaseUniqueInstance(EmbeddedCacheManager cacheManager) {
        Iterator<Map.Entry<String, CacheManagerInstance>> iterator = CACHE_MANAGERS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, CacheManagerInstance> next = iterator.next();
            if (!next.getValue().isSame(cacheManager)) continue;
            CacheManagerInstance cacheManagerInstance = next.getValue();
            cacheManagerInstance.release();
            if (!cacheManagerInstance.hasReferences()) {
                cacheManagerInstance.cacheManager.stop();
                iterator.remove();
            }
            return;
        }
    }

    public static void configureCacheStore(MappedParametrizedObjectEntry parameterEntry, String dataSourceParamName, String dataColumnParamName, String idColumnParamName, String timeColumnParamName, String dialectParamName) throws RepositoryException {
        String timeStampType;
        String charType;
        String blobType;
        DataSource dataSource;
        String dataSourceName = parameterEntry.getParameterValue(dataSourceParamName, null);
        String dialect = parameterEntry.getParameterValue(dialectParamName, "AUTO").toUpperCase();
        try {
            dataSource = (DataSource)new InitialContext().lookup(dataSourceName);
        }
        catch (NamingException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        try {
            blobType = JDBCUtils.getAppropriateBlobType((DataSource)dataSource);
            charType = dialect.startsWith("MYSQL") && dialect.endsWith("-UTF8") ? "VARCHAR(255)" : JDBCUtils.getAppropriateCharType((DataSource)dataSource);
            timeStampType = JDBCUtils.getAppropriateTimestamp((DataSource)dataSource);
        }
        catch (SQLException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        if (parameterEntry.getParameterValue(dataColumnParamName, "auto").equalsIgnoreCase("auto")) {
            parameterEntry.putParameterValue(dataColumnParamName, blobType);
        }
        if (parameterEntry.getParameterValue(idColumnParamName, "auto").equalsIgnoreCase("auto")) {
            parameterEntry.putParameterValue(idColumnParamName, charType);
        }
        if (parameterEntry.getParameterValue(timeColumnParamName, "auto").equalsIgnoreCase("auto")) {
            parameterEntry.putParameterValue(timeColumnParamName, timeStampType);
        }
    }

    private static class CacheManagerInstance {
        private final EmbeddedCacheManager cacheManager;
        private int references;

        public CacheManagerInstance(EmbeddedCacheManager cache) {
            this.cacheManager = cache;
        }

        private void acquire() {
            ++this.references;
        }

        private void release() {
            --this.references;
        }

        private boolean hasReferences() {
            return this.references > 0;
        }

        private boolean isSame(EmbeddedCacheManager cacheManager) {
            return this.cacheManager == cacheManager;
        }
    }
}

