/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.cdi.contexts;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.PassivationCapable;
import org.exoplatform.portal.pc.aspects.PortletLifecyclePhaseInterceptor;
import org.gatein.cdi.contexts.PortletRequestLifecycle;
import org.gatein.cdi.contexts.SerializableBeanStoreInstance;
import org.gatein.cdi.contexts.beanstore.BeanStore;
import org.gatein.cdi.contexts.beanstore.BeanStoreInstance;
import org.gatein.cdi.contexts.beanstore.LockedBean;

public abstract class AbstractCDIPortletContext
implements Context {
    private final ThreadLocal<BeanStore> beanStore;
    private final ThreadLocal<Map<String, PortletRequestLifecycle>> lifecycles;
    private final ThreadLocal<PortletRequestLifecycle> currentLifecycle;
    private final boolean multithreaded;

    protected AbstractCDIPortletContext(boolean multithreaded) {
        this.multithreaded = multithreaded;
        this.beanStore = new ThreadLocal();
        this.lifecycles = new ThreadLocal();
        this.currentLifecycle = new ThreadLocal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        BeanStore beanStore = this.getBeanStore();
        if (beanStore == null) {
            return null;
        }
        String id = AbstractCDIPortletContext.getId(contextual);
        BeanStoreInstance beanInstance = beanStore.getBean(id);
        if (beanInstance != null) {
            return beanInstance.getInstance();
        }
        if (creationalContext != null) {
            LockedBean lock = null;
            try {
                Object instance;
                if (this.multithreaded) {
                    lock = beanStore.lock(id);
                    beanInstance = beanStore.getBean(id);
                    if (beanInstance != null) {
                        Object t = beanInstance.getInstance();
                        return t;
                    }
                }
                if ((instance = contextual.create(creationalContext)) != null) {
                    beanInstance = new SerializableBeanStoreInstance<Object>(contextual, instance, creationalContext);
                    beanStore.put(id, beanInstance);
                }
                Object object = instance;
                return (T)object;
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }
        return null;
    }

    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    public boolean isActive() {
        return this.currentLifecycle.get() != null;
    }

    protected void setCurrentLifecycle(String windowId, PortletRequestLifecycle lifecycle) {
        if (lifecycle == null) {
            this.currentLifecycle.remove();
            Map<String, PortletRequestLifecycle> map = this.lifecycles.get();
            if (null != map) {
                map.remove(windowId);
            }
        } else {
            this.currentLifecycle.set(lifecycle);
            Map<String, PortletRequestLifecycle> map = this.lifecycles.get();
            if (map == null) {
                map = new HashMap<String, PortletRequestLifecycle>();
                this.lifecycles.set(map);
            }
            map.put(windowId, lifecycle);
        }
    }

    protected PortletRequestLifecycle getLifecycle(String windowId) {
        Map<String, PortletRequestLifecycle> map = this.lifecycles.get();
        if (map == null) {
            map = new HashMap<String, PortletRequestLifecycle>();
            this.lifecycles.set(map);
        }
        return map.get(windowId);
    }

    protected BeanStore getBeanStore() {
        return this.beanStore.get();
    }

    protected void setBeanStore(BeanStore beanStore) {
        if (beanStore == null) {
            this.beanStore.remove();
        } else {
            this.beanStore.set(beanStore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy(String windowId) {
        try {
            BeanStore store = this.getBeanStore();
            if (store != null) {
                store.destroy(windowId);
            }
        }
        finally {
            Map<String, PortletRequestLifecycle> map = this.lifecycles.get();
            if (map != null) {
                map.remove(windowId);
                if (map.isEmpty()) {
                    this.lifecycles.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        try {
            BeanStore store = this.getBeanStore();
            if (store != null) {
                store.destroy();
            }
        }
        finally {
            this.cleanup();
        }
    }

    protected void cleanup() {
        this.lifecycles.remove();
        this.beanStore.remove();
    }

    private static String getId(Contextual contextual) {
        String id = contextual instanceof PassivationCapable ? ((PassivationCapable)contextual).getId() : "" + contextual.hashCode();
        return AbstractCDIPortletContext.windowId() + "#" + id;
    }

    private static String windowId() {
        return PortletLifecyclePhaseInterceptor.currentWindowId();
    }
}

