/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.storage.jcr;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.calendar.model.query.CalendarQuery;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.impl.CalendarServiceImpl;
import org.exoplatform.calendar.service.impl.JCRDataStorage;
import org.exoplatform.calendar.storage.CalendarDAO;
import org.exoplatform.calendar.storage.Storage;
import org.exoplatform.calendar.storage.jcr.JCRStorage;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;

public class JCRCalendarDAOImpl
implements CalendarDAO {
    private Storage context;
    private JCRDataStorage dataStorage;
    private static final Log LOG = ExoLogger.getExoLogger(JCRCalendarDAOImpl.class);
    private static final ListAccess<Calendar> EMPTY = new ListAccess<Calendar>(){

        public Calendar[] load(int i, int i2) throws Exception, IllegalArgumentException {
            return new Calendar[0];
        }

        public int getSize() throws Exception {
            return 0;
        }
    };

    public JCRCalendarDAOImpl(CalendarService service, JCRStorage context) {
        this.context = context;
        this.dataStorage = ((CalendarServiceImpl)service).getDataStorage();
    }

    @Override
    public Calendar getById(String id) {
        try {
            Calendar cal = this.dataStorage.getCalendarById(id);
            if (cal != null) {
                cal.setDS("jcr");
            }
            return cal;
        }
        catch (Exception ex) {
            LOG.error((Object)"Exception while loading calendar by ID", (Throwable)ex);
            return null;
        }
    }

    @Override
    public org.exoplatform.calendar.model.Calendar save(org.exoplatform.calendar.model.Calendar calendar) {
        return this.persist(calendar, true);
    }

    @Override
    public org.exoplatform.calendar.model.Calendar update(org.exoplatform.calendar.model.Calendar cal) {
        return this.persist(cal, false);
    }

    private org.exoplatform.calendar.model.Calendar persist(org.exoplatform.calendar.model.Calendar cal, boolean isNew) {
        Calendar o = cal instanceof Calendar ? (Calendar)cal : Calendar.build(cal);
        int type = o.getCalType();
        if (type == Calendar.Type.PERSONAL.type()) {
            try {
                this.dataStorage.saveUserCalendar(o.getCalendarOwner(), o, isNew);
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
        } else if (type == Calendar.Type.GROUP.type()) {
            try {
                this.dataStorage.savePublicCalendar(o, isNew, null);
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
        } else {
            throw new UnsupportedOperationException("Save calendar with type '" + type + "' is not supported");
        }
        return cal;
    }

    @Override
    public Calendar remove(String id) {
        Calendar calendar = this.getById(id);
        if (calendar == null) {
            return null;
        }
        if (calendar.getCalType() == Calendar.Type.PERSONAL.type()) {
            try {
                this.dataStorage.removeUserCalendar(calendar.getCalendarOwner(), id);
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
        } else if (calendar.getCalType() == Calendar.Type.GROUP.type()) {
            try {
                this.dataStorage.removeGroupCalendar(id);
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
        }
        return calendar;
    }

    @Override
    public Calendar newInstance() {
        Calendar c = new Calendar();
        c.setDS("jcr");
        return c;
    }

    @Override
    public List<org.exoplatform.calendar.model.Calendar> findCalendars(CalendarQuery query) {
        LinkedList<org.exoplatform.calendar.model.Calendar> calendars = new LinkedList<org.exoplatform.calendar.model.Calendar>();
        List<Object> excludes = Collections.emptyList();
        String[] excludesId = query.getExclusions();
        if (excludesId != null) {
            excludes = Arrays.asList(excludesId);
        }
        try {
            List<GroupCalendarData> datas;
            GroupCalendarData data;
            Identity identity = query.getIdentity();
            List<Calendar> cals = this.dataStorage.getUserCalendars(identity.getUserId(), true);
            if (cals != null && cals.size() > 0) {
                for (Calendar c : cals) {
                    if (excludes.contains(c.getId())) continue;
                    calendars.add(c);
                }
            }
            if ((data = this.dataStorage.getSharedCalendars(identity.getUserId(), true)) != null && data.getCalendars().size() > 0) {
                for (Calendar c : data.getCalendars()) {
                    if (excludes.contains(c.getId())) continue;
                    calendars.add(c);
                }
            }
            if ((datas = this.dataStorage.getGroupCalendars(identity.getGroups().toArray(new String[0]), true, identity.getUserId())) != null && datas.size() > 0) {
                for (GroupCalendarData d : datas) {
                    for (Calendar c : d.getCalendars()) {
                        if (excludes.contains(c.getId())) continue;
                        calendars.add(c);
                    }
                }
            }
            for (org.exoplatform.calendar.model.Calendar cal : calendars) {
                cal.setDS("jcr");
            }
            return calendars;
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            return null;
        }
    }
}

