/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.setting;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.notification.NotificationConfiguration;
import org.exoplatform.commons.notification.NotificationUtils;
import org.exoplatform.commons.notification.impl.AbstractService;
import org.exoplatform.commons.notification.impl.NotificationSessionManager;
import org.exoplatform.commons.notification.job.NotificationJob;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.impl.UserImpl;

public class UserSettingServiceImpl
extends AbstractService
implements UserSettingService {
    private static final Log LOG = ExoLogger.getLogger(UserSettingServiceImpl.class);
    private static final Scope NOTIFICATION_SCOPE = Scope.GLOBAL.id(null);
    private SettingService settingService;
    private ChannelManager channelManager;
    private final String workspace;
    protected static final int MAX_LIMIT = 30;
    public static final String NAME_PATTERN = "exo:{CHANNELID}Channel";
    final transient ReentrantLock lock = new ReentrantLock();

    public UserSettingServiceImpl(SettingService settingService, NotificationConfiguration configuration, ChannelManager channelManager) {
        this.settingService = settingService;
        this.workspace = configuration.getWorkspace();
        this.channelManager = channelManager;
    }

    private Node getUserSettingHome(Session session) throws Exception {
        Node settingNode = session.getRootNode().getNode("settings");
        Node userHomeNode = null;
        if (!settingNode.hasNode("user")) {
            userHomeNode = settingNode.addNode("user", "stg:subcontext");
            session.save();
        } else {
            userHomeNode = settingNode.getNode("user");
        }
        return userHomeNode;
    }

    public void save(UserSetting model) {
        String userId = model.getUserId();
        String dailys = NotificationUtils.listToString(model.getDailyPlugins(), "{VALUE}");
        String weeklys = NotificationUtils.listToString(model.getWeeklyPlugins(), "{VALUE}");
        String channelActives = NotificationUtils.listToString(model.getChannelActives(), "{VALUE}");
        ArrayList channels = new ArrayList(model.getAllChannelPlugins().keySet());
        for (String channelId : channels) {
            this.saveUserSetting(userId, this.getChannelProperty(channelId), NotificationUtils.listToString(model.getPlugins(channelId), "{VALUE}"));
        }
        this.saveUserSetting(userId, "exo:daily", dailys);
        this.saveUserSetting(userId, "exo:weekly", weeklys);
        this.saveUserSetting(userId, "exo:isActive", channelActives);
        this.saveUserSetting(userId, "exo:isEnabled", "" + model.isEnabled());
        if (model.getLastReadDate() > 0L) {
            this.saveLastReadDate(userId, model.getLastReadDate());
        }
        this.removeMixin(userId);
    }

    private String getChannelProperty(String channelId) {
        return NAME_PATTERN.replace("{CHANNELID}", channelId);
    }

    private void saveUserSetting(String userId, String key, String value) {
        this.settingService.set(Context.USER.id(userId), NOTIFICATION_SCOPE, key, SettingValue.create((String)value));
    }

    public UserSetting get(String userId) {
        UserSetting model = UserSetting.getInstance();
        List<String> actives = this.getArrayListValue(userId, "exo:isActive", null);
        if (actives != null) {
            model.setUserId(userId);
            model.setChannelActives(actives);
            List channels = this.channelManager.getChannels();
            for (AbstractChannel channel : channels) {
                model.setChannelPlugins(channel.getId(), this.getArrayListValue(userId, this.getChannelProperty(channel.getId()), new ArrayList<String>()));
            }
            model.setDailyPlugins(this.getArrayListValue(userId, "exo:daily", new ArrayList<String>()));
            model.setWeeklyPlugins(this.getArrayListValue(userId, "exo:weekly", new ArrayList<String>()));
        } else {
            model = UserSetting.getDefaultInstance().setUserId(userId);
            this.addMixin(userId);
        }
        SettingValue<String> value = this.getSettingValue(userId, "exo:lastReadDate");
        if (value != null) {
            model.setLastReadDate(((Long)value.getValue()).longValue());
        } else {
            this.saveLastReadDate(userId, 0L);
        }
        SettingValue<String> isEnabled = this.getSettingValue(userId, "exo:isEnabled");
        if (isEnabled != null) {
            model.setEnabled(Boolean.valueOf((String)isEnabled.getValue()).booleanValue());
        }
        return model;
    }

    private SettingValue<String> getSettingValue(String userId, String propertyName) {
        return this.settingService.get(Context.USER.id(userId), NOTIFICATION_SCOPE, propertyName);
    }

    private List<String> getArrayListValue(String userId, String propertyName, List<String> defaultValue) {
        SettingValue<String> values = this.getSettingValue(userId, propertyName);
        if (values != null) {
            String strs = (String)values.getValue();
            if ("true".equals(strs)) {
                strs = UserSetting.EMAIL_CHANNEL;
            }
            if ("false".equals(strs)) {
                return defaultValue;
            }
            return NotificationUtils.stringToList(UserSettingServiceImpl.getValues(strs));
        }
        return defaultValue;
    }

    public void addMixin(String userId) {
        this.addMixin(new User[]{new UserImpl(userId)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMixin(User[] users) {
        boolean created = NotificationSessionManager.createSystemProvider();
        SessionProvider sProvider = NotificationSessionManager.getSessionProvider();
        try {
            this.addMixin(sProvider, users);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to add mixin for default setting of users", (Throwable)e);
        }
        finally {
            NotificationSessionManager.closeSessionProvider(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMixin(SessionProvider sProvider, User[] users) {
        ReentrantLock lock = this.lock;
        try {
            Session session = UserSettingServiceImpl.getSession(sProvider, this.workspace);
            Node userHomeNode = this.getUserSettingHome(session);
            lock.lock();
            for (int i = 0; i < users.length; ++i) {
                User user = users[i];
                if (user == null || user.getUserName() == null) continue;
                Node userNode = userHomeNode.hasNode(user.getUserName()) ? userHomeNode.getNode(user.getUserName()) : userHomeNode.addNode(user.getUserName(), "stg:simplecontext");
                if (userNode.canAddMixin("mix:defaultSetting")) {
                    userNode.addMixin("mix:defaultSetting");
                    LOG.debug((Object)("Done to addMixin default setting for user: " + user.getUserName()));
                }
                if ((i + 1) % 200 != 0) continue;
                session.save();
            }
            session.save();
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to addMixin for user notification setting", (Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    private void removeMixin(String userId) {
        SessionProvider sProvider = CommonsUtils.getSystemSessionProvider();
        try {
            Node userNode;
            Session session = UserSettingServiceImpl.getSession(sProvider, this.workspace);
            Node userHomeNode = session.getRootNode().getNode("settings/user");
            if (userHomeNode.hasNode(userId) && (userNode = userHomeNode.getNode(userId)).isNodeType("mix:defaultSetting")) {
                userNode.removeMixin("mix:defaultSetting");
                UserSettingServiceImpl.sessionSave(userNode);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to remove mixin for default setting of user: " + userId), (Throwable)e);
        }
    }

    private StringBuilder buildQuery(NotificationContext context) {
        StringBuilder queryBuffer = new StringBuilder();
        queryBuffer.append(this.buildSQLLikeProperty("exo:isActive", UserSetting.EMAIL_CHANNEL));
        Boolean isWeekly = (Boolean)context.value(NotificationJob.JOB_WEEKLY);
        if (isWeekly.booleanValue()) {
            queryBuffer.append(" AND ").append("exo:weekly").append("<>''");
        } else {
            queryBuffer.append(" AND ").append("exo:daily").append("<>''");
        }
        queryBuffer.append(" AND (").append("exo:isEnabled").append(" IS NULL OR ").append("exo:isEnabled").append(" = 'true')");
        return queryBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UserSetting> getUserSettingWithDeactivate() {
        boolean created = NotificationSessionManager.createSystemProvider();
        SessionProvider sProvider = NotificationSessionManager.getSessionProvider();
        ArrayList<UserSetting> models = new ArrayList<UserSetting>();
        try {
            Session session = UserSettingServiceImpl.getSession(sProvider, this.workspace);
            if (!session.getRootNode().hasNode("settings/user")) {
                ArrayList<UserSetting> arrayList = models;
                return arrayList;
            }
            StringBuilder strQuery = new StringBuilder("SELECT * FROM ").append("stg:scope");
            strQuery.append(" WHERE (").append("exo:isActive").append("='')").append(" OR (").append("exo:isEnabled").append(" IS NOT NULL AND ").append("exo:isEnabled").append(" = 'false')");
            QueryManager qm = session.getWorkspace().getQueryManager();
            QueryImpl query = (QueryImpl)qm.createQuery(strQuery.toString(), "sql");
            NodeIterator iter = query.execute().getNodes();
            while (iter != null && iter.hasNext()) {
                Node node = iter.nextNode();
                models.add(this.fillModel(node));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Can not get the user setting with deactivated");
        }
        finally {
            NotificationSessionManager.closeSessionProvider(created);
        }
        return models;
    }

    public List<String> getUserSettingByPlugin(String pluginId) {
        return this.getUserHasSettingPlugin(UserSetting.EMAIL_CHANNEL, pluginId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getUserHasSettingPlugin(String channelId, String pluginId) {
        boolean created = NotificationSessionManager.createSystemProvider();
        SessionProvider sProvider = NotificationSessionManager.getSessionProvider();
        ArrayList<String> userIds = new ArrayList<String>();
        try {
            NodeIterator iter = this.getUserHasSettingPlugin(sProvider, channelId, pluginId);
            while (iter != null && iter.hasNext()) {
                Node node = iter.nextNode();
                userIds.add(node.getParent().getName());
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to get all users have the " + pluginId + " in settings"), (Throwable)e);
        }
        finally {
            NotificationSessionManager.closeSessionProvider(created);
        }
        return userIds;
    }

    private NodeIterator getUserHasSettingPlugin(SessionProvider sProvider, String channelId, String pluginId) throws Exception {
        Session session = UserSettingServiceImpl.getSession(sProvider, this.workspace);
        if (!session.getRootNode().hasNode("settings/user")) {
            return null;
        }
        String property = this.getChannelProperty(channelId);
        StringBuilder strQuery = new StringBuilder("SELECT * FROM ").append("stg:scope");
        String plugin = UserSettingServiceImpl.getValue(pluginId);
        strQuery.append(" WHERE").append(this.buildSQLLikeProperty("exo:isActive", channelId)).append(" AND (");
        if (UserSetting.EMAIL_CHANNEL.equals(channelId)) {
            strQuery.append(this.buildSQLLikeProperty(property, plugin)).append(" OR").append(this.buildSQLLikeProperty("exo:daily", plugin)).append(" OR").append(this.buildSQLLikeProperty("exo:weekly", plugin));
        } else {
            strQuery.append(this.buildSQLLikeProperty(property, plugin));
        }
        strQuery.append(" ) AND (").append("exo:isEnabled").append(" IS NULL OR ").append("exo:isEnabled").append(" = 'true'");
        strQuery.append(" )");
        QueryManager qm = session.getWorkspace().getQueryManager();
        QueryImpl query = (QueryImpl)qm.createQuery(strQuery.toString(), "sql");
        return query.execute().getNodes();
    }

    private NodeIterator getDigestIterator(NotificationContext context, SessionProvider sProvider, int offset, int limit) throws Exception {
        Session session = UserSettingServiceImpl.getSession(sProvider, this.workspace);
        if (!session.getRootNode().hasNode("settings/user")) {
            return null;
        }
        StringBuilder strQuery = new StringBuilder("SELECT * FROM ").append("stg:scope");
        strQuery.append(" WHERE ").append((CharSequence)this.buildQuery(context));
        QueryManager qm = session.getWorkspace().getQueryManager();
        QueryImpl query = (QueryImpl)qm.createQuery(strQuery.toString(), "sql");
        if (limit > 0) {
            query.setLimit((long)limit);
            query.setOffset((long)offset);
        }
        return query.execute().getNodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UserSetting> getDigestSettingForAllUser(NotificationContext context, int offset, int limit) {
        boolean created = NotificationSessionManager.createSystemProvider();
        SessionProvider sProvider = NotificationSessionManager.getSessionProvider();
        ArrayList<UserSetting> models = new ArrayList<UserSetting>();
        try {
            NodeIterator iter = this.getDigestIterator(context, sProvider, offset, limit);
            while (iter != null && iter.hasNext()) {
                Node node = iter.nextNode();
                models.add(this.fillModel(node));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to get all daily users have notification messages", (Throwable)e);
        }
        finally {
            NotificationSessionManager.closeSessionProvider(created);
        }
        return models;
    }

    private List<String> getValues(Node node, String propertyName) throws Exception {
        try {
            String values = node.getProperty(propertyName).getString();
            return NotificationUtils.stringToList(UserSettingServiceImpl.getValues(values));
        }
        catch (Exception e) {
            return new ArrayList<String>();
        }
    }

    private UserSetting fillModel(Node node) throws Exception {
        UserSetting model = UserSetting.getInstance();
        model.setUserId(node.getParent().getName());
        model.setDailyPlugins(this.getValues(node, "exo:daily"));
        model.setWeeklyPlugins(this.getValues(node, "exo:weekly"));
        model.setChannelActives(this.getValues(node, "exo:isActive"));
        List channels = this.channelManager.getChannels();
        for (AbstractChannel channel : channels) {
            model.setChannelPlugins(channel.getId(), this.getValues(node, this.getChannelProperty(channel.getId())));
        }
        model.setLastUpdateTime(node.getParent().getProperty("exo:lastModifiedDate").getDate());
        if (node.hasProperty("exo:isEnabled")) {
            model.setEnabled(Boolean.valueOf(node.getProperty("exo:isEnabled").getString()).booleanValue());
        }
        return model;
    }

    private NodeIterator getDefaultDailyIterator(SessionProvider sProvider, int offset, int limit) throws Exception {
        Session session = UserSettingServiceImpl.getSession(sProvider, this.workspace);
        StringBuilder strQuery = new StringBuilder("SELECT * FROM ").append("mix:defaultSetting");
        strQuery.append(" WHERE jcr:path LIKE '/").append("settings/user").append("/%' AND NOT jcr:path LIKE '/").append("settings/user").append("/%/%'");
        QueryManager qm = session.getWorkspace().getQueryManager();
        QueryImpl query = (QueryImpl)qm.createQuery(strQuery.toString(), "sql");
        if (limit > 0) {
            query.setLimit((long)limit);
            query.setOffset((long)offset);
        }
        return query.execute().getNodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UserSetting> getDigestDefaultSettingForAllUser(int offset, int limit) {
        boolean created = NotificationSessionManager.createSystemProvider();
        SessionProvider sProvider = NotificationSessionManager.getSessionProvider();
        ArrayList<UserSetting> users = new ArrayList<UserSetting>();
        try {
            Session session = UserSettingServiceImpl.getSession(sProvider, this.workspace);
            if (session.getRootNode().hasNode("settings/user")) {
                NodeIterator iter = this.getDefaultDailyIterator(sProvider, offset, limit);
                while (iter.hasNext()) {
                    Node node = iter.nextNode();
                    users.add(UserSetting.getInstance().setUserId(node.getName()).setLastUpdateTime(node.getProperty("exo:lastModifiedDate").getDate()));
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to get default daily users have notification messages", (Throwable)e);
        }
        finally {
            NotificationSessionManager.closeSessionProvider(created);
        }
        return users;
    }

    private String buildSQLLikeProperty(String property, String value) {
        StringBuilder strQuery = new StringBuilder(" (").append(property).append(" LIKE '%").append(value).append("%'").append(")");
        return strQuery.toString();
    }

    public void saveLastReadDate(String userId, Long time) {
        this.settingService.set(Context.USER.id(userId), NOTIFICATION_SCOPE, "exo:lastReadDate", SettingValue.create((Long)time));
    }
}

