/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity.provider;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.social.core.identity.IdentityProvider;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.webui.exception.MessageException;

public class OrganizationIdentityProvider
extends IdentityProvider<User> {
    private static final Log LOG = ExoLogger.getLogger((String)"organization");
    private OrganizationService organizationService;
    public static final String NAME = "organization";

    public OrganizationIdentityProvider(OrganizationService organizationService) {
        this.organizationService = organizationService;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public List<String> getAllUserId() {
        try {
            ListAccess allUsers = this.organizationService.getUserHandler().findAllUsers();
            int MAX_USERS = 500;
            User[] users = (User[])allUsers.load(0, allUsers.getSize() >= 500 ? 500 : allUsers.getSize());
            ArrayList<String> userIds = new ArrayList<String>();
            for (User user : users) {
                userIds.add(user.getUserName());
            }
            return userIds;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load all users");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User findByRemoteId(String remoteId) {
        User user;
        try {
            RequestLifeCycle.begin((ComponentRequestLifecycle)((ComponentRequestLifecycle)this.organizationService));
            UserHandler userHandler = this.organizationService.getUserHandler();
            user = userHandler.findUserByName(remoteId, UserStatus.ANY);
        }
        catch (Exception e) {
            User user2 = null;
            return user2;
        }
        finally {
            RequestLifeCycle.end();
        }
        return user;
    }

    @Override
    public Identity createIdentity(User user) {
        Identity identity = new Identity(NAME, user.getUserName());
        identity.setEnable(user.isEnabled());
        return identity;
    }

    @Override
    public void populateProfile(Profile profile, User user) {
        profile.setProperty("firstName", user.getFirstName());
        profile.setProperty("lastName", user.getLastName());
        profile.setProperty("fullName", user.getDisplayName());
        profile.setProperty("username", user.getUserName());
        profile.setProperty("email", user.getEmail());
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        LinkProvider lp = (LinkProvider)container.getComponentInstanceOfType(LinkProvider.class);
    }

    @Override
    public void onUpdateProfile(Profile profile) throws MessageException {
        new UpdateProfileProcess(profile).doUpdate();
    }

    private class UpdateProfileProcess {
        private Profile updatedProfile = null;
        private String userName = null;

        public UpdateProfileProcess(Profile updatedProfile) {
            this.updatedProfile = updatedProfile;
            this.userName = (String)updatedProfile.getProperty("username");
        }

        public void doUpdate() throws MessageException {
            try {
                if (this.updatedProfile.getListUpdateTypes().contains((Object)Profile.UpdateType.CONTACT)) {
                    this.updateBasicInfo();
                    this.updateContact();
                }
            }
            catch (Exception e) {
                if (e instanceof MessageException) {
                    throw (MessageException)e;
                }
                LOG.warn((Object)"Failed to update user by profile", (Throwable)e);
            }
        }

        private void updateBasicInfo() throws Exception {
            String firstName = (String)this.updatedProfile.getProperty("firstName");
            String lastName = (String)this.updatedProfile.getProperty("lastName");
            String email = (String)this.updatedProfile.getProperty("email");
            String fullName = firstName + " " + lastName;
            boolean hasUpdate = false;
            User foundUser = OrganizationIdentityProvider.this.organizationService.getUserHandler().findUserByName(this.userName);
            if (foundUser == null) {
                return;
            }
            if (!foundUser.getFirstName().equals(firstName)) {
                foundUser.setFirstName(firstName);
                hasUpdate = true;
            }
            if (!foundUser.getLastName().equals(lastName)) {
                foundUser.setLastName(lastName);
                hasUpdate = true;
            }
            if (foundUser.getEmail() == null || !foundUser.getEmail().equals(email)) {
                foundUser.setEmail(email);
                hasUpdate = true;
            }
            if (!foundUser.getDisplayName().equals(fullName)) {
                foundUser.setDisplayName(fullName);
                hasUpdate = true;
            }
            if (hasUpdate) {
                OrganizationIdentityProvider.this.organizationService.getUserHandler().saveUser(foundUser, true);
            }
        }

        private void updateContact() throws Exception {
            String gender = (String)this.updatedProfile.getProperty("gender");
            UserProfile foundUserProfile = OrganizationIdentityProvider.this.organizationService.getUserProfileHandler().findUserProfileByName(this.userName);
            if (foundUserProfile == null) {
                foundUserProfile = OrganizationIdentityProvider.this.organizationService.getUserProfileHandler().createUserProfileInstance(this.userName);
            }
            String uGender = foundUserProfile.getAttribute(UserProfile.PERSONAL_INFO_KEYS[4]);
            if (gender != null && !gender.equals(uGender)) {
                foundUserProfile.setAttribute(UserProfile.PERSONAL_INFO_KEYS[4], gender);
                OrganizationIdentityProvider.this.organizationService.getUserProfileHandler().saveUserProfile(foundUserProfile, false);
            }
            this.updatePositionAndGender();
        }

        private void updatePositionAndGender() throws Exception {
            String position = (String)this.updatedProfile.getProperty("position");
            String gender = (String)this.updatedProfile.getProperty("gender");
            UserProfile foundUserProfile = OrganizationIdentityProvider.this.organizationService.getUserProfileHandler().findUserProfileByName(this.userName);
            if (foundUserProfile == null) {
                foundUserProfile = OrganizationIdentityProvider.this.organizationService.getUserProfileHandler().createUserProfileInstance(this.userName);
            }
            boolean hasUpdated = false;
            String uPosition = foundUserProfile.getAttribute(UserProfile.PERSONAL_INFO_KEYS[7]);
            if (position != null && !position.equals(uPosition)) {
                foundUserProfile.setAttribute(UserProfile.PERSONAL_INFO_KEYS[7], position);
                hasUpdated = true;
            }
            String uGender = foundUserProfile.getAttribute(UserProfile.PERSONAL_INFO_KEYS[4]);
            if (gender != null && !gender.equals(uGender)) {
                foundUserProfile.setAttribute(UserProfile.PERSONAL_INFO_KEYS[4], gender);
                hasUpdated = true;
            }
            if (hasUpdated) {
                OrganizationIdentityProvider.this.organizationService.getUserProfileHandler().saveUserProfile(foundUserProfile, false);
            }
        }
    }
}

