/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.cache.model.data;

import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.storage.cache.model.data.CacheData;

public class IdentityData
implements CacheData<Identity> {
    private final String id;
    private final String providerId;
    private final String remoteId;
    private final boolean isDeleted;
    private final boolean isEnabled;

    public IdentityData(Identity identity) {
        if (identity != null) {
            this.id = identity.getId();
            this.providerId = identity.getProviderId();
            this.remoteId = identity.getRemoteId();
            this.isDeleted = identity.isDeleted();
            this.isEnabled = identity.isEnable();
        } else {
            this.id = null;
            this.providerId = null;
            this.remoteId = null;
            this.isDeleted = false;
            this.isEnabled = true;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public String getRemoteId() {
        return this.remoteId;
    }

    @Override
    public Identity build() {
        if (this.id == null) {
            return null;
        }
        Identity identity = new Identity(this.id);
        identity.setProviderId(this.providerId);
        identity.setRemoteId(this.remoteId);
        identity.setDeleted(this.isDeleted);
        identity.setEnable(this.isEnabled);
        return identity;
    }
}

