/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.mop.core.util;

import java.util.Date;
import org.gatein.mop.api.Attributes;
import org.gatein.mop.api.Key;
import org.gatein.mop.api.ValueType;

public abstract class AbstractAttributes
implements Attributes {
    protected abstract Object get(String var1);

    protected abstract void set(String var1, Object var2);

    private <T> T getObject(String name, ValueType<T> type, T defaultValue) {
        if (name == null) {
            throw new NullPointerException();
        }
        Object o = this.get(name);
        if (o == null) {
            return defaultValue;
        }
        return (T)type.cast(o);
    }

    public final Object getObject(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        Object o = this.get(name);
        if (o == null) {
            return null;
        }
        ValueType.get((Object)o);
        return o;
    }

    public final <T> void setObject(String name, T value) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            this.set(name, null);
        } else {
            ValueType.get(value);
            this.set(name, value);
        }
    }

    public final ValueType<?> getType(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        Object o = this.get(name);
        if (o == null) {
            return null;
        }
        return ValueType.get((Object)o);
    }

    public final String getString(String name) {
        return this.getObject(name, ValueType.STRING, null);
    }

    public final void setString(String name, String value) {
        this.setObject(name, value);
    }

    public final Boolean getBoolean(String name) {
        return this.getObject(name, ValueType.BOOLEAN, null);
    }

    public final void setBoolean(String name, Boolean value) {
        this.setObject(name, value);
    }

    public final Integer getInteger(String name) {
        return this.getObject(name, ValueType.INTEGER, null);
    }

    public final void setInteger(String name, Integer value) {
        this.setObject(name, value);
    }

    public final Date getDate(String name) {
        return this.getObject(name, ValueType.DATE, null);
    }

    public final void setDate(String name, Date value) {
        this.setObject(name, value);
    }

    public final Double getDouble(String name) {
        return this.getObject(name, ValueType.DOUBLE, null);
    }

    public final void setDouble(String name, Double value) {
        this.setObject(name, value);
    }

    public final <T> T getValue(Key<T> key, T defaultValue) {
        return this.getObject(key.getName(), key.getType(), defaultValue);
    }

    public final <T> T getValue(Key<T> key) {
        return this.getObject(key.getName(), key.getType(), null);
    }

    public final <T> void setValue(Key<T> key, T value) {
        this.setObject(key.getName(), value);
    }
}

