/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.SequenceCurrentValueFunction;
import liquibase.statement.SequenceNextValueFunction;

public class ObjectUtil {
    private static Map<Class<?>, Method[]> methodCache = new HashMap();

    public static Object getProperty(Object object, String propertyName) throws IllegalAccessException, InvocationTargetException {
        Method readMethod = ObjectUtil.getReadMethod(object, propertyName);
        if (readMethod == null) {
            throw new UnexpectedLiquibaseException("Property '" + propertyName + "' not found on object type " + object.getClass().getName());
        }
        return readMethod.invoke(object, new Object[0]);
    }

    public static Class getPropertyType(Object object, String propertyName) {
        Method readMethod = ObjectUtil.getReadMethod(object, propertyName);
        if (readMethod == null) {
            return null;
        }
        return readMethod.getReturnType();
    }

    public static boolean hasProperty(Object object, String propertyName) {
        return ObjectUtil.hasReadProperty(object, propertyName) && ObjectUtil.hasWriteProperty(object, propertyName);
    }

    public static boolean hasReadProperty(Object object, String propertyName) {
        return ObjectUtil.getReadMethod(object, propertyName) != null;
    }

    public static boolean hasWriteProperty(Object object, String propertyName) {
        return ObjectUtil.getWriteMethod(object, propertyName) != null;
    }

    public static void setProperty(Object object, String propertyName, String propertyValue) {
        Method method = ObjectUtil.getWriteMethod(object, propertyName);
        if (method == null) {
            throw new UnexpectedLiquibaseException("Property '" + propertyName + "' not found on object type " + object.getClass().getName());
        }
        Class<?> parameterType = method.getParameterTypes()[0];
        Object finalValue = propertyValue;
        if (parameterType.equals(Boolean.class) || parameterType.equals(Boolean.TYPE)) {
            finalValue = Boolean.valueOf(propertyValue);
        } else if (parameterType.equals(Integer.class)) {
            finalValue = Integer.valueOf(propertyValue);
        } else if (parameterType.equals(Long.class)) {
            finalValue = Long.valueOf(propertyValue);
        } else if (parameterType.equals(BigInteger.class)) {
            finalValue = new BigInteger(propertyValue);
        } else if (parameterType.equals(BigDecimal.class)) {
            finalValue = new BigDecimal(propertyValue);
        } else if (parameterType.equals(DatabaseFunction.class)) {
            finalValue = new DatabaseFunction(propertyValue);
        } else if (parameterType.equals(SequenceNextValueFunction.class)) {
            finalValue = new SequenceNextValueFunction(propertyValue);
        } else if (parameterType.equals(SequenceCurrentValueFunction.class)) {
            finalValue = new SequenceCurrentValueFunction(propertyValue);
        } else if (Enum.class.isAssignableFrom(parameterType)) {
            finalValue = Enum.valueOf(parameterType, propertyValue);
        }
        try {
            method.invoke(object, finalValue);
        }
        catch (IllegalAccessException e) {
            throw new UnexpectedLiquibaseException(e);
        }
        catch (IllegalArgumentException e) {
            throw new UnexpectedLiquibaseException("Cannot call " + method.toString() + " with value of type " + finalValue.getClass().getName());
        }
        catch (InvocationTargetException e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    public static void setProperty(Object object, String propertyName, Object propertyValue) {
        Method method = ObjectUtil.getWriteMethod(object, propertyName);
        if (method == null) {
            throw new UnexpectedLiquibaseException("Property '" + propertyName + "' not found on object type " + object.getClass().getName());
        }
        try {
            if (!method.getParameterTypes()[0].isAssignableFrom(propertyValue.getClass())) {
                ObjectUtil.setProperty(object, propertyName, propertyValue.toString());
                return;
            }
            method.invoke(object, propertyValue);
        }
        catch (IllegalAccessException e) {
            throw new UnexpectedLiquibaseException(e);
        }
        catch (IllegalArgumentException e) {
            throw new UnexpectedLiquibaseException("Cannot call " + method.toString() + " with value of type " + propertyValue.getClass().getName());
        }
        catch (InvocationTargetException e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    private static Method getReadMethod(Object object, String propertyName) {
        Method[] methods;
        String getMethodName = "get" + propertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propertyName.substring(1);
        String isMethodName = "is" + propertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propertyName.substring(1);
        for (Method method : methods = ObjectUtil.getMethods(object)) {
            if (!method.getName().equals(getMethodName) && !method.getName().equals(isMethodName) || method.getParameterTypes().length != 0) continue;
            return method;
        }
        return null;
    }

    private static Method getWriteMethod(Object object, String propertyName) {
        Method[] methods;
        String methodName = "set" + propertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propertyName.substring(1);
        for (Method method : methods = ObjectUtil.getMethods(object)) {
            if (!method.getName().equals(methodName) || method.getParameterTypes().length != 1) continue;
            return method;
        }
        return null;
    }

    private static Method[] getMethods(Object object) {
        Method[] methods = methodCache.get(object.getClass());
        if (methods == null) {
            methods = object.getClass().getMethods();
            methodCache.put(object.getClass(), methods);
        }
        return methods;
    }
}

