/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.CachingContainer;
import org.exoplatform.container.ConcurrentContainer;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.management.ManageableContainer;
import org.exoplatform.container.spi.After;
import org.exoplatform.container.spi.Before;
import org.exoplatform.container.spi.Interceptor;
import org.exoplatform.container.spi.InterceptorChainFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultInterceptorChainFactory
implements InterceptorChainFactory {
    private volatile List<Class<? extends Interceptor>> chain;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Interceptor getInterceptorChain(ExoContainer holder, ExoContainer parent) {
        if (this.chain == null) {
            DefaultInterceptorChainFactory defaultInterceptorChainFactory = this;
            synchronized (defaultInterceptorChainFactory) {
                if (this.chain == null) {
                    List<Interceptor> staticInts = this.getStaticInterceptors(holder, parent);
                    List<Interceptor> dynamicInts = this.getDynamicInterceptors(holder, parent);
                    List<Interceptor> interceptors = this.resolve(staticInts, dynamicInts);
                    Interceptor result = null;
                    LinkedList<Class<? extends Interceptor>> chain = new LinkedList<Class<? extends Interceptor>>();
                    StringBuilder sb = null;
                    boolean isDevelopping = PropertyManager.isDevelopping();
                    if (isDevelopping) {
                        sb = new StringBuilder();
                    }
                    int length = interceptors.size();
                    for (int i = 0; i < length; ++i) {
                        Interceptor it = interceptors.get(i);
                        it.setSuccessor(result);
                        chain.add(it.getClass());
                        if (isDevelopping) {
                            sb.insert(0, "-> " + it.getClass().getName() + " ");
                        }
                        result = it;
                    }
                    if (isDevelopping) {
                        System.out.println("The interceptor chain used is " + sb);
                    }
                    this.chain = chain;
                    return result;
                }
            }
        }
        Interceptor result = null;
        for (Class<? extends Interceptor> iClass : this.chain) {
            try {
                Interceptor it = iClass.cast(iClass.newInstance());
                it.setHolder(holder);
                it.setParent(parent);
                it.setSuccessor(result);
                result = it;
            }
            catch (Exception e) {
                System.out.println("ERROR: Cannot instantiate inteceptor of class " + iClass + ": " + e.getLocalizedMessage());
            }
        }
        return result;
    }

    protected List<Interceptor> getStaticInterceptors(ExoContainer holder, ExoContainer parent) {
        ArrayList<Interceptor> list = new ArrayList<Interceptor>(4);
        list.add(new ConcurrentContainer(holder, parent));
        list.add(new CachingContainer());
        list.add(new ManageableContainer(holder, parent));
        return list;
    }

    protected List<Interceptor> getDynamicInterceptors(ExoContainer holder, ExoContainer parent) {
        ArrayList<Interceptor> list = new ArrayList<Interceptor>();
        ServiceLoader<Interceptor> loader = ServiceLoader.load(Interceptor.class);
        for (Interceptor interceptor : loader) {
            interceptor.setHolder(holder);
            interceptor.setParent(parent);
            list.add(interceptor);
        }
        return list;
    }

    protected List<Interceptor> resolve(List<Interceptor> staticInts, List<Interceptor> dynamicInts) {
        ArrayList<Interceptor> alreadyResolved = new ArrayList<Interceptor>(staticInts);
        LinkedList<Interceptor> toBeResolved = new LinkedList<Interceptor>(dynamicInts);
        Iterator<Interceptor> iter = toBeResolved.iterator();
        while (iter.hasNext()) {
            this.resolveNext(alreadyResolved, iter, false);
        }
        iter = toBeResolved.iterator();
        while (iter.hasNext()) {
            this.resolveNext(alreadyResolved, iter, true);
        }
        return alreadyResolved;
    }

    protected void resolveNext(List<Interceptor> alreadyResolved, Iterator<Interceptor> iter, boolean resolveIfAbsent) {
        Interceptor it = iter.next();
        Before b = it.getClass().getAnnotation(Before.class);
        if (b != null) {
            String id = b.value();
            if (id == null || (id = id.trim()).isEmpty()) {
                if (PropertyManager.isDevelopping()) {
                    System.out.println("WARN: No value set for the annotation Before of the interceptor " + it.getClass());
                }
                alreadyResolved.add(it);
                iter.remove();
                return;
            }
            int length = alreadyResolved.size();
            for (int i = 0; i < length; ++i) {
                Interceptor interceptor = alreadyResolved.get(i);
                if (!id.equals(interceptor.getId())) continue;
                if (i < length - 1) {
                    alreadyResolved.add(i + 1, it);
                } else {
                    alreadyResolved.add(it);
                }
                iter.remove();
                return;
            }
            if (resolveIfAbsent) {
                if (PropertyManager.isDevelopping()) {
                    System.out.println("WARN: Could not find the interceptor of " + id + " required by the interceptor " + it.getClass());
                }
                alreadyResolved.add(it);
                iter.remove();
            }
            return;
        }
        After a = it.getClass().getAnnotation(After.class);
        if (a != null) {
            String id = a.value();
            if (id == null || (id = id.trim()).isEmpty()) {
                if (PropertyManager.isDevelopping()) {
                    System.out.println("WARN: No value set for the annotation After of the interceptor " + it.getClass());
                }
                alreadyResolved.add(it);
                iter.remove();
                return;
            }
            int length = alreadyResolved.size();
            for (int i = 0; i < length; ++i) {
                Interceptor interceptor = alreadyResolved.get(i);
                if (!id.equals(interceptor.getId())) continue;
                alreadyResolved.add(i, it);
                iter.remove();
                return;
            }
            if (resolveIfAbsent) {
                if (PropertyManager.isDevelopping()) {
                    System.out.println("WARN: Could not find the interceptor of " + id + " required by the interceptor " + it.getClass());
                }
                alreadyResolved.add(it);
                iter.remove();
            }
            return;
        }
        alreadyResolved.add(it);
        iter.remove();
    }
}

