/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.io.File;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.jcr.access.AccessManager;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.backup.JCRRestore;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.SysViewWorkspaceInitializer;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheableWorkspaceDataManager;

public class BackupWorkspaceInitializer
extends SysViewWorkspaceInitializer {
    protected final String restoreDir;

    public BackupWorkspaceInitializer(WorkspaceEntry config, RepositoryEntry repConfig, CacheableWorkspaceDataManager dataManager, NamespaceRegistryImpl namespaceRegistry, LocationFactory locationFactory, NodeTypeManagerImpl nodeTypeManager, ValueFactoryImpl valueFactory, AccessManager accessManager) throws RepositoryConfigurationException, PathNotFoundException, RepositoryException {
        super(config, repConfig, dataManager, namespaceRegistry, locationFactory, nodeTypeManager, valueFactory, accessManager);
        this.restoreDir = this.restorePath;
        String fullBackupPath = PrivilegedFileHelper.getAbsolutePath((File)JCRRestore.getFullBackupFile(new File(this.restoreDir)));
        if (fullBackupPath == null) {
            throw new RepositoryException("Can't find full backup storage");
        }
        this.restorePath = fullBackupPath;
    }

    @Override
    protected void doRestore() throws Throwable {
        super.doRestore();
        JCRRestore restorer = new JCRRestore(this.dataManager, this.spoolConfig.fileCleaner);
        for (File incrBackupFile : JCRRestore.getIncrementalFiles(new File(this.restoreDir))) {
            restorer.incrementalRestore(incrBackupFile);
        }
    }
}

