/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import javax.transaction.xa.XAResource;
import javax.xml.stream.XMLStreamException;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.access.AccessManager;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.CredentialsImpl;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.core.NamespaceAccessor;
import org.exoplatform.services.jcr.core.SessionLifecycleListener;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.ItemImpl;
import org.exoplatform.services.jcr.impl.core.JCRPath;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionFactory;
import org.exoplatform.services.jcr.impl.core.SessionRegistry;
import org.exoplatform.services.jcr.impl.core.WorkspaceImpl;
import org.exoplatform.services.jcr.impl.core.lock.SessionLockManager;
import org.exoplatform.services.jcr.impl.core.lock.WorkspaceLockManager;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeImpl;
import org.exoplatform.services.jcr.impl.core.observation.ObservationManagerImpl;
import org.exoplatform.services.jcr.impl.core.observation.ObservationManagerRegistry;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.ItemDataMoveVisitor;
import org.exoplatform.services.jcr.impl.dataflow.persistent.LocalWorkspaceDataManagerStub;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableResourceManager;
import org.exoplatform.services.jcr.impl.ext.action.SessionActionCatalog;
import org.exoplatform.services.jcr.impl.ext.action.SessionActionInterceptor;
import org.exoplatform.services.jcr.impl.util.io.FileCleanerHolder;
import org.exoplatform.services.jcr.impl.xml.ExportImportFactory;
import org.exoplatform.services.jcr.impl.xml.ItemDataKeeperAdapter;
import org.exoplatform.services.jcr.impl.xml.XmlMapping;
import org.exoplatform.services.jcr.impl.xml.exporting.BaseXmlExporter;
import org.exoplatform.services.jcr.impl.xml.importing.StreamImporter;
import org.exoplatform.services.jcr.storage.WorkspaceDataContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SessionImpl
implements ExtendedSession,
NamespaceAccessor {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.SessionImpl");
    public static final boolean ALLOW_CLOSED_SESSION_USAGE = Boolean.valueOf(PropertyManager.getProperty((String)"exo.jcr.allow.closed.session.usage"));
    protected static boolean FORCE_USE_GET_NODES_LAZILY = Boolean.valueOf(PropertyManager.getProperty((String)"org.exoplatform.jcr.forceUserGetNodesLazily"));
    private static final AtomicLong SEQUENCE;
    public static final int DEFAULT_LAZY_READ_THRESHOLD = 100;
    private final RepositoryImpl repository;
    private final ConversationState userState;
    private final WorkspaceImpl workspace;
    private final Map<String, String> namespaces;
    private final Map<String, String> prefixes;
    private final AccessManager accessManager;
    private final LocationFactory locationFactory;
    private final ValueFactoryImpl valueFactory;
    private final ExoContainer container;
    private final LocationFactory systemLocationFactory;
    private final SessionLockManager lockManager;
    protected final String workspaceName;
    private boolean live;
    private boolean expired;
    private Exception closedByCallStack;
    private final List<SessionLifecycleListener> lifecycleListeners;
    private final String id;
    private final SessionActionInterceptor actionHandler;
    private long lastAccessTime;
    Boolean triggerEventsForDescendantsOnMove;
    Boolean triggerEventsForDescendantsOnRename;
    int maxDescendantNodesAllowed;
    private int lazyNodeIteatorPageSize;
    private final int lazyReadThreshold;
    private final SessionRegistry sessionRegistry;
    protected final SessionDataManager dataManager;
    protected final NodeTypeDataManager nodeTypeManager;
    protected final FileCleanerHolder cleanerHolder;
    private final TransactionableResourceManager txResourceManager;
    private long timeout;

    public SessionImpl(String workspaceName, ConversationState userState, ExoContainer container) throws RepositoryException {
        this.workspaceName = workspaceName;
        this.container = container;
        this.live = true;
        this.id = System.currentTimeMillis() + "_" + SEQUENCE.incrementAndGet();
        this.userState = userState;
        this.txResourceManager = (TransactionableResourceManager)container.getComponentInstanceOfType(TransactionableResourceManager.class, false);
        this.repository = (RepositoryImpl)container.getComponentInstanceOfType(RepositoryImpl.class, false);
        this.systemLocationFactory = (LocationFactory)container.getComponentInstanceOfType(LocationFactory.class, false);
        this.accessManager = (AccessManager)container.getComponentInstanceOfType(AccessManager.class, false);
        WorkspaceEntry wsConfig = (WorkspaceEntry)container.getComponentInstanceOfType(WorkspaceEntry.class, false);
        this.lazyReadThreshold = wsConfig.getLazyReadThreshold() > 0 ? wsConfig.getLazyReadThreshold() : 100;
        this.locationFactory = new LocationFactory(this);
        this.cleanerHolder = (FileCleanerHolder)container.getComponentInstanceOfType(FileCleanerHolder.class, false);
        this.valueFactory = new ValueFactoryImpl(this.locationFactory, wsConfig, this.cleanerHolder);
        this.namespaces = new LinkedHashMap<String, String>();
        this.prefixes = new LinkedHashMap<String, String>();
        ObservationManagerRegistry observationManagerRegistry = (ObservationManagerRegistry)container.getComponentInstanceOfType(ObservationManagerRegistry.class, false);
        ObservationManagerImpl observationManager = observationManagerRegistry.createObservationManager(this);
        LocalWorkspaceDataManagerStub workspaceDataManager = (LocalWorkspaceDataManagerStub)container.getComponentInstanceOfType(LocalWorkspaceDataManagerStub.class, false);
        this.dataManager = new SessionDataManager(this, workspaceDataManager);
        this.lockManager = ((WorkspaceLockManager)container.getComponentInstanceOfType(WorkspaceLockManager.class, false)).getSessionLockManager(this.id, this.dataManager);
        this.nodeTypeManager = (NodeTypeDataManager)container.getComponentInstanceOfType(NodeTypeDataManager.class, false);
        this.workspace = new WorkspaceImpl(workspaceName, container, this, observationManager);
        this.lifecycleListeners = new ArrayList<SessionLifecycleListener>();
        this.registerLifecycleListener(observationManager);
        this.registerLifecycleListener(this.lockManager);
        SessionActionCatalog catalog = (SessionActionCatalog)((Object)container.getComponentInstanceOfType(SessionActionCatalog.class, false));
        this.actionHandler = new SessionActionInterceptor(catalog, container, workspaceName);
        this.sessionRegistry = (SessionRegistry)container.getComponentInstanceOfType(SessionRegistry.class, false);
        this.sessionRegistry.registerSession(this);
        this.lastAccessTime = System.currentTimeMillis();
        this.triggerEventsForDescendantsOnMove = wsConfig.getContainer().getParameterBoolean("trigger-events-for-descendants-on-move", WorkspaceDataContainer.TRIGGER_EVENTS_FOR_DESCENDANTS_ON_MOVE_DEFAULT);
        this.triggerEventsForDescendantsOnRename = wsConfig.getContainer().getParameterBoolean("trigger-events-for-descendents-on-rename", this.triggerEventsForDescendantsOnMove);
        this.triggerEventsForDescendantsOnRename = wsConfig.getContainer().getParameterBoolean("trigger-events-for-descendants-on-rename", this.triggerEventsForDescendantsOnRename);
        this.maxDescendantNodesAllowed = wsConfig.getContainer().getParameterInteger("max-descendant-nodes-allowed-on-move", 100);
        this.lazyNodeIteatorPageSize = wsConfig.getContainer().getParameterInteger("lazy-node-iterator-page-size", 100);
    }

    public void addLockToken(String lt) {
        this.getLockManager().addLockToken(lt);
    }

    public void checkPermission(String absPath, String actions) throws AccessControlException {
        try {
            JCRPath jcrPath = this.locationFactory.parseAbsPath(absPath);
            AccessControlList acl = this.dataManager.getACL(jcrPath.getInternalPath());
            if (!this.accessManager.hasPermission(acl, actions, this.getUserState().getIdentity())) {
                throw new AccessControlException("Permission denied " + absPath + " : " + actions);
            }
        }
        catch (RepositoryException e) {
            throw new AccessControlException("Could not check permission for " + absPath + " " + (Object)((Object)e));
        }
    }

    public void exportDocumentView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws InvalidSerializedDataException, PathNotFoundException, SAXException, RepositoryException {
        this.checkLive();
        LocationFactory factory = new LocationFactory((NamespaceRegistryImpl)this.repository.getNamespaceRegistry());
        WorkspaceEntry wsConfig = (WorkspaceEntry)this.container.getComponentInstanceOfType(WorkspaceEntry.class);
        ValueFactoryImpl valueFactoryImpl = new ValueFactoryImpl(factory, wsConfig, this.cleanerHolder);
        try {
            BaseXmlExporter exporter = new ExportImportFactory().getExportVisitor(XmlMapping.DOCVIEW, contentHandler, skipBinary, noRecurse, (ItemDataConsumer)this.getTransientNodesManager(), this.repository.getNamespaceRegistry(), valueFactoryImpl);
            JCRPath srcNodePath = this.getLocationFactory().parseAbsPath(absPath);
            ItemData srcItemData = this.dataManager.getItemData(srcNodePath.getInternalPath());
            if (srcItemData == null) {
                throw new PathNotFoundException("No node exists at " + absPath);
            }
            exporter.export((NodeData)srcItemData);
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public void exportDocumentView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws InvalidSerializedDataException, IOException, PathNotFoundException, RepositoryException {
        this.checkLive();
        LocationFactory factory = new LocationFactory((NamespaceRegistryImpl)this.repository.getNamespaceRegistry());
        WorkspaceEntry wsConfig = (WorkspaceEntry)this.container.getComponentInstanceOfType(WorkspaceEntry.class);
        ValueFactoryImpl valueFactoryImpl = new ValueFactoryImpl(factory, wsConfig, this.cleanerHolder);
        try {
            BaseXmlExporter exporter = new ExportImportFactory().getExportVisitor(XmlMapping.DOCVIEW, out, skipBinary, noRecurse, (ItemDataConsumer)this.getTransientNodesManager(), this.repository.getNamespaceRegistry(), valueFactoryImpl);
            JCRPath srcNodePath = this.getLocationFactory().parseAbsPath(absPath);
            ItemData srcItemData = this.dataManager.getItemData(srcNodePath.getInternalPath());
            if (srcItemData == null) {
                throw new PathNotFoundException("No node exists at " + absPath);
            }
            exporter.export((NodeData)srcItemData);
        }
        catch (XMLStreamException e) {
            throw new IOException(e.getLocalizedMessage(), e);
        }
        catch (SAXException e) {
            throw new IOException(e.getLocalizedMessage(), e);
        }
    }

    public void exportWorkspaceSystemView(OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, PathNotFoundException, RepositoryException {
        this.checkLive();
        LocationFactory factory = new LocationFactory((NamespaceRegistryImpl)this.repository.getNamespaceRegistry());
        WorkspaceEntry wsConfig = (WorkspaceEntry)this.container.getComponentInstanceOfType(WorkspaceEntry.class);
        ValueFactoryImpl valueFactoryImpl = new ValueFactoryImpl(factory, wsConfig, this.cleanerHolder);
        try {
            BaseXmlExporter exporter = new ExportImportFactory().getExportVisitor(XmlMapping.BACKUP, out, skipBinary, noRecurse, (ItemDataConsumer)this.getTransientNodesManager(), this.repository.getNamespaceRegistry(), valueFactoryImpl);
            ItemData srcItemData = this.dataManager.getItemData("00exo0jcr0root0uuid0000000000000");
            if (srcItemData == null) {
                throw new PathNotFoundException("Root node not found");
            }
            exporter.export((NodeData)srcItemData);
        }
        catch (XMLStreamException e) {
            throw new IOException(e.getLocalizedMessage(), e);
        }
        catch (SAXException e) {
            throw new IOException(e.getLocalizedMessage(), e);
        }
    }

    public void exportSystemView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws PathNotFoundException, SAXException, RepositoryException {
        this.checkLive();
        LocationFactory factory = new LocationFactory((NamespaceRegistryImpl)this.repository.getNamespaceRegistry());
        WorkspaceEntry wsConfig = (WorkspaceEntry)this.container.getComponentInstanceOfType(WorkspaceEntry.class);
        ValueFactoryImpl valueFactoryImpl = new ValueFactoryImpl(factory, wsConfig, this.cleanerHolder);
        try {
            BaseXmlExporter exporter = new ExportImportFactory().getExportVisitor(XmlMapping.SYSVIEW, contentHandler, skipBinary, noRecurse, (ItemDataConsumer)this.getTransientNodesManager(), this.repository.getNamespaceRegistry(), valueFactoryImpl);
            JCRPath srcNodePath = this.getLocationFactory().parseAbsPath(absPath);
            ItemData srcItemData = this.dataManager.getItemData(srcNodePath.getInternalPath());
            if (srcItemData == null) {
                throw new PathNotFoundException("No node exists at " + absPath);
            }
            exporter.export((NodeData)srcItemData);
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void exportSystemView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse, boolean exportChildVersionHisotry) throws IOException, PathNotFoundException, RepositoryException {
        this.checkLive();
        LocationFactory factory = new LocationFactory((NamespaceRegistryImpl)this.repository.getNamespaceRegistry());
        WorkspaceEntry wsConfig = (WorkspaceEntry)this.container.getComponentInstanceOfType(WorkspaceEntry.class);
        ValueFactoryImpl valueFactoryImpl = new ValueFactoryImpl(factory, wsConfig, this.cleanerHolder);
        try {
            BaseXmlExporter exporter = new ExportImportFactory().getExportVisitor(XmlMapping.SYSVIEW, out, skipBinary, noRecurse, exportChildVersionHisotry, this.getTransientNodesManager(), this.repository.getNamespaceRegistry(), valueFactoryImpl);
            JCRPath srcNodePath = this.getLocationFactory().parseAbsPath(absPath);
            ItemData srcItemData = this.dataManager.getItemData(srcNodePath.getInternalPath());
            if (srcItemData == null) {
                throw new PathNotFoundException("No node exists at " + absPath);
            }
            exporter.export((NodeData)srcItemData);
        }
        catch (XMLStreamException e) {
            throw new IOException(e.getLocalizedMessage(), e);
        }
        catch (SAXException e) {
            throw new IOException(e.getLocalizedMessage(), e);
        }
    }

    public void exportSystemView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, PathNotFoundException, RepositoryException {
        this.exportSystemView(absPath, out, skipBinary, noRecurse, false);
    }

    public AccessManager getAccessManager() {
        return this.accessManager;
    }

    public SessionActionInterceptor getActionHandler() {
        return this.actionHandler;
    }

    @Override
    public String[] getAllNamespacePrefixes() throws RepositoryException {
        return this.getNamespacePrefixes();
    }

    public Object getAttribute(String name) {
        return this.userState.getAttribute(name);
    }

    public String[] getAttributeNames() {
        Set attributes = this.userState.getAttributeNames();
        String[] names = new String[attributes.size()];
        int i = 0;
        for (String name : attributes) {
            names[i++] = name;
        }
        return names;
    }

    @Deprecated
    public ExoContainer getContainer() {
        return this.container;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws PathNotFoundException, ConstraintViolationException, VersionException, RepositoryException {
        this.checkLive();
        NodeImpl node = (NodeImpl)this.getItem(parentAbsPath);
        if (!node.checkedOut()) {
            throw new VersionException("Node " + node.getPath() + " or its nearest ancestor is checked-in");
        }
        if (node.getDefinition().isProtected()) {
            throw new ConstraintViolationException("Can't add protected node " + node.getName() + " to " + node.getParent().getPath());
        }
        if (!node.checkLocking()) {
            throw new LockException("Node " + node.getPath() + " is locked ");
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("respectPropertyDefinitionsConstraints", true);
        return new ExportImportFactory().getImportHandler((NodeData)node.getData(), uuidBehavior, new ItemDataKeeperAdapter(this.getTransientNodesManager()), this.getTransientNodesManager(), this.nodeTypeManager, this.getLocationFactory(), this.getValueFactory(), this.getWorkspace().getNamespaceRegistry(), this.getAccessManager(), this.userState, context, (RepositoryImpl)this.getRepository(), this.getWorkspace().getName());
    }

    public ItemImpl getItem(String absPath) throws PathNotFoundException, RepositoryException {
        this.checkLive();
        JCRPath loc = this.locationFactory.parseAbsPath(absPath);
        ItemImpl item = this.dataManager.getItem(loc.getInternalPath(), true);
        if (item != null) {
            return item;
        }
        throw new PathNotFoundException("Item not found " + absPath + " in workspace " + this.workspaceName);
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public LocationFactory getLocationFactory() {
        return this.locationFactory;
    }

    public SessionLockManager getLockManager() {
        return this.lockManager;
    }

    public String[] getLockTokens() {
        return this.getLockManager().getLockTokens();
    }

    public String getNamespacePrefix(String uri) throws NamespaceException, RepositoryException {
        if (this.prefixes.containsKey(uri)) {
            return this.prefixes.get(uri);
        }
        return this.workspace.getNamespaceRegistry().getPrefix(uri);
    }

    @Override
    public String getNamespacePrefixByURI(String uri) throws NamespaceException, RepositoryException {
        return this.getNamespacePrefix(uri);
    }

    public String[] getNamespacePrefixes() throws RepositoryException {
        LinkedList<String> allPrefixes = new LinkedList<String>();
        allPrefixes.addAll(this.namespaces.keySet());
        String[] permanentPrefixes = this.workspace.getNamespaceRegistry().getPrefixes();
        for (int i = 0; i < permanentPrefixes.length; ++i) {
            if (this.prefixes.containsKey(this.workspace.getNamespaceRegistry().getURI(permanentPrefixes[i]))) continue;
            allPrefixes.add(permanentPrefixes[i]);
        }
        return allPrefixes.toArray(new String[allPrefixes.size()]);
    }

    public String getNamespaceURI(String prefix) throws NamespaceException, RepositoryException {
        String uri = null;
        if (this.namespaces.size() > 0 && (uri = this.namespaces.get(prefix)) != null) {
            return uri;
        }
        return this.workspace.getNamespaceRegistry().getURI(prefix);
    }

    @Override
    public String getNamespaceURIByPrefix(String prefix) throws NamespaceException, RepositoryException {
        return this.getNamespaceURI(prefix);
    }

    @Override
    public Node getNodeByIdentifier(String identifier) throws ItemNotFoundException, RepositoryException {
        this.checkLive();
        ItemImpl item = this.dataManager.getItemByIdentifier(identifier, true);
        if (item != null && item.isNode()) {
            return (Node)item;
        }
        throw new ItemNotFoundException("Node not found " + identifier + " at " + this.workspaceName);
    }

    public Node getNodeByUUID(String uuid) throws ItemNotFoundException, RepositoryException {
        this.checkLive();
        ItemImpl item = this.dataManager.getItemByIdentifier(uuid, true);
        if (item != null && item.isNode()) {
            NodeImpl node = (NodeImpl)item;
            node.getUUID();
            return node;
        }
        throw new ItemNotFoundException("Node not found " + uuid + " at " + this.workspaceName);
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Node getRootNode() throws RepositoryException {
        this.checkLive();
        ItemImpl item = this.dataManager.getItemByIdentifier("00exo0jcr0root0uuid0000000000000", true);
        if (item != null && item.isNode()) {
            return (NodeImpl)item;
        }
        throw new ItemNotFoundException("Node not found / at " + this.workspaceName);
    }

    public SessionDataManager getTransientNodesManager() {
        return this.dataManager;
    }

    public String getUserID() {
        return this.userState.getIdentity().getUserId();
    }

    public ValueFactoryImpl getValueFactory() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.valueFactory;
    }

    public WorkspaceImpl getWorkspace() {
        return this.workspace;
    }

    public boolean hasPendingChanges() throws RepositoryException {
        return this.dataManager.hasPendingChanges(Constants.ROOT_PATH);
    }

    public Session impersonate(Credentials credentials) throws LoginException, RepositoryException {
        String name;
        if (credentials instanceof CredentialsImpl) {
            name = ((CredentialsImpl)credentials).getUserID();
        } else if (credentials instanceof SimpleCredentials) {
            name = ((SimpleCredentials)credentials).getUserID();
        } else {
            throw new LoginException("Credentials for the authentication should be CredentialsImpl or SimpleCredentials type");
        }
        SessionFactory sessionFactory = (SessionFactory)this.container.getComponentInstanceOfType(SessionFactory.class);
        ConversationState newState = new ConversationState(new Identity(name, this.userState.getIdentity().getMemberships(), this.userState.getIdentity().getRoles()));
        return sessionFactory.createSession(newState);
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) throws IOException, PathNotFoundException, ItemExistsException, ConstraintViolationException, InvalidSerializedDataException, RepositoryException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("respectPropertyDefinitionsConstraints", true);
        this.importXML(parentAbsPath, in, uuidBehavior, context);
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior, boolean respectPropertyDefinitionsConstraints) throws IOException, PathNotFoundException, ItemExistsException, ConstraintViolationException, InvalidSerializedDataException, RepositoryException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("respectPropertyDefinitionsConstraints", respectPropertyDefinitionsConstraints);
        this.importXML(parentAbsPath, in, uuidBehavior, context);
    }

    @Override
    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior, Map<String, Object> context) throws IOException, PathNotFoundException, ItemExistsException, ConstraintViolationException, InvalidSerializedDataException, RepositoryException {
        this.checkLive();
        NodeImpl node = (NodeImpl)this.getItem(parentAbsPath);
        if (!node.checkedOut()) {
            throw new VersionException("Node " + node.getPath() + " or its nearest ancestor is checked-in");
        }
        if (node.getDefinition().isProtected()) {
            throw new ConstraintViolationException("Can't add protected node " + node.getName() + " to " + node.getParent().getPath());
        }
        if (!node.checkLocking()) {
            throw new LockException("Node " + node.getPath() + " is locked ");
        }
        StreamImporter importer = new ExportImportFactory().getStreamImporter((NodeData)node.getData(), uuidBehavior, new ItemDataKeeperAdapter(this.getTransientNodesManager()), this.getTransientNodesManager(), this.nodeTypeManager, this.getLocationFactory(), this.getValueFactory(), this.getWorkspace().getNamespaceRegistry(), this.getAccessManager(), this.userState, context, (RepositoryImpl)this.getRepository(), this.getWorkspace().getName());
        importer.importStream(in);
    }

    public boolean isLive() {
        return this.live;
    }

    public void checkLive() throws RepositoryException {
        if (!this.live && !ALLOW_CLOSED_SESSION_USAGE) {
            throw new RepositoryException("This kind of operation is forbidden after a session.logout().", (Throwable)this.closedByCallStack);
        }
    }

    public boolean itemExists(String absPath) {
        block3: {
            try {
                if (this.getItem(absPath) != null) {
                    return true;
                }
            }
            catch (RepositoryException e) {
                if (!LOG.isTraceEnabled()) break block3;
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
        }
        return false;
    }

    public void logout() {
        int length = this.lifecycleListeners.size();
        for (int i = 0; i < length; ++i) {
            this.lifecycleListeners.get(i).onCloseSession(this);
        }
        this.sessionRegistry.unregisterSession(this.getId());
        this.live = false;
        if (!ALLOW_CLOSED_SESSION_USAGE && PropertyManager.isDevelopping()) {
            this.closedByCallStack = new Exception("The session has been closed by the following call stack");
        }
    }

    public void expire() {
        this.expired = true;
        this.logout();
    }

    public void move(String srcAbsPath, String destAbsPath) throws ItemExistsException, PathNotFoundException, VersionException, LockException, RepositoryException {
        this.move(srcAbsPath, destAbsPath, this.triggerEventsForDescendantsOnRename, this.triggerEventsForDescendantsOnMove);
    }

    @Override
    public void move(String srcAbsPath, String destAbsPath, boolean triggerEventsForDescendants) throws ItemExistsException, PathNotFoundException, VersionException, LockException, RepositoryException {
        this.move(srcAbsPath, destAbsPath, triggerEventsForDescendants, triggerEventsForDescendants);
    }

    private void move(String srcAbsPath, String destAbsPath, Boolean triggerEventsForDescendantsOnRename, Boolean triggerEventsForDescendantsOnMove) throws ItemExistsException, PathNotFoundException, VersionException, LockException, RepositoryException {
        Boolean triggerEventsForDescendants;
        this.checkLive();
        JCRPath destNodePath = this.getLocationFactory().parseAbsPath(destAbsPath);
        if (destNodePath.isIndexSetExplicitly()) {
            throw new RepositoryException("The destination path provided must not have an index on its final element. " + destNodePath.getAsString(false));
        }
        JCRPath srcNodePath = this.getLocationFactory().parseAbsPath(srcAbsPath);
        NodeImpl srcNode = (NodeImpl)this.dataManager.getItem(srcNodePath.getInternalPath(), false);
        NodeImpl destParentNode = (NodeImpl)this.dataManager.getItem(destNodePath.makeParentPath().getInternalPath(), true);
        if (srcNode == null || destParentNode == null) {
            throw new PathNotFoundException("No node exists at " + srcAbsPath + " or no node exists one level above " + destAbsPath);
        }
        try {
            destParentNode.checkPermission("add_node");
            srcNode.checkPermission("remove");
        }
        catch (AccessControlException e) {
            throw new AccessDeniedException(e.getMessage());
        }
        destParentNode.validateChildNode(destNodePath.getName().getInternalName(), ((NodeTypeImpl)srcNode.getPrimaryNodeType()).getQName());
        NodeImpl destNode = (NodeImpl)this.dataManager.getItem((NodeData)destParentNode.getData(), new QPathEntry(destNodePath.getInternalPath().getName(), 0), false, ItemType.NODE);
        if (destNode != null && !destNode.getDefinition().allowsSameNameSiblings()) {
            throw new ItemExistsException("A node with this name (" + destAbsPath + ") already exists. ");
        }
        NodeImpl srcParentNode = null;
        if (destParentNode.getIdentifier().equals(srcNode.getParentIdentifier())) {
            srcParentNode = destParentNode;
            triggerEventsForDescendants = triggerEventsForDescendantsOnRename;
        } else {
            srcParentNode = srcNode.parent();
            triggerEventsForDescendants = triggerEventsForDescendantsOnMove;
        }
        if (!srcParentNode.checkedOut()) {
            throw new VersionException("Parent or source Node or its nearest ancestor is checked-in");
        }
        if (!srcNode.checkLocking()) {
            throw new LockException("Source parent node " + srcNode.getPath() + " is locked ");
        }
        ItemDataMoveVisitor initializer = new ItemDataMoveVisitor((NodeData)destParentNode.getData(), destNodePath.getName().getInternalName(), (NodeData)srcParentNode.getData(), this.nodeTypeManager, this.getTransientNodesManager(), true, triggerEventsForDescendants, this.maxDescendantNodesAllowed);
        this.getTransientNodesManager().move((NodeData)srcNode.getData(), initializer);
        this.getActionHandler().postMove(srcNode, (NodeImpl)this.dataManager.readItem(initializer.getItemMoveState().getData(), destParentNode.nodeData(), false, false));
    }

    public void refresh(boolean keepChanges) throws RepositoryException {
        this.getRootNode().refresh(keepChanges);
    }

    @Override
    public void registerLifecycleListener(SessionLifecycleListener listener) {
        this.lifecycleListeners.add(listener);
    }

    public void removeLockToken(String lt) {
        this.getLockManager().removeLockToken(lt);
    }

    public void save() throws AccessDeniedException, LockException, ConstraintViolationException, InvalidItemStateException, RepositoryException {
        this.getRootNode().save();
    }

    public void setNamespacePrefix(String prefix, String uri) throws NamespaceException, RepositoryException {
        this.checkLive();
        NamespaceRegistryImpl nrg = (NamespaceRegistryImpl)this.workspace.getNamespaceRegistry();
        if (!nrg.isUriRegistered(uri)) {
            throw new NamespaceException("The specified uri:" + uri + " is not among those registered in the NamespaceRegistry");
        }
        if (nrg.isPrefixMaped(prefix)) {
            throw new NamespaceException("A prefix '" + prefix + "' is currently already mapped to " + nrg.getURI(prefix) + " URI persistently in the repository NamespaceRegistry and cannot be remapped to a new URI using this method, since this would make any content stored using the old URI unreadable.");
        }
        if (this.namespaces.containsKey(prefix)) {
            throw new NamespaceException("A prefix '" + prefix + "' is currently already mapped to " + this.namespaces.get(prefix) + " URI transiently within this Session and cannot be remapped to a new URI using this method, since this would make any content stored using the old URI unreadable.");
        }
        nrg.validateNamespace(prefix, uri);
        this.namespaces.put(prefix, uri);
        this.prefixes.put(uri, prefix);
    }

    public void updateLastAccessTime() {
        this.lastAccessTime = System.currentTimeMillis();
    }

    LocationFactory getSystemLocationFactory() {
        return this.systemLocationFactory;
    }

    public ConversationState getUserState() {
        return this.userState;
    }

    int getLazyReadThreshold() {
        return this.lazyReadThreshold;
    }

    int getLazyNodeIteratorPageSize() {
        return this.lazyNodeIteatorPageSize;
    }

    public String toString() {
        return String.format("Session {\n id: %s;\n userId: %s;\n workspace: %s/%s ;\n alive: %b\n}", this.id, this.getUserID(), this.repository.getName(), this.workspaceName, this.live);
    }

    public boolean canEnrollChangeToGlobalTx(PlainChangesLog statesLog) {
        return this.txResourceManager.canEnrollChangeToGlobalTx(this, statesLog);
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout <= 0L ? 0L : timeout;
    }

    @Override
    public XAResource getXAResource() {
        return this.txResourceManager;
    }

    @Override
    public boolean hasExpired() {
        return this.expired;
    }

    static {
        if (!ALLOW_CLOSED_SESSION_USAGE) {
            LOG.info((Object)"The JCR will throw an exception anytime we will try to use a dead session.");
        }
        if (FORCE_USE_GET_NODES_LAZILY) {
            LOG.warn((Object)"EXPERIMENTAL! The JCR will use ExtendedNode.getNodesLazily() for each Node.getNodes() invocation. This is an experimental feauture and should be used with care.");
        }
        SEQUENCE = new AtomicLong();
    }
}

