/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.access;

import java.util.HashSet;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.CredentialsImpl;
import org.exoplatform.services.jcr.impl.core.access.BaseAuthenticator;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.jaas.BasicCallbackHandler;

public class JAASAuthenticator
extends BaseAuthenticator {
    public JAASAuthenticator(RepositoryEntry config, IdentityRegistry identityRegistry) {
        super(config, identityRegistry);
    }

    @Override
    public final ConversationState authenticate(Credentials credentials) throws javax.jcr.LoginException {
        String[] aNames;
        Identity identity;
        CredentialsImpl thisCredentials;
        if (credentials instanceof CredentialsImpl) {
            thisCredentials = (CredentialsImpl)credentials;
        } else if (credentials instanceof SimpleCredentials) {
            String name = ((SimpleCredentials)credentials).getUserID();
            char[] pswd = ((SimpleCredentials)credentials).getPassword();
            thisCredentials = new CredentialsImpl(name, pswd);
        } else {
            throw new javax.jcr.LoginException("Credentials for the authentication should be CredentialsImpl or SimpleCredentials type");
        }
        if (thisCredentials.getUserID().equals(IdentityConstants.SYSTEM)) {
            Identity sid = new Identity(IdentityConstants.SYSTEM, new HashSet());
            return new ConversationState(sid);
        }
        BasicCallbackHandler handler = new BasicCallbackHandler(thisCredentials.getUserID(), thisCredentials.getPassword());
        try {
            LoginContext loginContext = new LoginContext(this.config.getSecurityDomain(), (CallbackHandler)handler);
            loginContext.login();
        }
        catch (LoginException e) {
            throw new javax.jcr.LoginException("Login failed for " + thisCredentials.getUserID() + " " + e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Logged " + thisCredentials.getUserID()));
        }
        if ((identity = this.identityRegistry.getIdentity(thisCredentials.getUserID())) == null) {
            throw new javax.jcr.LoginException("Identity not found, check Loginmodule, userId " + thisCredentials.getUserID());
        }
        ConversationState state = new ConversationState(identity);
        for (String name : aNames = thisCredentials.getAttributeNames()) {
            state.setAttribute(name, thisCredentials.getAttribute(name));
        }
        ConversationState.setCurrent((ConversationState)state);
        return state;
    }
}

