/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.core.query.QueryNode;
import org.exoplatform.services.jcr.impl.core.query.QueryNodeVisitor;

public class OrderQueryNode
extends QueryNode {
    private final List<OrderSpec> specs = new ArrayList<OrderSpec>();

    protected OrderQueryNode(QueryNode parent) {
        super(parent);
    }

    @Override
    public int getType() {
        return 3;
    }

    public void addOrderSpec(InternalQName property, boolean ascending) {
        this.addOrderSpec(OrderQueryNode.createPath(property), ascending);
    }

    public void addOrderSpec(QPath property, boolean ascending) {
        this.specs.add(new OrderSpec(property, ascending));
    }

    public void addOrderSpec(OrderSpec spec) {
        this.specs.add(spec);
    }

    @Override
    public Object accept(QueryNodeVisitor visitor, Object data) throws RepositoryException {
        return visitor.visit(this, data);
    }

    public boolean isAscending(int i) throws IndexOutOfBoundsException {
        return this.specs.get(i).ascending;
    }

    public OrderSpec[] getOrderSpecs() {
        return this.specs.toArray(new OrderSpec[this.specs.size()]);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OrderQueryNode) {
            OrderQueryNode other = (OrderQueryNode)obj;
            return this.specs.equals(other.specs);
        }
        return false;
    }

    @Override
    public boolean needsSystemTree() {
        return false;
    }

    private static QPath createPath(InternalQName name) {
        return new QPath(new QPathEntry[]{new QPathEntry(name, 1)});
    }

    public static final class OrderSpec {
        private final QPath property;
        private boolean ascending;

        public OrderSpec(InternalQName property, boolean ascending) {
            this(OrderQueryNode.createPath(property), ascending);
        }

        public OrderSpec(QPath property, boolean ascending) {
            this.property = property;
            this.ascending = ascending;
        }

        public QPath getPropertyPath() {
            return this.property;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public void setAscending(boolean ascending) {
            this.ascending = ascending;
        }

        public boolean equals(Object obj) {
            if (obj instanceof OrderSpec) {
                OrderSpec other = (OrderSpec)obj;
                return (this.property == null ? other.property == null : this.property.equals(other.property)) && this.ascending == other.ascending;
            }
            return false;
        }
    }
}

