/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.lucene.document.Document;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.core.query.lucene.CachingMultiIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.ConsistencyCheckError;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldSelectors;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConsistencyCheck {
    private static final Logger log = LoggerFactory.getLogger((String)"exo.jcr.component.core.ConsistencyCheck");
    private final ItemDataConsumer stateMgr;
    private final MultiIndex index;
    private Set<String> documentUUIDs;
    private final List<ConsistencyCheckError> errors = new ArrayList<ConsistencyCheckError>();

    private ConsistencyCheck(MultiIndex index, ItemDataConsumer mgr) {
        this.index = index;
        this.stateMgr = mgr;
    }

    static ConsistencyCheck run(MultiIndex index, ItemDataConsumer mgr) throws IOException, RepositoryException {
        ConsistencyCheck check = new ConsistencyCheck(index, mgr);
        check.run();
        return check;
    }

    void repair(boolean ignoreFailure) throws IOException {
        if (this.errors.size() == 0) {
            log.info("No errors found.");
            return;
        }
        int notRepairable = 0;
        for (ConsistencyCheckError error : this.errors) {
            try {
                if (error.repairable()) {
                    error.repair();
                    continue;
                }
                log.warn("Not repairable: " + error);
                ++notRepairable;
            }
            catch (IOException e) {
                if (ignoreFailure) {
                    log.warn("Exception while reparing: " + e);
                    continue;
                }
                throw e;
            }
            catch (Exception e) {
                if (ignoreFailure) {
                    log.warn("Exception while reparing: " + e);
                    continue;
                }
                throw new IOException(e.getMessage(), e);
            }
        }
        log.info("Repaired " + (this.errors.size() - notRepairable) + " errors.");
        if (notRepairable > 0) {
            log.warn("" + notRepairable + " error(s) not repairable.");
        }
    }

    List<ConsistencyCheckError> getErrors() {
        return new ArrayList<ConsistencyCheckError>(this.errors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() throws IOException, RepositoryException {
        String uuid;
        Document d;
        HashSet<String> multipleEntries = new HashSet<String>();
        this.documentUUIDs = new HashSet<String>();
        CachingMultiIndexReader reader = this.index.getIndexReader();
        try {
            for (int i = 0; i < reader.maxDoc(); ++i) {
                if (i > 10 && i % (reader.maxDoc() / 5) == 0) {
                    long progress = Math.round(100.0 * (double)i / (double)((float)reader.maxDoc() * 2.0f));
                    log.info("progress: " + progress + "%");
                }
                if (reader.isDeleted(i)) continue;
                int currentIndex = i;
                d = reader.document(currentIndex, FieldSelectors.UUID);
                uuid = d.get(FieldNames.UUID);
                if (this.stateMgr.getItemData(uuid) != null) {
                    if (this.documentUUIDs.add(uuid)) continue;
                    multipleEntries.add(uuid);
                    continue;
                }
                this.errors.add(new NodeDeleted(uuid));
            }
        }
        finally {
            reader.release();
        }
        Iterator it = multipleEntries.iterator();
        while (it.hasNext()) {
            this.errors.add(new MultipleEntries((String)it.next()));
        }
        reader = this.index.getIndexReader();
        try {
            for (int i = 0; i < reader.maxDoc(); ++i) {
                if (i > 10 && i % (reader.maxDoc() / 5) == 0) {
                    long progress = Math.round(100.0 * (double)i / (double)((float)reader.maxDoc() * 2.0f));
                    log.info("progress: " + (progress + 50L) + "%");
                }
                if (reader.isDeleted(i)) continue;
                int currentIndex = i;
                d = reader.document(currentIndex, FieldSelectors.UUID_AND_PARENT);
                uuid = d.get(FieldNames.UUID);
                String parentUUIDString = d.get(FieldNames.PARENT);
                if (parentUUIDString == null || this.documentUUIDs.contains(parentUUIDString)) continue;
                if (this.stateMgr.getItemData(parentUUIDString) != null) {
                    this.errors.add(new MissingAncestor(uuid, parentUUIDString));
                    continue;
                }
                this.errors.add(new UnknownParent(uuid, parentUUIDString));
            }
        }
        finally {
            reader.release();
        }
    }

    private String getPath(NodeData node) {
        return node.getQPath().getAsString();
    }

    private class NodeDeleted
    extends ConsistencyCheckError {
        NodeDeleted(String uuid) {
            super("Node " + uuid + " does not longer exist.", uuid);
        }

        @Override
        public boolean repairable() {
            return true;
        }

        @Override
        public void repair() throws IOException {
            log.info("Removing deleted node from index: " + this.uuid);
            ConsistencyCheck.this.index.removeDocument(this.uuid);
        }
    }

    private class MultipleEntries
    extends ConsistencyCheckError {
        MultipleEntries(String uuid) {
            super("Multiple entries found for node " + uuid, uuid);
        }

        @Override
        public boolean repairable() {
            return true;
        }

        @Override
        public void repair() throws IOException {
            ConsistencyCheck.this.index.removeAllDocuments(this.uuid);
            try {
                NodeData node = (NodeData)ConsistencyCheck.this.stateMgr.getItemData(this.uuid);
                log.info("Re-indexing duplicate node occurrences in index: " + ConsistencyCheck.this.getPath(node));
                Document d = ConsistencyCheck.this.index.createDocument(node);
                ConsistencyCheck.this.index.addDocument(d);
                ConsistencyCheck.this.documentUUIDs.add(node.getIdentifier());
            }
            catch (RepositoryException e) {
                throw new IOException(e.toString(), e);
            }
        }
    }

    private class UnknownParent
    extends ConsistencyCheckError {
        private UnknownParent(String uuid, String parentUUID) {
            super("Node " + uuid + " has unknown parent: " + parentUUID, uuid);
        }

        @Override
        public boolean repairable() {
            return false;
        }

        @Override
        public void repair() throws IOException {
            log.warn("Unknown parent for " + this.uuid + " cannot be repaired");
        }
    }

    private class MissingAncestor
    extends ConsistencyCheckError {
        private final String parentUUID;

        private MissingAncestor(String uuid, String parentUUID) {
            super("Parent of " + uuid + " missing in index. Parent: " + parentUUID, uuid);
            this.parentUUID = parentUUID;
        }

        @Override
        public boolean repairable() {
            return true;
        }

        @Override
        public void repair() throws IOException {
            String parentId = this.parentUUID;
            while (parentId != null && !ConsistencyCheck.this.documentUUIDs.contains(parentId)) {
                try {
                    NodeData n = (NodeData)ConsistencyCheck.this.stateMgr.getItemData(parentId);
                    log.info("Reparing missing node " + ConsistencyCheck.this.getPath(n));
                    Document d = ConsistencyCheck.this.index.createDocument(n);
                    ConsistencyCheck.this.index.addDocument(d);
                    ConsistencyCheck.this.documentUUIDs.add(n.getIdentifier());
                    parentId = n.getParentIdentifier();
                }
                catch (RepositoryException e) {
                    throw new IOException(e.toString());
                }
            }
        }
    }
}

