/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.jcr.core.value.EditableBinaryValue;
import org.exoplatform.services.jcr.impl.dataflow.SpoolConfig;
import org.exoplatform.services.jcr.impl.dataflow.StreamNewValueData;
import org.exoplatform.services.jcr.impl.util.io.DirectoryHelper;
import org.exoplatform.services.jcr.impl.util.io.SpoolFile;

public class StreamNewEditableValueData
extends StreamNewValueData
implements EditableBinaryValue {
    public StreamNewEditableValueData(InputStream stream, int orderNumber, SpoolConfig spoolConfig) throws IOException {
        super(orderNumber, null, null, spoolConfig);
        SpoolFile sf = SpoolFile.createTempFile("jcrvdedit", null, spoolConfig.tempDirectory);
        FileOutputStream sfout = PrivilegedFileHelper.fileOutputStream((File)sf);
        try {
            DirectoryHelper.transfer(stream, sfout);
        }
        catch (IOException e) {
            block8: {
                try {
                    ((OutputStream)sfout).close();
                    PrivilegedFileHelper.delete((File)sf);
                }
                catch (Exception e1) {
                    if (!LOG.isTraceEnabled()) break block8;
                    LOG.trace((Object)("An exception occurred: " + e1.getMessage()));
                }
            }
            throw new IOException("init error " + e.getMessage(), e);
        }
        finally {
            ((OutputStream)sfout).close();
            stream.close();
        }
        this.spoolFile = sf;
        this.channel = PrivilegedFileHelper.randomAccessFile((File)sf, (String)"rw").getChannel();
    }

    @Override
    public void update(InputStream stream, long length, long position) throws IOException {
        this.validateAndAdjustLenght(length, position, Integer.MAX_VALUE);
        MappedByteBuffer bb = this.channel.map(FileChannel.MapMode.READ_WRITE, position, length);
        ReadableByteChannel ch = Channels.newChannel(stream);
        ch.read(bb);
        ch.close();
        bb.force();
    }

    @Override
    public void setLength(long size) throws IOException {
        if (size < 0L) {
            throw new IOException("Size must be higher or equals 0. But given " + size);
        }
        if (this.channel.size() < size) {
            MappedByteBuffer bb = this.channel.map(FileChannel.MapMode.READ_WRITE, size, 0L);
            bb.force();
        } else {
            this.channel.truncate(size);
        }
    }
}

