/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.webui.UIWikiPermissionForm;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.core.UIExtensionContainer;
import org.exoplatform.wiki.webui.extension.UISyntaxSettingForm;
import org.exoplatform.wiki.webui.extension.UITemplateSettingForm;

@ComponentConfig(template="app:/templates/wiki/webui/popup/UIWikiSettingContainer.gtmpl", events={@EventConfig(listeners={ActiveItemActionListener.class})})
public class UIWikiSettingContainer
extends UIExtensionContainer
implements UIPopupComponent {
    private static final Log log = ExoLogger.getExoLogger(UIWikiSettingContainer.class);
    private String activeItem;
    private List<String> items = new ArrayList<String>();
    public static final String EXTENSION_TYPE = "org.exoplatform.wiki.webui.popup.UIWikiSettingContainer";
    public static final String ACTION = "ActiveItem";

    /*
     * Unable to fully structure code
     */
    public void processRender(WebuiRequestContext context) throws Exception {
        wikiPortlet = (UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class);
        extContext = wikiPortlet.getUIExtContext();
        if (this.checkModificationContext(extContext)) {
            this.activeItem = null;
            manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
            extensions = manager.getUIExtensions("org.exoplatform.wiki.webui.popup.UIWikiSettingContainer");
            if (!this.items.isEmpty()) {
                this.items.clear();
            }
            ** if (extensions == null) goto lbl22
            for (i = 0; i < extensions.size(); ++i) {
                component = manager.addUIExtension((UIExtension)extensions.get(i), extContext, (UIContainer)this);
                try {
                    this.checkToUpdateData(component);
                }
                catch (Exception e) {
                    UIWikiSettingContainer.log.warn((Object)"Can not get permission data", (Throwable)e);
                }
                this.items.add(component.getId());
                if (this.activeItem != null) continue;
                this.setActiveItem(component.getId());
lbl-1000:
                // 2 sources

                {
                    continue;
                }
            }
        }
lbl22:
        // 4 sources

        this.getChildById(this.activeItem).setRendered(true);
        super.processRender(context);
    }

    private void checkToUpdateData(UIComponent component) throws Exception {
        if (component == null) {
            return;
        }
        if (component instanceof UIWikiPermissionForm) {
            UIWikiPermissionForm uiWikiPermissionForm = (UIWikiPermissionForm)component;
            uiWikiPermissionForm.setScope(UIWikiPermissionForm.Scope.WIKI);
            WikiService wikiService = (WikiService)uiWikiPermissionForm.getApplicationComponent(WikiService.class);
            WikiPageParams pageParams = Utils.getCurrentWikiPageParams();
            uiWikiPermissionForm.setPermission(wikiService.getWikiPermission(pageParams.getType(), pageParams.getOwner()));
        } else if (component instanceof UITemplateSettingForm) {
            UITemplateSettingForm uiTemplateSettingForm = (UITemplateSettingForm)component;
            uiTemplateSettingForm.initGrid();
        } else if (component instanceof UISyntaxSettingForm) {
            UISyntaxSettingForm uiSyntaxSettingForm = (UISyntaxSettingForm)component;
            uiSyntaxSettingForm.updateData();
        }
    }

    public String getActiveItem() {
        return this.activeItem;
    }

    public void setActiveItem(String activeItem) {
        if (StringUtils.isEmpty((String)this.activeItem) || !this.activeItem.equals(activeItem)) {
            this.activeItem = activeItem;
        }
    }

    public List<String> getItems() {
        return this.items;
    }

    public void setItems(List<String> items) {
        this.items = items;
    }

    public void activate() {
    }

    public void deActivate() {
    }

    public static class ActiveItemActionListener
    extends EventListener<UIWikiSettingContainer> {
        public void execute(Event<UIWikiSettingContainer> event) throws Exception {
            UIWikiSettingContainer container = (UIWikiSettingContainer)((Object)event.getSource());
            container.setActiveItem(event.getRequestContext().getRequestParameter("objectId"));
        }
    }
}

