/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import uk.ac.ed.ph.snuggletex.SnuggleRuntimeException;
import uk.ac.ed.ph.snuggletex.WebPageOutputOptions;
import uk.ac.ed.ph.snuggletex.internal.DOMBuildingController;
import uk.ac.ed.ph.snuggletex.internal.SessionContext;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.internal.util.ConstraintUtilities;
import uk.ac.ed.ph.snuggletex.internal.util.ObjectUtilities;
import uk.ac.ed.ph.snuggletex.internal.util.StringUtilities;
import uk.ac.ed.ph.snuggletex.internal.util.XMLUtilities;
import uk.ac.ed.ph.snuggletex.tokens.FlowToken;
import uk.ac.ed.ph.snuggletex.utilities.CSSUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebPageBuilder {
    private final SessionContext sessionContext;
    private final WebPageOutputOptions options;

    public WebPageBuilder(SessionContext sessionContext, WebPageOutputOptions options) {
        this.sessionContext = sessionContext;
        this.options = options;
    }

    public final Document createWebPage(List<FlowToken> fixedTokens) throws SnuggleParseException {
        String lang;
        String[] cssStylesheetURLs;
        this.checkOptions();
        Document document = XMLUtilities.createNSAwareDocumentBuilder().newDocument();
        String[] clientXSLTURLs = this.options.getClientSideXSLTStylesheetURLs();
        if (clientXSLTURLs != null) {
            for (String url : clientXSLTURLs) {
                document.appendChild(document.createProcessingInstruction("xml-stylesheet", "type=\"text/xsl\" href=\"" + url + "\""));
            }
        }
        Element body = document.createElementNS("http://www.w3.org/1999/xhtml", "body");
        String title = this.options.getTitle();
        if (title != null && this.options.isAddingTitleHeading()) {
            Element titleHeader = document.createElementNS("http://www.w3.org/1999/xhtml", "h1");
            titleHeader.appendChild(document.createTextNode(title));
            body.appendChild(titleHeader);
        }
        DOMBuildingController domBuildingController = new DOMBuildingController(this.sessionContext, this.options);
        domBuildingController.buildDOMSubtree(body, fixedTokens);
        Element head = document.createElementNS("http://www.w3.org/1999/xhtml", "head");
        WebPageOutputOptions.WebPageType pageType = this.options.getWebPageType();
        if (pageType == WebPageOutputOptions.WebPageType.MATHPLAYER_HTML) {
            Element object = document.createElementNS("http://www.w3.org/1999/xhtml", "object");
            object.setAttribute("id", "MathPlayer");
            object.setAttribute("classid", "clsid:32F66A20-7614-11D4-BD11-00104BD3F987");
            head.appendChild(object);
            head.appendChild(document.createProcessingInstruction("import", "namespace=\"" + this.options.getMathMLPrefix() + "\" implementation=\"#MathPlayer\" ?"));
        }
        Element meta = document.createElementNS("http://www.w3.org/1999/xhtml", "meta");
        meta.setAttribute("http-equiv", "Content-Type");
        meta.setAttribute("content", this.computeMetaContentType());
        head.appendChild(meta);
        meta = document.createElementNS("http://www.w3.org/1999/xhtml", "meta");
        meta.setAttribute("name", "Generator");
        meta.setAttribute("content", "SnuggleTeX");
        head.appendChild(meta);
        if (title != null) {
            Element titleElement = document.createElementNS("http://www.w3.org/1999/xhtml", "title");
            titleElement.appendChild(document.createTextNode(this.options.getTitle()));
            head.appendChild(titleElement);
        }
        if ((cssStylesheetURLs = this.options.getCSSStylesheetURLs()) != null) {
            for (String url : cssStylesheetURLs) {
                Element link = document.createElementNS("http://www.w3.org/1999/xhtml", "link");
                link.setAttribute("rel", "stylesheet");
                link.setAttribute("href", url);
                head.appendChild(link);
            }
        }
        if (this.options.isIncludingStyleElement()) {
            Element style = document.createElementNS("http://www.w3.org/1999/xhtml", "style");
            style.setAttribute("type", "text/css");
            Properties cssProperties = CSSUtilities.readInlineCSSProperties(this.options);
            style.appendChild(document.createTextNode(CSSUtilities.writeStylesheet(cssProperties)));
            head.appendChild(style);
        }
        Element html = document.createElementNS("http://www.w3.org/1999/xhtml", "html");
        if (pageType == WebPageOutputOptions.WebPageType.UNIVERSAL_STYLESHEET) {
            html.setAttributeNS("http://www.w3.org/2002/Math/preference", "pref:renderer", "mathplayer-dl");
        }
        if ((lang = this.options.getLang()) != null) {
            if (pageType == WebPageOutputOptions.WebPageType.MATHPLAYER_HTML || pageType == WebPageOutputOptions.WebPageType.PROCESSED_HTML) {
                html.setAttribute("lang", lang);
            } else {
                html.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", lang);
            }
        }
        if (this.options.isPrefixingMathML()) {
            html.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + this.options.getMathMLPrefix(), "http://www.w3.org/1998/Math/MathML");
        }
        html.appendChild(head);
        html.appendChild(body);
        document.appendChild(html);
        Object[] stylesheets = this.options.getStylesheets();
        if (!ObjectUtilities.isNullOrEmpty(stylesheets)) {
            for (Object stylesheet : stylesheets) {
                DOMSource input = new DOMSource(document);
                document = XMLUtilities.createNSAwareDocumentBuilder().newDocument();
                try {
                    ((Transformer)stylesheet).transform(input, new DOMResult(document));
                }
                catch (TransformerException e) {
                    throw new SnuggleRuntimeException("Could not apply stylesheet " + stylesheet);
                }
            }
        }
        return document;
    }

    public final void setWebPageContentType(Object contentTypeSettable) {
        this.checkOptions();
        try {
            Method setterMethod = contentTypeSettable.getClass().getMethod("setContentType", String.class);
            setterMethod.invoke(contentTypeSettable, this.computeContentTypeHeader());
        }
        catch (Exception e) {
            throw new SnuggleRuntimeException("Could not find and call setContentType() on Object " + contentTypeSettable, e);
        }
    }

    public final void writeWebPage(List<FlowToken> fixedTokens, Object contentTypeSettable, OutputStream outputStream) throws SnuggleParseException, IOException {
        if (contentTypeSettable != null) {
            this.setWebPageContentType(contentTypeSettable);
        }
        Document webPageDocument = this.createWebPage(fixedTokens);
        Transformer serializer = this.createSerializer();
        try {
            serializer.transform(new DOMSource(webPageDocument), new StreamResult(outputStream));
        }
        catch (TransformerException e) {
            throw new SnuggleRuntimeException("Could not serialize web page", e);
        }
        finally {
            outputStream.close();
        }
    }

    private final Transformer createSerializer() {
        Transformer serializer;
        TransformerFactory transformerFactory = XMLUtilities.createJAXPTransformerFactory();
        WebPageOutputOptions.SerializationMethod serializationMethod = this.options.getSerializationMethod();
        if (serializationMethod == null) {
            serializationMethod = WebPageOutputOptions.SerializationMethod.XML;
        }
        try {
            serializer = this.options.getSerializationMethod() == WebPageOutputOptions.SerializationMethod.HTML ? this.sessionContext.getStylesheetManager().getStylesheet("classpath:/uk/ac/ed/ph/snuggletex/xhtml-to-html.xsl").newTransformer() : transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new SnuggleRuntimeException("Could not create serializer", e);
        }
        boolean xslt20 = XMLUtilities.supportsXSLT20(serializer);
        WebPageOutputOptions.SerializationMethod effectiveMethod = serializationMethod;
        if (effectiveMethod == WebPageOutputOptions.SerializationMethod.XHTML && !xslt20) {
            effectiveMethod = WebPageOutputOptions.SerializationMethod.XML;
        }
        serializer.setOutputProperty("method", effectiveMethod.getName());
        WebPageOutputOptions.WebPageType pageType = this.options.getWebPageType();
        serializer.setOutputProperty("indent", StringUtilities.toYesNo(this.options.isIndenting()));
        serializer.setOutputProperty("encoding", this.options.getEncoding());
        serializer.setOutputProperty("media-type", this.options.getContentType());
        serializer.setOutputProperty("omit-xml-declaration", StringUtilities.toYesNo(pageType != WebPageOutputOptions.WebPageType.CROSS_BROWSER_XHTML && pageType != WebPageOutputOptions.WebPageType.UNIVERSAL_STYLESHEET));
        if (pageType == WebPageOutputOptions.WebPageType.CROSS_BROWSER_XHTML) {
            serializer.setOutputProperty("doctype-public", "-//W3C//DTD XHTML 1.1 plus MathML 2.0 plus SVG 1.1//EN");
            serializer.setOutputProperty("doctype-system", "http://www.w3.org/Math/DTD/mathml2/xhtml-math11-f.dtd");
        }
        if (xslt20 && serializationMethod != WebPageOutputOptions.SerializationMethod.XML) {
            serializer.setOutputProperty("include-content-type", "no");
        }
        return serializer;
    }

    private void checkOptions() {
        ConstraintUtilities.ensureNotNull((Object)this.options.getWebPageType(), "WebPageOutputOptions.webPageType");
        ConstraintUtilities.ensureNotNull((Object)this.options.getSerializationMethod(), "WebPageOutputOptions.serializationMethod");
        ConstraintUtilities.ensureNotNull(this.options.getEncoding(), "WebPageOutputOptions.encoding");
        ConstraintUtilities.ensureNotNull(this.options.getContentType(), "WebPageOutputOptions.contentType");
    }

    private String computeContentTypeHeader() {
        String result = this.options.getWebPageType() == WebPageOutputOptions.WebPageType.CROSS_BROWSER_XHTML ? this.options.getContentType() : this.options.getContentType() + "; charset=" + this.options.getEncoding();
        return result;
    }

    private String computeMetaContentType() {
        return this.options.getContentType() + "; charset=" + this.options.getEncoding();
    }
}

