/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.jira.displayer.field;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jdom2.Element;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.VerbatimBlock;
import org.xwiki.rendering.macro.jira.JIRAFieldDisplayer;

public abstract class AbstractDateJIRAFieldDisplayer
implements JIRAFieldDisplayer {
    private DateFormat jiraDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
    private DateFormat displayDateFormat = new SimpleDateFormat("dd-MMM-yyyy");

    @Override
    public List<Block> displayField(String fieldName, Element issue) {
        List<Block> result;
        String date = issue.getChildText(fieldName);
        if (date != null) {
            try {
                Date parsedDate = this.jiraDateFormat.parse(date);
                result = Arrays.asList(new VerbatimBlock(this.displayDateFormat.format(parsedDate), true));
            }
            catch (ParseException e) {
                result = Arrays.asList(new VerbatimBlock(date, true));
            }
        } else {
            result = Collections.emptyList();
        }
        return result;
    }
}

