/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.activity;

import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.social.webui.activity.BaseUIActivityBuilder;
import org.exoplatform.wcm.ext.component.activity.FileUIActivity;
import org.exoplatform.wcm.ext.component.activity.FileUIActivityBuilder;
import org.exoplatform.wcm.ext.component.activity.listener.Utils;

public class UISharedFileBuilder
extends BaseUIActivityBuilder {
    private static final Log LOG = ExoLogger.getLogger(FileUIActivityBuilder.class);

    protected void extendUIActivity(BaseUIActivity uiActivity, ExoSocialActivity activity) {
        block8: {
            FileUIActivity fileActivity = (FileUIActivity)uiActivity;
            String nodeUUID = "";
            String workspaceName = "";
            if (activity.getTemplateParams() != null) {
                fileActivity.setUIActivityData(activity.getTemplateParams());
                nodeUUID = (String)activity.getTemplateParams().get("nodeUUID");
                workspaceName = (String)activity.getTemplateParams().get("workspace");
            }
            if (activity.getTemplateParams() != null && StringUtils.isNotBlank((String)((String)activity.getTemplateParams().get("comment")))) {
                fileActivity.setMessage(activity.getTitle());
                fileActivity.setActivityTitle(activity.getTitle().replace("</br></br>", ""));
            } else {
                fileActivity.setMessage(null);
            }
            try {
                Node currentNode;
                ManageableRepository manageRepo = WCMCoreUtils.getRepository();
                if (StringUtils.isEmpty((String)workspaceName)) {
                    workspaceName = manageRepo.getConfiguration().getDefaultWorkspaceName();
                }
                SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
                TrashService trashService = (TrashService)WCMCoreUtils.getService(TrashService.class);
                if (trashService.isInTrash(currentNode = sessionProvider.getSession(workspaceName, manageRepo).getNodeByUUID(nodeUUID))) {
                    Utils.deleteFileActivity(currentNode);
                }
                fileActivity.setContentNode(currentNode, 0);
            }
            catch (ItemNotFoundException infe) {
                LOG.error((Object)"Item not found. Activity will be deleted ", (Throwable)infe);
                ActivityManager activityManager = (ActivityManager)WCMCoreUtils.getService(ActivityManager.class);
                activityManager.deleteActivity(activity);
            }
            catch (RepositoryException re) {
                if (!LOG.isErrorEnabled()) break block8;
                LOG.error((Object)"Can not get the repository. ", (Throwable)re);
            }
        }
    }
}

