/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid;

import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

@ThreadSafe
public final class MathMLSerializer {
    private static final Log LOGGER = LogFactory.getLog(MathMLSerializer.class);

    private MathMLSerializer() {
    }

    public static String serializeDocument(Node node, boolean bl, boolean bl2) {
        StringWriter stringWriter = new StringWriter();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource dOMSource = new DOMSource(node);
            StreamResult streamResult = new StreamResult(stringWriter);
            if (bl) {
                transformer.setOutputProperty("doctype-public", "-//W3C//DTD MathML 2.0//EN");
                transformer.setOutputProperty("doctype-system", "http://www.w3.org/TR/MathML2/dtd/mathml2.dtd");
                transformer.setOutputProperty("media-type", "application/mathml+xml");
            }
            if (bl2) {
                transformer.setOutputProperty("indent", "yes");
            } else {
                transformer.setOutputProperty("indent", "no");
            }
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            LOGGER.warn((Object)transformerException);
        }
        return stringWriter.toString();
    }
}

