/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.table;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.context.InlineLayoutContext;
import net.sourceforge.jeuclid.context.Parameter;
import net.sourceforge.jeuclid.elements.JEuclidElement;
import net.sourceforge.jeuclid.elements.presentation.table.AbstractTableElement;
import net.sourceforge.jeuclid.elements.support.Dimension2DImpl;
import net.sourceforge.jeuclid.elements.support.ElementListSupport;
import net.sourceforge.jeuclid.elements.support.GraphicsSupport;
import net.sourceforge.jeuclid.elements.support.attributes.AttributesHelper;
import net.sourceforge.jeuclid.elements.support.attributes.HAlign;
import net.sourceforge.jeuclid.layout.GraphicsObject;
import net.sourceforge.jeuclid.layout.LayoutInfo;
import net.sourceforge.jeuclid.layout.LayoutStage;
import net.sourceforge.jeuclid.layout.LayoutView;
import net.sourceforge.jeuclid.layout.LayoutableNode;
import net.sourceforge.jeuclid.layout.LineObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.w3c.dom.mathml.MathMLLabeledRowElement;
import org.w3c.dom.mathml.MathMLNodeList;
import org.w3c.dom.mathml.MathMLTableCellElement;
import org.w3c.dom.mathml.MathMLTableElement;
import org.w3c.dom.mathml.MathMLTableRowElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Mtable
extends AbstractTableElement
implements MathMLTableElement {
    public static final String ELEMENT = "mtable";
    static final String ATTR_COLUMNALIGN = "columnalign";
    static final String ATTR_ROWALIGN = "rowalign";
    static final String ATTR_GROUPALIGN = "groupalign";
    private static final String ATTR_ROWLINES = "rowlines";
    private static final String ATTR_COLUMNLINES = "columnlines";
    private static final String ATTR_ALIGN = "align";
    private static final String ATTR_ALIGNMENTSCOPE = "alignmentscope";
    private static final String ATTR_COLUMNWIDTH = "columnwidth";
    private static final String ATTR_WIDTH = "width";
    private static final String ATTR_ROWSPACING = "rowspacing";
    private static final String ATTR_COLUMNSPACING = "columnspacing";
    private static final String ATTR_FRAME = "frame";
    private static final String ATTR_FRAMESPACING = "framespacing";
    private static final String ATTR_EQUALROWS = "equalrows";
    private static final String ATTR_EQUALCOLUMNS = "equalcolumns";
    private static final String ATTR_DISPLAYSTYLE = "displaystyle";
    private static final String ATTR_SIDE = "side";
    private static final String ATTR_MINLABELSPACING = "minlabelspacing";
    private static final String VALUE_NONE = "none";
    private static final String VALUE_DASHED = "dashed";
    private static final String VALUE_SOLID = "solid";
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_COLUMNSPACING = "0.8em";
    private static final String DEFAULT_ROWSPACING = "1.0ex";
    private static final String DEFAULT_FRAMESPACING = "0.4em 0.5ex";
    private static final String VALUE_AUTO = "auto";
    private static final Log LOGGER = LogFactory.getLog(Mtable.class);

    public Mtable() {
        this.setDefaultMathAttribute(ATTR_ALIGN, "axis");
        this.setDefaultMathAttribute(ATTR_ROWALIGN, "baseline");
        this.setDefaultMathAttribute(ATTR_COLUMNALIGN, "center");
        this.setDefaultMathAttribute(ATTR_GROUPALIGN, "{left}");
        this.setDefaultMathAttribute(ATTR_ALIGNMENTSCOPE, "true");
        this.setDefaultMathAttribute(ATTR_COLUMNWIDTH, VALUE_AUTO);
        this.setDefaultMathAttribute(ATTR_WIDTH, VALUE_AUTO);
        this.setDefaultMathAttribute(ATTR_ROWSPACING, DEFAULT_ROWSPACING);
        this.setDefaultMathAttribute(ATTR_COLUMNSPACING, DEFAULT_COLUMNSPACING);
        this.setDefaultMathAttribute(ATTR_ROWLINES, VALUE_NONE);
        this.setDefaultMathAttribute(ATTR_COLUMNLINES, VALUE_NONE);
        this.setDefaultMathAttribute(ATTR_FRAME, VALUE_NONE);
        this.setDefaultMathAttribute(ATTR_FRAMESPACING, DEFAULT_FRAMESPACING);
        this.setDefaultMathAttribute(ATTR_EQUALROWS, "false");
        this.setDefaultMathAttribute(ATTR_EQUALCOLUMNS, "false");
        this.setDefaultMathAttribute(ATTR_DISPLAYSTYLE, "false");
        this.setDefaultMathAttribute(ATTR_SIDE, "right");
        this.setDefaultMathAttribute(ATTR_MINLABELSPACING, DEFAULT_COLUMNSPACING);
    }

    protected Node newNode() {
        return new Mtable();
    }

    @Override
    public LayoutContext getChildLayoutContext(int n, LayoutContext layoutContext) {
        return new InlineLayoutContext(this.applyLocalAttributesToContext(layoutContext));
    }

    private float getFramespacingh(LayoutContext layoutContext) {
        if (LineType.NONE.equals((Object)this.getFrameAsLineType())) {
            return 0.0f;
        }
        String string = this.getSpaceArrayEntry(this.getFramespacing(), 0);
        return AttributesHelper.convertSizeToPt(string, layoutContext, "pt");
    }

    private float getFramespacingv(LayoutContext layoutContext) {
        if (LineType.NONE.equals((Object)this.getFrameAsLineType())) {
            return 0.0f;
        }
        String string = this.getSpaceArrayEntry(this.getFramespacing(), 1);
        return AttributesHelper.convertSizeToPt(string, layoutContext, "pt");
    }

    @Override
    public String getRowlines() {
        return this.getMathAttribute(ATTR_ROWLINES);
    }

    @Override
    public void setRowlines(String string) {
        this.setAttribute(ATTR_ROWLINES, string);
    }

    @Override
    public String getColumnlines() {
        return this.getMathAttribute(ATTR_COLUMNLINES);
    }

    @Override
    public void setColumnlines(String string) {
        this.setAttribute(ATTR_COLUMNLINES, string);
    }

    private LineType getRowLine(int n) {
        return LineType.parseLineType(this.getSpaceArrayEntry(this.getRowlines(), n));
    }

    private LineType getColumnLine(int n) {
        return LineType.parseLineType(this.getSpaceArrayEntry(this.getColumnlines(), n));
    }

    private LineType getFrameAsLineType() {
        return LineType.parseLineType(this.getFrame());
    }

    private String getSpaceArrayEntry(String string, int n) {
        String[] stringArray = string == null ? new String[]{} : string.split("\\s");
        int n2 = -1;
        String string2 = "";
        for (String string3 : stringArray) {
            if (string3.length() <= 0) continue;
            if (++n2 == n) {
                return string3;
            }
            string2 = string3;
        }
        return string2;
    }

    @Override
    public String getColumnwidth() {
        return this.getMathAttribute(ATTR_COLUMNWIDTH);
    }

    @Override
    public void setColumnwidth(String string) {
        this.setAttribute(ATTR_COLUMNWIDTH, string);
    }

    @Override
    public String getWidth() {
        return this.getMathAttribute(ATTR_WIDTH);
    }

    @Override
    public void setWidth(String string) {
        this.setAttribute(ATTR_WIDTH, string);
    }

    @Override
    public String getAlign() {
        return this.getMathAttribute(ATTR_ALIGN);
    }

    @Override
    public void setAlign(String string) {
        this.setAttribute(ATTR_ALIGN, string);
    }

    @Override
    public String getAlignmentscope() {
        return this.getMathAttribute(ATTR_ALIGNMENTSCOPE);
    }

    @Override
    public void setAlignmentscope(String string) {
        this.setAttribute(ATTR_ALIGNMENTSCOPE, string);
    }

    @Override
    public String getRowspacing() {
        return this.getMathAttribute(ATTR_ROWSPACING);
    }

    @Override
    public void setRowspacing(String string) {
        this.setAttribute(ATTR_ROWSPACING, string);
    }

    @Override
    public String getColumnspacing() {
        return this.getMathAttribute(ATTR_COLUMNSPACING);
    }

    @Override
    public void setColumnspacing(String string) {
        this.setAttribute(ATTR_COLUMNSPACING, string);
    }

    @Override
    public String getFrame() {
        return this.getMathAttribute(ATTR_FRAME);
    }

    @Override
    public void setFrame(String string) {
        this.setAttribute(ATTR_FRAME, string);
    }

    @Override
    public String getFramespacing() {
        return this.getMathAttribute(ATTR_FRAMESPACING);
    }

    @Override
    public void setFramespacing(String string) {
        this.setAttribute(ATTR_FRAMESPACING, string);
    }

    @Override
    public String getEqualrows() {
        return this.getMathAttribute(ATTR_EQUALROWS);
    }

    @Override
    public void setEqualrows(String string) {
        this.setAttribute(ATTR_EQUALROWS, string);
    }

    @Override
    public String getEqualcolumns() {
        return this.getMathAttribute(ATTR_EQUALCOLUMNS);
    }

    @Override
    public void setEqualcolumns(String string) {
        this.setAttribute(ATTR_EQUALCOLUMNS, string);
    }

    @Override
    public String getDisplaystyle() {
        return this.getMathAttribute(ATTR_DISPLAYSTYLE);
    }

    @Override
    public void setDisplaystyle(String string) {
        this.setAttribute(ATTR_DISPLAYSTYLE, string);
    }

    @Override
    public String getSide() {
        return this.getMathAttribute(ATTR_SIDE);
    }

    @Override
    public void setSide(String string) {
        this.setAttribute(ATTR_SIDE, string);
    }

    @Override
    public String getMinlabelspacing() {
        return this.getMathAttribute(ATTR_MINLABELSPACING);
    }

    @Override
    public void setMinlabelspacing(String string) {
        this.setAttribute(ATTR_MINLABELSPACING, string);
    }

    @Override
    public MathMLNodeList getRows() {
        return null;
    }

    public MathMLTableRowElement insertEmptyRow(int n) {
        return null;
    }

    public MathMLLabeledRowElement insertEmptyLabeledRow(int n) {
        return null;
    }

    public MathMLTableRowElement getRow(int n) {
        return null;
    }

    public MathMLTableRowElement insertRow(int n, MathMLTableRowElement mathMLTableRowElement) {
        return null;
    }

    public MathMLTableRowElement setRow(int n, MathMLTableRowElement mathMLTableRowElement) {
        return null;
    }

    public void deleteRow(int n) {
    }

    public MathMLTableRowElement removeRow(int n) {
        return null;
    }

    @Override
    public void deleteRow(long l) {
    }

    @Override
    public MathMLTableRowElement getRow(long l) {
        return null;
    }

    @Override
    public MathMLLabeledRowElement insertEmptyLabeledRow(long l) {
        return null;
    }

    @Override
    public MathMLTableRowElement insertEmptyRow(long l) {
        return null;
    }

    @Override
    public MathMLTableRowElement insertRow(long l, MathMLTableRowElement mathMLTableRowElement) {
        return null;
    }

    @Override
    public MathMLTableRowElement removeRow(long l) {
        return null;
    }

    @Override
    public MathMLTableRowElement setRow(long l, MathMLTableRowElement mathMLTableRowElement) {
        return null;
    }

    @Override
    public void layoutStageInvariant(LayoutView layoutView, LayoutInfo layoutInfo, LayoutStage layoutStage, LayoutContext layoutContext) {
        Object object;
        float f;
        Graphics2D graphics2D = layoutView.getGraphics();
        LayoutContext layoutContext2 = this.applyLocalAttributesToContext(layoutContext);
        List<LayoutableNode> list = this.getChildrenToLayout();
        LayoutInfo[] layoutInfoArray = new LayoutInfo[list.size()];
        LayoutableNode[] layoutableNodeArray = new LayoutableNode[list.size()];
        float f2 = 0.0f;
        int n = 0;
        float f3 = f = this.getFramespacingv(layoutContext2);
        Iterator<LayoutableNode> iterator = list.iterator();
        while (iterator.hasNext()) {
            LayoutableNode listArray2;
            layoutableNodeArray[n] = listArray2 = iterator.next();
            object = layoutView.getInfo(listArray2);
            layoutInfoArray[n] = object;
            object.moveTo(0.0f, f2 += object.getAscentHeight(layoutStage), layoutStage);
            f3 = f2 += object.getDescentHeight(layoutStage);
            f2 += AttributesHelper.convertSizeToPt(this.getSpaceArrayEntry(this.getRowspacing(), ++n), layoutContext2, "pt");
        }
        float f4 = this.shiftTableVertically(layoutStage, layoutContext, graphics2D, layoutInfoArray, n, f3 += f);
        List<LayoutableNode>[] listArray = this.createListOfMtdChildren(layoutableNodeArray, n);
        this.stretchAndAlignMtds(layoutView, listArray, layoutInfoArray, n, layoutStage);
        object = this.calculateBasicColumnWidth(layoutView, layoutStage, n, listArray);
        float f5 = this.layoutColumnsHorizontally(layoutView, layoutStage, layoutContext2, n, listArray, (List<Float>)object);
        this.setRowWidth(layoutStage, layoutInfoArray, n, f5);
        this.addRowLines(layoutInfo, layoutInfoArray, n, f5, layoutStage, layoutContext2);
        this.addColumnLines(layoutInfo, (List<Float>)object, f4, f3, layoutContext2);
        this.addFrame(layoutInfo, f5, f4, f3, layoutContext2);
        float f6 = this.getFramespacingh(layoutContext2);
        Dimension2DImpl dimension2DImpl = new Dimension2DImpl(f6, f);
        Dimension2DImpl dimension2DImpl2 = new Dimension2DImpl(f6, f);
        ElementListSupport.fillInfoFromChildren(layoutView, layoutInfo, this, layoutStage, dimension2DImpl, dimension2DImpl2);
    }

    private void addFrame(LayoutInfo layoutInfo, float f, float f2, float f3, LayoutContext layoutContext) {
        LineType lineType = this.getFrameAsLineType();
        boolean bl = LineType.SOLID.equals((Object)lineType);
        boolean bl2 = LineType.DASHED.equals((Object)lineType);
        if (bl2 || bl) {
            float f4 = GraphicsSupport.lineWidth(layoutContext);
            float f5 = f4 / 2.0f;
            Color color = (Color)layoutContext.getParameter(Parameter.MATHCOLOR);
            List<GraphicsObject> list = layoutInfo.getGraphicObjects();
            float f6 = this.getFramespacingv(layoutContext);
            float f7 = f5;
            float f8 = f - f5;
            float f9 = f2 + f5 - f6;
            float f10 = f3 + f2 - f5;
            list.add(new LineObject(f7, f9, f8, f9, f4, color, bl2));
            list.add(new LineObject(f7, f10, f8, f10, f4, color, bl2));
            list.add(new LineObject(f7, f9, f7, f10, f4, color, bl2));
            list.add(new LineObject(f8, f9, f8, f10, f4, color, bl2));
        }
    }

    private void addRowLines(LayoutInfo layoutInfo, LayoutInfo[] layoutInfoArray, int n, float f, LayoutStage layoutStage, LayoutContext layoutContext) {
        float f2 = GraphicsSupport.lineWidth(layoutContext);
        Color color = (Color)layoutContext.getParameter(Parameter.MATHCOLOR);
        float f3 = this.getFramespacingh(layoutContext);
        for (int i = 0; i < n - 1; ++i) {
            LineType lineType = this.getRowLine(i);
            boolean bl = LineType.SOLID.equals((Object)lineType);
            boolean bl2 = LineType.DASHED.equals((Object)lineType);
            if (!bl2 && !bl) continue;
            float f4 = (layoutInfoArray[i].getPosY(layoutStage) + layoutInfoArray[i].getDescentHeight(layoutStage) + layoutInfoArray[i + 1].getPosY(layoutStage) - layoutInfoArray[i + 1].getAscentHeight(layoutStage)) / 2.0f;
            layoutInfo.getGraphicObjects().add(new LineObject(f3, f4, f - f3, f4, f2, color, bl2));
        }
    }

    private void addColumnLines(LayoutInfo layoutInfo, List<Float> list, float f, float f2, LayoutContext layoutContext) {
        float f3 = GraphicsSupport.lineWidth(layoutContext);
        Color color = (Color)layoutContext.getParameter(Parameter.MATHCOLOR);
        float f4 = this.getFramespacingh(layoutContext);
        float f5 = this.getFramespacingv(layoutContext);
        float f6 = list.size() - 1;
        int n = 0;
        while ((float)n < f6) {
            LineType lineType = this.getColumnLine(n);
            boolean bl = LineType.SOLID.equals((Object)lineType);
            boolean bl2 = LineType.DASHED.equals((Object)lineType);
            if (bl2 || bl) {
                float f7 = this.getSpaceAfterColumn(layoutContext, n) / 2.0f;
                layoutInfo.getGraphicObjects().add(new LineObject(f4 += list.get(n).floatValue() + f7, f, f4, f2 + f - f5, f3, color, bl2));
                f4 += f7;
            }
            ++n;
        }
    }

    private void stretchAndAlignMtds(LayoutView layoutView, List<LayoutableNode>[] listArray, LayoutInfo[] layoutInfoArray, int n, LayoutStage layoutStage) {
        for (int i = 0; i < n; ++i) {
            float f = layoutInfoArray[i].getAscentHeight(layoutStage);
            float f2 = layoutInfoArray[i].getDescentHeight(layoutStage);
            for (LayoutableNode layoutableNode : listArray[i]) {
                LayoutInfo layoutInfo = layoutView.getInfo(layoutableNode);
                VAlign vAlign = this.getVAlign((JEuclidElement)layoutableNode, i);
                float f3 = vAlign.getAlign() == 0 ? -f + layoutInfo.getAscentHeight(layoutStage) : (vAlign.getAlign() == 1 ? f2 - layoutInfo.getDescentHeight(layoutStage) : (vAlign.getAlign() == 2 ? (-f + f2 + layoutInfo.getAscentHeight(layoutStage) - layoutInfo.getDescentHeight(layoutStage)) / 2.0f : (vAlign.getAlign() == 4 ? (-f + f2 + layoutInfo.getAscentHeight(layoutStage) - layoutInfo.getDescentHeight(layoutStage)) / 2.0f : 0.0f)));
                layoutInfo.shiftVertically(f3, layoutStage);
                layoutInfo.setStretchAscent(f + f3);
                layoutInfo.setStretchDescent(f2 - f3);
            }
        }
    }

    private float shiftTableVertically(LayoutStage layoutStage, LayoutContext layoutContext, Graphics2D graphics2D, LayoutInfo[] layoutInfoArray, int n, float f) {
        float f2 = -this.getMiddleShift(graphics2D, layoutContext) - f / 2.0f;
        for (int i = 0; i < n; ++i) {
            layoutInfoArray[i].shiftVertically(f2, layoutStage);
        }
        return f2;
    }

    private List<LayoutableNode>[] createListOfMtdChildren(LayoutableNode[] layoutableNodeArray, int n) {
        List[] listArray = new List[n];
        for (int i = 0; i < n; ++i) {
            if (layoutableNodeArray[i] instanceof MathMLTableRowElement) {
                listArray[i] = layoutableNodeArray[i].getChildrenToLayout();
                continue;
            }
            listArray[i] = new ArrayList(1);
            listArray[i].add(layoutableNodeArray[i]);
        }
        return listArray;
    }

    private List<Float> calculateBasicColumnWidth(LayoutView layoutView, LayoutStage layoutStage, int n, List<LayoutableNode>[] listArray) {
        ArrayList<Float> arrayList = new ArrayList<Float>();
        for (int i = 0; i < n; ++i) {
            for (int j = listArray[i].size() - arrayList.size(); j > 0; --j) {
                arrayList.add(Float.valueOf(0.0f));
            }
            int n2 = 0;
            for (LayoutableNode layoutableNode : listArray[i]) {
                float f = Math.max(((Float)arrayList.get(n2)).floatValue(), layoutView.getInfo(layoutableNode).getWidth(layoutStage));
                arrayList.set(n2, Float.valueOf(f));
                ++n2;
            }
        }
        if (Boolean.parseBoolean(this.getEqualcolumns())) {
            this.makeEqual(arrayList);
        }
        return arrayList;
    }

    private void makeEqual(List<Float> list) {
        float f = 0.0f;
        for (Float f2 : list) {
            f = Math.max(f2.floatValue(), f);
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            list.set(i, Float.valueOf(f));
        }
    }

    private void setRowWidth(LayoutStage layoutStage, LayoutInfo[] layoutInfoArray, int n, float f) {
        for (int i = 0; i < n; ++i) {
            layoutInfoArray[i].setWidth(f, layoutStage);
        }
    }

    private float layoutColumnsHorizontally(LayoutView layoutView, LayoutStage layoutStage, LayoutContext layoutContext, int n, List<LayoutableNode>[] listArray, List<Float> list) {
        float f;
        float f2 = f = this.getFramespacingh(layoutContext);
        for (int i = 0; i < n; ++i) {
            float f3 = f;
            int n2 = 0;
            for (LayoutableNode layoutableNode : listArray[i]) {
                LayoutInfo layoutInfo = layoutView.getInfo(layoutableNode);
                HAlign hAlign = this.getHAlign((JEuclidElement)layoutableNode, n2);
                float f4 = list.get(n2).floatValue();
                float f5 = hAlign.getHAlignOffset(layoutStage, layoutInfo, f4);
                layoutInfo.moveTo(f3 + f5, layoutInfo.getPosY(layoutStage), layoutStage);
                layoutInfo.setStretchWidth(f4);
                f2 = Math.max(f2, f3 += f4);
                f3 += this.getSpaceAfterColumn(layoutContext, n2);
                ++n2;
            }
        }
        return f2 + f;
    }

    private float getSpaceAfterColumn(LayoutContext layoutContext, int n) {
        float f = AttributesHelper.convertSizeToPt(this.getSpaceArrayEntry(this.getColumnspacing(), n), layoutContext, "pt");
        return f;
    }

    private HAlign getHAlign(JEuclidElement jEuclidElement, int n) {
        MathMLTableElement mathMLTableElement;
        String string;
        MathMLTableRowElement mathMLTableRowElement;
        String string2;
        MathMLTableCellElement mathMLTableCellElement;
        String string3;
        HAlign hAlign;
        assert (jEuclidElement != null);
        HAlign hAlign2 = jEuclidElement instanceof MathMLTableCellElement ? ((hAlign = HAlign.parseString(string3 = (mathMLTableCellElement = (MathMLTableCellElement)((Object)jEuclidElement)).getColumnalign(), null)) == null ? this.getHAlign(jEuclidElement.getParent(), n) : hAlign) : (jEuclidElement instanceof MathMLTableRowElement ? ((string2 = (mathMLTableRowElement = (MathMLTableRowElement)((Object)jEuclidElement)).getColumnalign()) != null && string2.length() > 0 ? HAlign.parseString(this.getSpaceArrayEntry(string2, n), HAlign.CENTER) : this.getHAlign(jEuclidElement.getParent(), n)) : (jEuclidElement instanceof MathMLTableElement ? ((string = (mathMLTableElement = (MathMLTableElement)((Object)jEuclidElement)).getColumnalign()) != null && string.length() > 0 ? HAlign.parseString(this.getSpaceArrayEntry(string, n), HAlign.CENTER) : HAlign.CENTER) : this.getHAlign(jEuclidElement.getParent(), n)));
        return hAlign2;
    }

    private VAlign getVAlign(JEuclidElement jEuclidElement, int n) {
        MathMLTableElement mathMLTableElement;
        String string;
        MathMLTableRowElement mathMLTableRowElement;
        String string2;
        VAlign vAlign;
        MathMLTableCellElement mathMLTableCellElement;
        String string3;
        VAlign vAlign2;
        assert (jEuclidElement != null);
        VAlign vAlign3 = jEuclidElement instanceof MathMLTableCellElement ? ((vAlign2 = VAlign.parseString(string3 = (mathMLTableCellElement = (MathMLTableCellElement)((Object)jEuclidElement)).getRowalign())) == null ? this.getVAlign(jEuclidElement.getParent(), n) : vAlign2) : (jEuclidElement instanceof MathMLTableRowElement ? ((vAlign = VAlign.parseString(string2 = (mathMLTableRowElement = (MathMLTableRowElement)((Object)jEuclidElement)).getRowalign())) == null ? this.getVAlign(jEuclidElement.getParent(), n) : vAlign) : (jEuclidElement instanceof MathMLTableElement ? ((string = (mathMLTableElement = (MathMLTableElement)((Object)jEuclidElement)).getRowalign()) != null && string.length() > 0 ? VAlign.parseString(this.getSpaceArrayEntry(string, n)) : VAlign.BASELINE_ALIGN) : this.getVAlign(jEuclidElement.getParent(), n)));
        return vAlign3;
    }

    private static final class VAlign {
        static final int TOP = 0;
        static final int BOTTOM = 1;
        static final int CENTER = 2;
        static final int BASELINE = 3;
        static final int AXIS = 4;
        static final String VALUE_TOP = "top";
        static final String VALUE_BOTTOM = "bottom";
        static final String VALUE_CENTER = "center";
        static final String VALUE_BASELINE = "baseline";
        static final String VALUE_AXIS = "axis";
        static final VAlign BASELINE_ALIGN = new VAlign(3, 0);
        private static final String INVALID_VERTICAL_ALIGNMENT_VALUE = "Invalid vertical alignment value: ";
        private final int valign;
        private final int alignTo;

        private VAlign(int n, int n2) {
            this.valign = n;
            this.alignTo = n2;
        }

        public static VAlign parseString(String string) {
            String string2;
            int n;
            if (string == null || string.length() == 0) {
                return null;
            }
            int n2 = 0;
            String string3 = string.trim().toLowerCase(Locale.ENGLISH);
            if (string3.startsWith(VALUE_TOP)) {
                n = 0;
                string2 = string3.substring(VALUE_TOP.length()).trim();
            } else if (string3.startsWith(VALUE_BOTTOM)) {
                n = 1;
                string2 = string3.substring(VALUE_BOTTOM.length()).trim();
            } else if (string3.startsWith(VALUE_CENTER)) {
                n = 2;
                string2 = string3.substring(VALUE_CENTER.length()).trim();
            } else if (string3.startsWith(VALUE_BASELINE)) {
                n = 3;
                string2 = string3.substring(VALUE_BASELINE.length()).trim();
            } else if (string3.startsWith(VALUE_AXIS)) {
                n = 4;
                string2 = string3.substring(VALUE_AXIS.length()).trim();
            } else {
                LOGGER.warn((Object)(INVALID_VERTICAL_ALIGNMENT_VALUE + string));
                n = 3;
                string2 = "0";
            }
            if (string2.length() > 0) {
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.warn((Object)(INVALID_VERTICAL_ALIGNMENT_VALUE + string));
                }
            }
            return new VAlign(n, n2);
        }

        public int getAlign() {
            return this.valign;
        }

        public int getRelative() {
            return this.alignTo;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LineType {
        NONE,
        SOLID,
        DASHED;


        public static LineType parseLineType(String string) {
            LineType lineType = string.equalsIgnoreCase(Mtable.VALUE_SOLID) ? SOLID : (string.equalsIgnoreCase(Mtable.VALUE_DASHED) ? DASHED : NONE);
            return lineType;
        }
    }
}

