/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.token;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.text.AttributedString;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.context.Parameter;
import net.sourceforge.jeuclid.elements.AbstractJEuclidElement;
import net.sourceforge.jeuclid.elements.support.text.StringUtil;
import net.sourceforge.jeuclid.layout.LayoutInfo;
import net.sourceforge.jeuclid.layout.LayoutStage;
import net.sourceforge.jeuclid.layout.LayoutView;
import net.sourceforge.jeuclid.layout.TextObject;
import org.w3c.dom.mathml.MathMLPresentationToken;

public abstract class AbstractTokenWithTextLayout
extends AbstractJEuclidElement
implements MathMLPresentationToken {
    public void layoutStageInvariant(LayoutView layoutView, LayoutInfo layoutInfo, LayoutStage layoutStage, LayoutContext layoutContext) {
        if (!this.isEmpty()) {
            Graphics2D graphics2D = layoutView.getGraphics();
            TextLayout textLayout = this.produceTextLayout(graphics2D, layoutContext);
            StringUtil.TextLayoutInfo textLayoutInfo = StringUtil.getTextLayoutInfo(textLayout, false);
            layoutInfo.setAscentHeight(textLayoutInfo.getAscent(), layoutStage);
            layoutInfo.setDescentHeight(textLayoutInfo.getDescent(), layoutStage);
            float f = textLayoutInfo.getWidth();
            layoutInfo.setHorizontalCenterOffset(f / 2.0f, layoutStage);
            layoutInfo.setWidth(f, layoutStage);
            layoutInfo.setGraphicsObject(new TextObject(textLayout, textLayoutInfo.getOffset(), (Color)this.applyLocalAttributesToContext(layoutContext).getParameter(Parameter.MATHCOLOR)));
        }
    }

    protected abstract AttributedString textContentAsAttributedString(LayoutContext var1);

    protected abstract boolean isEmpty();

    private TextLayout produceTextLayout(Graphics2D graphics2D, LayoutContext layoutContext) {
        LayoutContext layoutContext2 = this.applyLocalAttributesToContext(layoutContext);
        TextLayout textLayout = StringUtil.createTextLayoutFromAttributedString(graphics2D, this.textContentAsAttributedString(layoutContext2), layoutContext2);
        return textLayout;
    }
}

