/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.jeuclid.MathMLParserSupport;
import net.sourceforge.jeuclid.MathMLSerializer;
import net.sourceforge.jeuclid.MutableLayoutContext;
import net.sourceforge.jeuclid.context.LayoutContextImpl;
import net.sourceforge.jeuclid.context.Parameter;
import net.sourceforge.jeuclid.elements.presentation.general.Mrow;
import net.sourceforge.jeuclid.elements.support.ClassLoaderSupport;
import net.sourceforge.jeuclid.swing.MathComponentUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JMathComponent
extends JComponent
implements SwingConstants {
    private static final String FONT_SEPARATOR = ",";
    private static final Log LOGGER;
    private static final long serialVersionUID = 1L;
    private static String uiClassId;
    private static Class<?> mathComponentUIClass;
    private Node document;
    private int horizontalAlignment = 0;
    private final MutableLayoutContext parameters = new LayoutContextImpl(LayoutContextImpl.getDefaultLayoutContext());
    private int verticalAlignment = 0;

    public JMathComponent() {
        this.updateUI();
        this.fontCompat();
        this.setDocument(new Mrow());
    }

    private void fontCompat() {
        String string = this.getFontsSerif().split(FONT_SEPARATOR)[0];
        float f = this.getFontSize();
        super.setFont(new Font(string, 0, (int)f));
    }

    public String getContent() {
        return MathMLSerializer.serializeDocument(this.getDocument(), false, false);
    }

    public Node getDocument() {
        return this.document;
    }

    private static String join(List<String> list) {
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(FONT_SEPARATOR);
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public String getFontsDoublestruck() {
        return JMathComponent.join((List)this.parameters.getParameter(Parameter.FONTS_DOUBLESTRUCK));
    }

    public String getFontsFraktur() {
        return JMathComponent.join((List)this.parameters.getParameter(Parameter.FONTS_FRAKTUR));
    }

    public float getFontSize() {
        return ((Float)this.parameters.getParameter(Parameter.MATHSIZE)).floatValue();
    }

    public String getFontsMonospaced() {
        return JMathComponent.join((List)this.parameters.getParameter(Parameter.FONTS_MONOSPACED));
    }

    public String getFontsSanserif() {
        return JMathComponent.join((List)this.parameters.getParameter(Parameter.FONTS_SANSSERIF));
    }

    public String getFontsScript() {
        return JMathComponent.join((List)this.parameters.getParameter(Parameter.FONTS_SCRIPT));
    }

    public String getFontsSerif() {
        return JMathComponent.join((List)this.parameters.getParameter(Parameter.FONTS_SERIF));
    }

    @Override
    public Color getForeground() {
        return (Color)this.parameters.getParameter(Parameter.MATHCOLOR);
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public MathComponentUI getUI() {
        return (MathComponentUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return uiClassId;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    private void reval() {
        this.repaint();
        this.revalidate();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.reval();
    }

    public void setContent(String string) {
        try {
            this.setDocument(MathMLParserSupport.parseString(string));
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void setDebug(boolean bl) {
        this.setParameter(Parameter.DEBUG, bl);
    }

    public void setDocument(Node node) {
        Node node2 = this.document;
        this.firePropertyChange("document", node2, node);
        this.document = node;
        if (node != node2) {
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    @Deprecated
    public void setFont(Font font) {
        super.setFont(font);
        this.setFontSize(font.getSize2D());
        this.setFontsSerif(font.getFamily() + FONT_SEPARATOR + this.getFontsSerif());
    }

    private List<String> splitFonts(String string) {
        return Arrays.asList(string.split(FONT_SEPARATOR));
    }

    public void setFontsDoublestruck(String string) {
        this.setParameter(Parameter.FONTS_DOUBLESTRUCK, this.splitFonts(string));
    }

    public void setFontsFraktur(String string) {
        this.setParameter(Parameter.FONTS_FRAKTUR, this.splitFonts(string));
    }

    public void setParameter(Parameter parameter, Object object) {
        this.setParameters(Collections.singletonMap(parameter, object));
    }

    public void setParameters(Map<Parameter, Object> map) {
        for (Map.Entry<Parameter, Object> entry : map.entrySet()) {
            Parameter parameter = entry.getKey();
            Object object = this.parameters.getParameter(parameter);
            this.parameters.setParameter(parameter, entry.getValue());
            this.firePropertyChange(parameter.name(), object, this.parameters.getParameter(parameter));
        }
        this.revalidate();
        this.repaint();
    }

    public void setFontSize(float f) {
        this.setParameter(Parameter.MATHSIZE, Float.valueOf(f));
    }

    public void setFontsMonospaced(String string) {
        this.setParameter(Parameter.FONTS_MONOSPACED, this.splitFonts(string));
    }

    public void setFontsSanserif(String string) {
        this.setParameter(Parameter.FONTS_SANSSERIF, this.splitFonts(string));
    }

    public void setFontsScript(String string) {
        this.setParameter(Parameter.FONTS_SCRIPT, this.splitFonts(string));
    }

    public void setFontsSerif(String string) {
        this.setParameter(Parameter.FONTS_SERIF, this.splitFonts(string));
        this.fontCompat();
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.setParameter(Parameter.MATHCOLOR, color);
    }

    public void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
    }

    @Override
    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
        this.reval();
    }

    public void setVerticalAlignment(int n) {
        this.verticalAlignment = n;
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) == null) {
            try {
                this.setUI((MathComponentUI)mathComponentUIClass.newInstance());
            }
            catch (InstantiationException instantiationException) {
                LOGGER.warn((Object)instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.warn((Object)illegalAccessException.getMessage());
            }
        } else {
            this.setUI(UIManager.getUI(this));
        }
    }

    public MutableLayoutContext getParameters() {
        return this.parameters;
    }

    @Override
    public void setSize(int n, int n2) {
        super.setSize(n, n2);
    }

    static {
        String string;
        Class<Object> clazz;
        LOGGER = LogFactory.getLog(JMathComponent.class);
        try {
            clazz = ClassLoaderSupport.getInstance().loadClass("net.sourceforge.jeuclid.swing.MathComponentUI16");
            string = "MathComponentUI16";
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = MathComponentUI.class;
            string = "MathComponentUI";
        }
        uiClassId = string;
        mathComponentUIClass = clazz;
    }
}

