/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.action;

import com.ibm.icu.text.Transliterator;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.webui.component.admin.action.UIActionManager;
import org.exoplatform.ecm.webui.form.validator.NodeTypeNameValidator;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.scripts.impl.ScriptServiceImpl;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ChangeTypeActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={AddActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={RemoveActionListener.class})})
public class UIActionTypeForm
extends UIForm {
    public static final String FIELD_SCRIPT = "script";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_VARIABLES = "variables";
    public static final String ACTION_TYPE = "exo:scriptAction";
    private String actionName_;
    private boolean isUpdate = false;
    public UIFormMultiValueInputSet uiFormMultiValue = null;

    public UIActionTypeForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(NodeTypeNameValidator.class, new Object[0]));
        UIFormSelectBox actionExecutables = new UIFormSelectBox(FIELD_SCRIPT, FIELD_SCRIPT, new ArrayList());
        this.addUIFormInput((UIFormInput)actionExecutables);
        this.setActions(new String[]{"Save", "Cancel"});
    }

    private void initMultiValuesField() throws Exception {
        if (this.uiFormMultiValue != null) {
            this.removeChildById(FIELD_VARIABLES);
        }
        this.uiFormMultiValue = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, null, null);
        this.uiFormMultiValue.setId(FIELD_VARIABLES);
        this.uiFormMultiValue.setName(FIELD_VARIABLES);
        this.uiFormMultiValue.setType(UIFormStringInput.class);
        ArrayList<String> list = new ArrayList<String>();
        list.add("");
        this.uiFormMultiValue.setValue(list);
        this.addUIFormInput((UIFormInput)this.uiFormMultiValue);
    }

    private List<SelectItemOption<String>> getScriptOptions() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        ScriptServiceImpl scriptService = (ScriptServiceImpl)WCMCoreUtils.getService(ScriptServiceImpl.class);
        List scriptOptions = scriptService.getECMActionScripts(WCMCoreUtils.getUserSessionProvider());
        String baseScriptPath = scriptService.getBaseScriptPath();
        for (Node script : scriptOptions) {
            SelectItemOption itemOption = new SelectItemOption(script.getName(), (Object)StringUtils.substringAfter((String)script.getPath(), (String)(baseScriptPath + "/")));
            options.add((SelectItemOption<String>)itemOption);
        }
        return options;
    }

    public void refresh() throws Exception {
        this.reset();
        this.getUIStringInput(FIELD_NAME).setValue((Object)"");
        List<SelectItemOption<String>> scriptOptions = this.getScriptOptions();
        this.getUIFormSelectBox(FIELD_SCRIPT).setOptions(scriptOptions);
        this.initMultiValuesField();
    }

    public void update(String actionName, String actionLabel) throws Exception {
        PropertyDefinition[] proDefs;
        this.isUpdate = true;
        ScriptServiceImpl scriptService = (ScriptServiceImpl)WCMCoreUtils.getService(ScriptServiceImpl.class);
        ExtendedNodeTypeManager ntManager = WCMCoreUtils.getRepository().getNodeTypeManager();
        NodeType nodeType = ntManager.getNodeType(actionName);
        this.actionName_ = actionName;
        String resourceName = scriptService.getResourceNameByNodeType(nodeType);
        this.getUIStringInput(FIELD_NAME).setValue((Object)actionLabel);
        this.getUIFormSelectBox(FIELD_SCRIPT).setOptions(this.getScriptOptions()).setValue(resourceName);
        ArrayList<String> valueList = new ArrayList<String>();
        for (PropertyDefinition pro : proDefs = nodeType.getPropertyDefinitions()) {
            if (pro.isProtected() || pro.isAutoCreated() || pro.isMultiple() || pro.isMandatory() || pro.getRequiredType() != 1 || pro.getOnParentVersion() != 1) continue;
            valueList.add(pro.getName());
        }
        this.initMultiValuesField();
        this.uiFormMultiValue.setValue(valueList);
    }

    public static class RemoveActionListener
    extends EventListener<UIActionTypeForm> {
        public void execute(Event<UIActionTypeForm> event) throws Exception {
            UIActionTypeForm uiForm = (UIActionTypeForm)((Object)event.getSource());
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    public static class AddActionListener
    extends EventListener<UIActionTypeForm> {
        public void execute(Event<UIActionTypeForm> event) throws Exception {
            UIActionTypeForm uiForm = (UIActionTypeForm)((Object)event.getSource());
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    public static class CancelActionListener
    extends EventListener<UIActionTypeForm> {
        public void execute(Event<UIActionTypeForm> event) throws Exception {
            UIActionTypeForm uiForm = (UIActionTypeForm)((Object)event.getSource());
            uiForm.reset();
            UIActionManager uiActionManager = (UIActionManager)uiForm.getAncestorOfType(UIActionManager.class);
            uiActionManager.removeChild(UIPopupWindow.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiActionManager);
        }
    }

    public static class SaveActionListener
    extends EventListener<UIActionTypeForm> {
        public void execute(Event<UIActionTypeForm> event) throws Exception {
            UIActionTypeForm uiForm = (UIActionTypeForm)((Object)event.getSource());
            PortletRequestContext context = (PortletRequestContext)event.getRequestContext();
            String repository = WCMCoreUtils.getRepository().getConfiguration().getName();
            UIActionManager uiActionManager = (UIActionManager)uiForm.getAncestorOfType(UIActionManager.class);
            ActionServiceContainer actionServiceContainer = (ActionServiceContainer)uiForm.getApplicationComponent(ActionServiceContainer.class);
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            String actionLabel = (String)uiForm.getUIStringInput(UIActionTypeForm.FIELD_NAME).getValue();
            String actionName = "exo:" + this.cleanString(actionLabel);
            if (uiForm.isUpdate) {
                actionName = uiForm.actionName_;
            }
            ArrayList<String> variables = new ArrayList<String>();
            List values = uiForm.uiFormMultiValue.getValue();
            if (values != null && values.size() > 0) {
                for (Object value : values) {
                    variables.add((String)value);
                }
            }
            if (!uiForm.isUpdate) {
                for (NodeType nodeType : actionServiceContainer.getCreatedActionTypes(repository)) {
                    if (!actionName.equals(nodeType.getName())) continue;
                    uiApp.addMessage(new ApplicationMessage("UIActionTypeForm.msg.action-exist", null, 1));
                    return;
                }
            }
            try {
                String script = (String)uiForm.getUIFormSelectBox(UIActionTypeForm.FIELD_SCRIPT).getValue();
                actionServiceContainer.createActionType(actionName, UIActionTypeForm.ACTION_TYPE, script, actionLabel, variables, false, uiForm.isUpdate);
                uiActionManager.refresh();
                uiForm.refresh();
                uiActionManager.removeChild(UIPopupWindow.class);
            }
            catch (Exception e) {
                uiApp.addMessage(new ApplicationMessage("UIActionTypeForm.msg.action-type-create-error", new Object[]{actionLabel}, 1));
                return;
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiActionManager);
        }

        private String cleanString(String input) {
            Transliterator accentsconverter = Transliterator.getInstance((String)"Latin; NFD; [:Nonspacing Mark:] Remove; NFC;");
            input = accentsconverter.transliterate(input);
            return input.trim();
        }
    }

    public static class ChangeTypeActionListener
    extends EventListener<UIActionTypeForm> {
        public void execute(Event<UIActionTypeForm> event) throws Exception {
            UIActionTypeForm uiForm = (UIActionTypeForm)((Object)event.getSource());
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }
}

