/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.mow.core.api.wiki;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.UndeclaredRepositoryException;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.PrimaryType;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.core.api.WikiStoreImpl;
import org.exoplatform.wiki.mow.core.api.wiki.GroupWiki;
import org.exoplatform.wiki.mow.core.api.wiki.WikiContainer;
import org.exoplatform.wiki.utils.JCRUtils;

@PrimaryType(name="wiki:groupwikis")
public abstract class GroupWikiContainer
extends WikiContainer<GroupWiki> {
    @OneToOne
    @MappedBy(value="groupwikis")
    public abstract WikiStoreImpl getMultiWiki();

    @Override
    public GroupWiki addWiki(Wiki wiki) throws WikiException {
        GroupWiki groupWiki = this.getWikiObject(wiki.getOwner());
        if (groupWiki == null) {
            groupWiki = this.createWiki(wiki);
        }
        return groupWiki;
    }

    @Override
    protected GroupWiki getWikiObject(String wikiOwner) {
        Node wikiNode;
        if ((wikiOwner = this.validateWikiOwner(wikiOwner)) == null) {
            return null;
        }
        OrganizationService organizationService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
        try {
            if (organizationService.getGroupHandler().findGroupById(wikiOwner) == null) {
                return null;
            }
        }
        catch (Exception ex) {
            return null;
        }
        ChromatticSession session = this.mowService.getSession();
        try {
            Node rootNode = session.getJCRSession().getRootNode();
            Node groupDataNode = rootNode.getNode("Groups" + wikiOwner + "/ApplicationData");
            try {
                wikiNode = groupDataNode.getNode("eXoWiki");
            }
            catch (PathNotFoundException e) {
                return null;
            }
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
        GroupWiki gwiki = (GroupWiki)session.findByNode(GroupWiki.class, wikiNode);
        gwiki.setGroupWikis(this);
        return gwiki;
    }

    @Override
    public GroupWiki createWiki(Wiki wiki) throws WikiException {
        OrganizationService organizationService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
        try {
            String wikiOwner = this.validateWikiOwner(wiki.getOwner());
            if (wikiOwner == null) {
                return null;
            }
            if (organizationService.getGroupHandler().findGroupById(wikiOwner) == null) {
                throw new WikiException("Cannot create wiki " + wiki.getType() + ":" + wikiOwner + " because group " + wikiOwner + " does not exist.");
            }
            ChromatticSession session = this.mowService.getSession();
            Node rootNode = session.getJCRSession().getRootNode();
            Node groupDataNode = rootNode.getNode("Groups" + wiki.getOwner() + "/ApplicationData");
            Node wikiNode = groupDataNode.addNode("eXoWiki", "wiki:groupwiki");
            groupDataNode.save();
            GroupWiki gwiki = (GroupWiki)session.findByNode(GroupWiki.class, wikiNode);
            gwiki.setGroupWikis(this);
            gwiki.setOwner(wiki.getOwner());
            gwiki.getPreferences();
            if (wiki.getPermissions() != null) {
                gwiki.setWikiPermissions(JCRUtils.convertPermissionEntryListToWikiPermissions(wiki.getPermissions()));
                gwiki.setDefaultPermissionsInited(true);
            }
            session.save();
            return gwiki;
        }
        catch (Exception e) {
            throw new WikiException("Cannot create wiki " + wiki.getType() + ":" + wiki.getOwner(), e);
        }
    }

    @Override
    protected String validateWikiOwner(String wikiOwner) {
        if (wikiOwner == null || wikiOwner.length() == 0) {
            return null;
        }
        if (!wikiOwner.startsWith("/")) {
            wikiOwner = "/" + wikiOwner;
        }
        if (wikiOwner.endsWith("/")) {
            wikiOwner = wikiOwner.substring(0, wikiOwner.length() - 1);
        }
        return wikiOwner;
    }
}

