/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.wadl;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.xml.namespace.QName;
import org.exoplatform.services.rest.method.MethodParameter;
import org.exoplatform.services.rest.resource.AbstractResourceDescriptor;
import org.exoplatform.services.rest.resource.ResourceMethodDescriptor;
import org.exoplatform.services.rest.wadl.WadlGenerator;
import org.exoplatform.services.rest.wadl.research.Application;
import org.exoplatform.services.rest.wadl.research.Method;
import org.exoplatform.services.rest.wadl.research.Param;
import org.exoplatform.services.rest.wadl.research.ParamStyle;
import org.exoplatform.services.rest.wadl.research.RepresentationType;
import org.exoplatform.services.rest.wadl.research.Request;
import org.exoplatform.services.rest.wadl.research.Resource;
import org.exoplatform.services.rest.wadl.research.Resources;
import org.exoplatform.services.rest.wadl.research.Response;

public class BaseWadlGeneratorImpl
implements WadlGenerator {
    @Override
    public Application createApplication() {
        return new Application();
    }

    @Override
    public Resources createResources() {
        return new Resources();
    }

    @Override
    public Resource createResource(AbstractResourceDescriptor rd) {
        if (rd.isRootResource()) {
            return this.createResource(rd.getPathValue().getPath());
        }
        return this.createResource((String)null);
    }

    @Override
    public Resource createResource(String path) {
        Resource wadlResource = new Resource();
        if (path != null) {
            wadlResource.setPath(path);
        }
        return wadlResource;
    }

    @Override
    public Method createMethod(ResourceMethodDescriptor rmd) {
        String httpMethod = rmd.getHttpMethod();
        if (httpMethod.equals("HEAD")) {
            return null;
        }
        Method wadlMethod = new Method();
        wadlMethod.setName(httpMethod);
        java.lang.reflect.Method m = rmd.getMethod();
        if (m != null) {
            wadlMethod.setId(m.getName());
        }
        return wadlMethod;
    }

    @Override
    public Request createRequest() {
        return new Request();
    }

    @Override
    public Response createResponse() {
        return new Response();
    }

    @Override
    public RepresentationType createRequestRepresentation(MediaType mediaType) {
        RepresentationType wadlRepresentation = new RepresentationType();
        wadlRepresentation.setMediaType(mediaType.toString());
        return wadlRepresentation;
    }

    @Override
    public RepresentationType createResponseRepresentation(MediaType mediaType) {
        RepresentationType wadlRepresentation = new RepresentationType();
        wadlRepresentation.setMediaType(mediaType.toString());
        return wadlRepresentation;
    }

    @Override
    public Param createParam(MethodParameter methodParameter) {
        Param wadlParemeter = null;
        Annotation annotation = methodParameter.getAnnotation();
        Class<? extends Annotation> annotationClass = methodParameter.getAnnotation().annotationType();
        if (annotationClass == PathParam.class) {
            wadlParemeter = new Param();
            wadlParemeter.setName(((PathParam)annotation).value());
            wadlParemeter.setStyle(ParamStyle.TEMPLATE);
        } else if (annotationClass == MatrixParam.class) {
            wadlParemeter = new Param();
            wadlParemeter.setName(((MatrixParam)annotation).value());
            wadlParemeter.setStyle(ParamStyle.MATRIX);
        } else if (annotationClass == QueryParam.class) {
            wadlParemeter = new Param();
            wadlParemeter.setName(((QueryParam)annotation).value());
            wadlParemeter.setStyle(ParamStyle.QUERY);
        } else if (annotationClass == HeaderParam.class) {
            wadlParemeter = new Param();
            wadlParemeter.setName(((HeaderParam)annotation).value());
            wadlParemeter.setStyle(ParamStyle.HEADER);
        }
        if (wadlParemeter == null) {
            return null;
        }
        Class<?> parameterClass = methodParameter.getParameterClass();
        if (parameterClass == List.class || parameterClass == Set.class || parameterClass == SortedSet.class) {
            wadlParemeter.setRepeating(true);
        }
        if (methodParameter.getDefaultValue() != null) {
            wadlParemeter.setDefault(methodParameter.getDefaultValue());
        }
        if (parameterClass.equals(Boolean.class) || parameterClass.equals(Boolean.TYPE)) {
            wadlParemeter.setType(new QName("http://www.w3.org/2001/XMLSchema", "boolean", "xs"));
        } else if (parameterClass.equals(Byte.class) || parameterClass.equals(Byte.TYPE)) {
            wadlParemeter.setType(new QName("http://www.w3.org/2001/XMLSchema", "byte", "xs"));
        } else if (parameterClass.equals(Short.class) || parameterClass.equals(Short.TYPE)) {
            wadlParemeter.setType(new QName("http://www.w3.org/2001/XMLSchema", "short", "xs"));
        } else if (parameterClass.equals(Integer.class) || parameterClass.equals(Integer.TYPE)) {
            wadlParemeter.setType(new QName("http://www.w3.org/2001/XMLSchema", "integer", "xs"));
        } else if (parameterClass.equals(Long.class) || parameterClass.equals(Long.TYPE)) {
            wadlParemeter.setType(new QName("http://www.w3.org/2001/XMLSchema", "long", "xs"));
        } else if (parameterClass.equals(Float.class) || parameterClass.equals(Float.TYPE)) {
            wadlParemeter.setType(new QName("http://www.w3.org/2001/XMLSchema", "float", "xs"));
        } else if (parameterClass.equals(Double.class) || parameterClass.equals(Double.TYPE)) {
            wadlParemeter.setType(new QName("http://www.w3.org/2001/XMLSchema", "double", "xs"));
        } else {
            wadlParemeter.setType(new QName("http://www.w3.org/2001/XMLSchema", "string", "xs"));
        }
        return wadlParemeter;
    }
}

