/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lang.css;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.config.AllowedFileResolver;
import com.google.caja.config.ConfigUtil;
import com.google.caja.lang.css.CssPropBit;
import com.google.caja.lang.css.CssSchema;
import com.google.caja.lang.css.JSRE;
import com.google.caja.lang.css.Partitions;
import com.google.caja.lexer.CssLexer;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.AbstractParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.css.CssPropertySignature;
import com.google.caja.parser.js.ArrayConstructor;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.IntegerLiteral;
import com.google.caja.parser.js.MultiDeclaration;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.RegexpLiteral;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.ValueProperty;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.plugin.LinkStyleWhitelist;
import com.google.caja.reporting.EchoingMessageQueue;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.RenderContext;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.caja.tools.BuildCommand;
import com.google.caja.util.Bag;
import com.google.caja.util.Charsets;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import com.google.caja.util.Name;
import com.google.caja.util.Pair;
import com.google.caja.util.Sets;
import com.google.caja.util.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssPropertyPatterns {
    private final CssSchema schema;
    private static final JSRE SPACES = JSRE.many(JSRE.raw("\\s"));
    private static final JSRE OPT_SPACES = JSRE.any(JSRE.raw("\\s"));
    private static final JSRE SPACES_NORMALIZED = JSRE.many(JSRE.raw(" "));
    private static final JSRE OPT_SPACES_NORMALIZED = JSRE.any(SPACES_NORMALIZED);
    private static final Name COLOR = Name.css("color");
    private static final Name STANDARD_COLOR = Name.css("color-standard");
    private static final Map<String, CssPropBit> BUILTIN_PROP_BITS = ImmutableMap.builder().put((Object)"number", (Object)CssPropBit.QUANTITY).put((Object)"percentage", (Object)CssPropBit.QUANTITY).put((Object)"angle", (Object)CssPropBit.QUANTITY).put((Object)"frequency", (Object)CssPropBit.QUANTITY).put((Object)"length", (Object)CssPropBit.QUANTITY).put((Object)"time", (Object)CssPropBit.QUANTITY).put((Object)"integer", (Object)CssPropBit.QUANTITY).put((Object)"hex-color", (Object)CssPropBit.HASH_VALUE).put((Object)"specific-voice", (Object)CssPropBit.QSTRING_CONTENT).put((Object)"family-name", (Object)CssPropBit.QSTRING_CONTENT).put((Object)"uri", (Object)CssPropBit.QSTRING_URL).put((Object)"z-index", (Object)CssPropBit.QUANTITY).build();
    private static final Map<String, JSRE> BUILTINS;

    public CssPropertyPatterns(CssSchema schema) {
        this.schema = schema;
    }

    public CssPropertyData cssPropertyToPattern(CssPropertySignature sig, boolean complete) {
        return new Inspector(complete).cssPropertyToPattern(sig);
    }

    public Pattern cssPropertyToJavaRegex(CssPropertySignature sig) {
        JSRE p = new Inspector(true).inspect(sig);
        if (p == null) {
            return null;
        }
        StringBuilder out = new StringBuilder();
        p.render(out);
        return Pattern.compile("" + out, 2);
    }

    private static boolean isIdentChar(char ch) {
        return CssLexer.isNmStart(ch) || '0' <= ch && ch <= '9' || ch == '#' || ch == '.';
    }

    public static void generatePatterns(CssSchema schema, Appendable out) throws IOException {
        FilePosition unk = FilePosition.UNKNOWN;
        CssPropertyPatterns pp = new CssPropertyPatterns(schema);
        List<CssSchema.CssPropertyInfo> props = Lists.newArrayList(schema.getCssProperties());
        Collections.sort(props, new Comparator<CssSchema.CssPropertyInfo>(){

            @Override
            public int compare(CssSchema.CssPropertyInfo a, CssSchema.CssPropertyInfo b) {
                return a.name.compareTo(b.name);
            }
        });
        Set<String> commonSubstrings = Sets.newLinkedHashSet();
        commonSubstrings.add("|left|center|right");
        commonSubstrings.add("|top|center|bottom");
        CssPropertyPatterns cssPropertyPatterns = pp;
        cssPropertyPatterns.getClass();
        Inspector inspector = cssPropertyPatterns.new Inspector(false);
        for (Name commonSymbol : new Name[]{COLOR, Name.css("standard-color"), Name.css("length"), Name.css("length:0,"), Name.css("border-style"), Name.css("border-width"), Name.css("bg-position"), Name.css("bg-size"), Name.css("percentage"), Name.css("percentage:0,"), Name.css("uri"), Name.css("repeat-style")}) {
            String string;
            CssPropertySignature.SymbolSignature sig = (CssPropertySignature.SymbolSignature)CssPropertySignature.Parser.parseSignature("<" + commonSymbol + ">");
            JSREBuilder p = inspector.symbolToPattern(false, sig);
            if (p == null || (string = CssPropertyPatterns.withoutSpacesOrZero(p.p.optimize()).toString()).length() == 0) continue;
            commonSubstrings.add(string);
        }
        Map<String, int[]> regexPoolMap = Maps.newHashMap();
        Map<String, Integer> commonSubstringMap = Maps.newLinkedHashMap();
        List<Pair<CssSchema.CssPropertyInfo, CssPropertyData>> propData = Lists.newArrayList();
        List<StringLiteral> stringPool = Lists.newArrayList();
        List<Expression> regexPool = Lists.newArrayList();
        for (CssSchema.CssPropertyInfo cssPropertyInfo : props) {
            if (!schema.isPropertyAllowed(cssPropertyInfo.name)) continue;
            propData.add(Pair.pair(cssPropertyInfo, inspector.cssPropertyToPattern(cssPropertyInfo.sig)));
        }
        for (String string : commonSubstrings) {
            int n = 0;
            for (Pair pair : propData) {
                String pattern = ((CssPropertyData)pair.b).regex;
                if (pattern == null) continue;
                int index = -1;
                while ((index = pattern.indexOf(string, index + string.length())) >= 0) {
                    ++n;
                }
            }
            if (n <= true) continue;
            int n2 = stringPool.size();
            stringPool.add(StringLiteral.valueOf(unk, string));
            commonSubstringMap.put(string, n2);
        }
        for (Pair pair : propData) {
            String pattern = ((CssPropertyData)pair.b).regex;
            if (pattern == null) continue;
            int[] nArray = (int[])regexPoolMap.get(pattern);
            if (nArray == null) {
                regexPoolMap.put(pattern, new int[]{-1});
                continue;
            }
            if (nArray[0] != -1) continue;
            nArray[0] = regexPool.size();
            regexPool.add(CssPropertyPatterns.makeRegexp(commonSubstringMap, pattern));
        }
        Statement poolDecls = null;
        if (!stringPool.isEmpty()) {
            poolDecls = CssPropertyPatterns.joinDeclarations(poolDecls, new Declaration(unk, new Identifier(unk, "s"), new ArrayConstructor(unk, stringPool)));
        }
        if (!regexPool.isEmpty()) {
            poolDecls = CssPropertyPatterns.joinDeclarations(poolDecls, new Declaration(unk, new Identifier(unk, "c"), new ArrayConstructor(unk, regexPool)));
        }
        List<Set<String>> list = Lists.newArrayList();
        for (Pair pair : propData) {
            list.add(((CssPropertyData)pair.b).literals);
        }
        Partitions.Partition<String> litPartition = Partitions.partition(list, String.class, null);
        List<ArrayConstructor> list2 = Lists.newArrayList();
        for (int[] literalIndices : litPartition.partition) {
            List<StringLiteral> literalArr = Lists.newArrayList();
            for (int litIndex : literalIndices) {
                literalArr.add(StringLiteral.valueOf(unk, ((String[])litPartition.universe)[litIndex]));
            }
            list2.add(new ArrayConstructor(unk, literalArr));
        }
        if (!list2.isEmpty()) {
            poolDecls = CssPropertyPatterns.joinDeclarations(poolDecls, new Declaration(unk, new Identifier(unk, "L"), new ArrayConstructor(unk, list2)));
        }
        List<ValueProperty> list3 = Lists.newArrayList();
        StringLiteral regexObjKey = new StringLiteral(unk, "cssExtra");
        StringLiteral alternatesObjKey = new StringLiteral(unk, "cssAlternates");
        StringLiteral propbitsObjKey = new StringLiteral(unk, "cssPropBits");
        StringLiteral litgroupObjKey = new StringLiteral(unk, "cssLitGroup");
        int n = propData.size();
        for (int propIndex = 0; propIndex < n; ++propIndex) {
            Pair d = (Pair)propData.get(propIndex);
            CssSchema.CssPropertyInfo prop = (CssSchema.CssPropertyInfo)d.a;
            CssPropertyData data = (CssPropertyData)d.b;
            ObjectConstructor dataObj = new ObjectConstructor(unk);
            String regex = data.regex;
            if (regex != null) {
                int poolIndex = ((int[])regexPoolMap.get(regex))[0];
                Expression re = poolIndex < 0 ? CssPropertyPatterns.makeRegexp(commonSubstringMap, regex) : (Expression)QuasiBuilder.substV("c[@i]", "i", new IntegerLiteral(unk, poolIndex));
                dataObj.appendChild(new ValueProperty(regexObjKey, re));
            }
            String dom2property = CssPropertyPatterns.propertyNameToDom2Property(prop.name);
            AbstractParseTreeNode altNames = null;
            for (String altDom2Property : prop.dom2properties) {
                if (altDom2Property.equals(dom2property)) continue;
                if (altNames == null) {
                    altNames = new ArrayConstructor(unk, Collections.emptyList());
                }
                altNames.appendChild(StringLiteral.valueOf(unk, altDom2Property));
            }
            if (altNames != null) {
                dataObj.appendChild(new ValueProperty(alternatesObjKey, (Expression)((Object)altNames)));
            }
            list3.add(new ValueProperty(unk, StringLiteral.valueOf(unk, prop.name.getCanonicalForm()), dataObj));
            int propBits = 0;
            for (CssPropBit b : data.properties) {
                propBits |= b.jsValue;
            }
            if (LinkStyleWhitelist.HISTORY_INSENSITIVE_STYLE_WHITELIST.contains(prop.name)) {
                propBits |= CssPropBit.HISTORY_INSENSITIVE.jsValue;
            } else if (LinkStyleWhitelist.PROPERTIES_ALLOWED_IN_LINK_CLASSES.contains(prop.name)) {
                propBits |= CssPropBit.ALLOWED_IN_LINK.jsValue;
            }
            dataObj.appendChild(new ValueProperty(propbitsObjKey, new IntegerLiteral(unk, propBits)));
            List<Expression> litGroups = Lists.newArrayList();
            for (int groupIndex : litPartition.unions[propIndex]) {
                litGroups.add((Expression)QuasiBuilder.substV("L[@i]", "i", new IntegerLiteral(unk, groupIndex)));
            }
            if (litGroups.isEmpty()) continue;
            dataObj.appendChild(new ValueProperty(litgroupObjKey, new ArrayConstructor(unk, litGroups)));
        }
        ObjectConstructor cssSchema = new ObjectConstructor(unk, list3);
        ParseTreeNode js = QuasiBuilder.substV("var cssSchema = (function () {  @poolDecls?;  return @cssSchema;})();", "poolDecls", poolDecls, "cssSchema", cssSchema);
        TokenConsumer tc = js.makeRenderer(out, null);
        js.render(new RenderContext(tc));
        tc.noMoreTokens();
        out.append(";\n");
    }

    private static Expression makeRegexp(Map<String, Integer> commonSubstrings, String regex) {
        FilePosition unk = FilePosition.UNKNOWN;
        List<Pair<String, Expression>> substrings = Lists.newArrayList();
        for (Map.Entry<String, Integer> e : commonSubstrings.entrySet()) {
            substrings.add(Pair.pair(e.getKey(), (Expression)QuasiBuilder.substV("s[@i]", "i", new IntegerLiteral(unk, e.getValue().intValue()))));
        }
        List<Expression> parts = Lists.newArrayList();
        assert (regex.startsWith("/") && regex.endsWith("/i"));
        String pattern = regex.substring(1, regex.length() - 2);
        CssPropertyPatterns.makeRegexpOnto(substrings, pattern, 0, parts);
        if (parts.size() == 1 && parts.get(0) instanceof StringLiteral) {
            return new RegexpLiteral(unk, regex);
        }
        Expression e = parts.get(0);
        int n = parts.size();
        for (int i = 1; i < n; ++i) {
            e = Operation.createInfix(Operator.ADDITION, e, parts.get(i));
        }
        return (Expression)QuasiBuilder.substV("RegExp(@pattern, 'i')", "pattern", e);
    }

    private static void makeRegexpOnto(List<Pair<String, Expression>> strs, String pattern, int index, List<Expression> parts) {
        if ("".equals(pattern)) {
            return;
        }
        int n = strs.size();
        while (index < n) {
            Pair<String, Expression> commonString = strs.get(index);
            String s = (String)commonString.a;
            int pos = pattern.indexOf(s);
            if (pos >= 0) {
                CssPropertyPatterns.makeRegexpOnto(strs, pattern.substring(0, pos), index + 1, parts);
                parts.add((Expression)commonString.b);
                CssPropertyPatterns.makeRegexpOnto(strs, pattern.substring(pos + s.length()), index, parts);
                return;
            }
            ++index;
        }
        parts.add(StringLiteral.valueOf(FilePosition.UNKNOWN, pattern));
    }

    private static Statement joinDeclarations(@Nullable Statement decl, Declaration d) {
        if (decl == null) {
            return d;
        }
        if (decl instanceof Declaration) {
            decl = new MultiDeclaration(FilePosition.UNKNOWN, Arrays.asList((Declaration)decl));
        }
        ((MultiDeclaration)decl).appendChild(d);
        return decl;
    }

    private static JSRE withoutSpacesOrZero(JSRE p) {
        if (p instanceof JSRE.Atom) {
            String s = ((JSRE.Atom)p).atom;
            return "0".equals(s) || "\\s".equals(s) ? null : p;
        }
        if (p instanceof JSRE.Concatenation) {
            JSRE.Concatenation c = (JSRE.Concatenation)p;
            List<JSRE> children = Lists.newArrayList(c.children);
            while (!children.isEmpty()) {
                JSRE p0 = children.get(0);
                JSRE p0w = CssPropertyPatterns.withoutSpacesOrZero(p0);
                if (p0w == null) {
                    children.remove(0);
                    continue;
                }
                children.set(0, p0w);
                break;
            }
            if (children.isEmpty()) {
                return null;
            }
            return JSRE.cat(children).optimize();
        }
        if (p instanceof JSRE.Alternation) {
            List<JSRE> children = ((JSRE.Alternation)p).children;
            List<JSRE> childrenNew = Lists.newArrayList();
            for (JSRE child : children) {
                JSRE wo = CssPropertyPatterns.withoutSpacesOrZero(child);
                if (wo == null) continue;
                childrenNew.add(wo);
            }
            if (childrenNew.isEmpty()) {
                return null;
            }
            return JSRE.alt(childrenNew);
        }
        if (p instanceof JSRE.Repetition) {
            JSRE.Repetition rep = (JSRE.Repetition)p;
            JSRE body = CssPropertyPatterns.withoutSpacesOrZero(rep.body);
            return body != null ? JSRE.rep(body, rep.min, rep.max).optimize() : null;
        }
        return p;
    }

    static String propertyNameToDom2Property(Name cssPropertyName) {
        String lcaseDashed = cssPropertyName.getCanonicalForm();
        int dash = lcaseDashed.indexOf(45);
        if (dash < 0) {
            return lcaseDashed;
        }
        StringBuilder sb = new StringBuilder(lcaseDashed.length());
        int written = 0;
        do {
            sb.append(lcaseDashed, written, dash);
            written = dash + 1;
            if (written >= lcaseDashed.length()) continue;
            sb.append(Strings.upper(lcaseDashed.substring(written, written + 1)));
            ++written;
        } while ((dash = lcaseDashed.indexOf(45, written)) >= 0);
        sb.append(lcaseDashed, written, lcaseDashed.length());
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        CssSchema schema = CssSchema.getDefaultCss21Schema(new SimpleMessageQueue());
        CssPropertyPatterns.generatePatterns(schema, System.out);
    }

    static {
        JSRE zero = JSRE.lit("0");
        JSRE one = JSRE.lit("1");
        JSRE digit = JSRE.raw("\\d");
        JSRE digits = JSRE.many(digit);
        JSRE dot = JSRE.raw("\\.");
        JSRE fraction = JSRE.cat(dot, digits);
        JSRE pct = JSRE.lit("%");
        JSRE minus = JSRE.lit("-");
        JSRE sign = JSRE.alt(JSRE.lit("+"), minus);
        JSRE unsignedNum = JSRE.cat(digits, JSRE.opt(fraction));
        JSRE signedNum = JSRE.cat(JSRE.opt(sign), unsignedNum);
        JSRE angleUnits = JSRE.alt(JSRE.alt(JSRE.lit("rad"), JSRE.lit("grad")), JSRE.lit("deg"));
        JSRE freqUnits = JSRE.alt(JSRE.lit("Hz"), JSRE.lit("kHz"));
        JSRE lengthUnits = JSRE.alt(JSRE.alt(JSRE.lit("cm"), JSRE.lit("mm"), JSRE.lit("em")), JSRE.lit("ex"), JSRE.lit("in"), JSRE.alt(JSRE.lit("pc"), JSRE.lit("pt"), JSRE.lit("px")));
        JSRE timeUnits = JSRE.alt(JSRE.lit("ms"), JSRE.lit("s"));
        JSRE quotedIdentifiers = JSRE.raw("\"\\w(?:[\\w-]*\\w)(?:\\s+\\w([\\w-]*\\w))*\"");
        JSRE hash = JSRE.lit("#");
        JSRE hex = JSRE.alt(digit, JSRE.lit("a"), JSRE.lit("b"), JSRE.lit("c"), JSRE.lit("d"), JSRE.lit("e"), JSRE.lit("f"));
        BUILTINS = Maps.immutableMap().put("number:0,", JSRE.alt(zero, unsignedNum).optimize()).put("number:0,1", JSRE.alt(JSRE.cat(zero, JSRE.opt(fraction)), fraction, JSRE.cat(one, JSRE.opt(JSRE.cat(dot, JSRE.many(zero))))).optimize()).put("number", JSRE.alt(zero, signedNum).optimize()).put("percentage:0,", JSRE.alt(zero, JSRE.cat(unsignedNum, pct)).optimize()).put("percentage:0,100", JSRE.alt(zero, JSRE.cat(unsignedNum, pct)).optimize()).put("percentage", JSRE.alt(zero, JSRE.cat(signedNum, pct)).optimize()).put("angle:0", JSRE.alt(zero, JSRE.cat(unsignedNum, angleUnits))).put("angle", JSRE.alt(zero, JSRE.cat(signedNum, angleUnits))).put("frequency", JSRE.alt(zero, JSRE.cat(unsignedNum, freqUnits))).put("length:0,", JSRE.alt(zero, JSRE.cat(unsignedNum, lengthUnits))).put("length", JSRE.alt(zero, JSRE.cat(signedNum, lengthUnits))).put("time:0,", JSRE.alt(zero, JSRE.cat(unsignedNum, timeUnits))).put("time", JSRE.alt(zero, JSRE.cat(signedNum, timeUnits))).put("integer", JSRE.cat(JSRE.opt(minus), digits)).put("integer:0,", digits).put("integer:0,255", digits).put("hex-color", JSRE.cat(hash, JSRE.rep(JSRE.rep(hex, 3, 3), 1, 2))).put("specific-voice", quotedIdentifiers).put("family-name", quotedIdentifiers).put("uri", JSRE.cat(JSRE.lit("url(\""), JSRE.many(JSRE.raw("[^()\\\\\"\\r\\n]")), JSRE.lit("\")"))).put("z-index:-9999999,9999999", JSRE.raw("-?\\d{1,7}")).create();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements BuildCommand {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean build(List<File> inputs, List<File> deps, Map<String, Object> options, File output) throws IOException {
            CssSchema schema;
            File symbolsAndPropertiesFile = null;
            File functionsFile = null;
            for (File input : inputs) {
                if (!input.getName().endsWith(".json")) continue;
                if (symbolsAndPropertiesFile == null) {
                    symbolsAndPropertiesFile = input;
                    continue;
                }
                if (functionsFile == null) {
                    functionsFile = input;
                    continue;
                }
                throw new IOException("Unused input " + input);
            }
            if (symbolsAndPropertiesFile == null) {
                throw new IOException("No JSON whitelist for CSS Symbols + Properties");
            }
            if (functionsFile == null) {
                throw new IOException("No JSON whitelist for CSS Functions");
            }
            FilePosition sps = FilePosition.startOfFile(new InputSource(symbolsAndPropertiesFile.getAbsoluteFile().toURI()));
            FilePosition fns = FilePosition.startOfFile(new InputSource(functionsFile.getAbsoluteFile().toURI()));
            MessageContext mc = new MessageContext();
            mc.addInputSource(sps.source());
            mc.addInputSource(fns.source());
            EchoingMessageQueue mq = new EchoingMessageQueue(new PrintWriter((Writer)new OutputStreamWriter(System.err), true), mc, false);
            Set<File> inputsAndDeps = Sets.newHashSet();
            for (File f : inputs) {
                inputsAndDeps.add(f.getAbsoluteFile());
            }
            for (File f : deps) {
                inputsAndDeps.add(f.getAbsoluteFile());
            }
            AllowedFileResolver resolver = new AllowedFileResolver(inputsAndDeps);
            try {
                schema = new CssSchema(ConfigUtil.loadWhiteListFromJson(sps.source().getUri(), resolver, mq), ConfigUtil.loadWhiteListFromJson(fns.source().getUri(), resolver, mq));
            }
            catch (ParseException ex) {
                ex.toMessageQueue(mq);
                throw (IOException)new IOException("Failed to parse schema").initCause(ex);
            }
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(output), Charsets.UTF_8.name());
            try {
                String currentDate = "" + new Date();
                if (currentDate.indexOf("*/") >= 0) {
                    throw new SomethingWidgyHappenedError("Date should not contain '*/'");
                }
                out.write("/* Copyright Google Inc.\n");
                out.write(" * Licensed under the Apache Licence Version 2.0\n");
                out.write(" * Autogenerated at " + currentDate + "\n");
                out.write(" * \\@overrides window\n");
                out.write(" * \\@provides cssSchema");
                for (CssPropBit b : CssPropBit.values()) {
                    out.write(", CSS_PROP_BIT_");
                    out.write(Strings.upper(b.name()));
                }
                out.write(" */\n");
                for (CssPropBit b : CssPropBit.values()) {
                    out.write("/**\n * @const\n * @type {number}\n */\n");
                    out.write("var CSS_PROP_BIT_");
                    out.write(Strings.upper(b.name()));
                    out.write(" = ");
                    out.write(String.valueOf(b.jsValue));
                    out.write(";\n");
                }
                CssPropertyPatterns.generatePatterns(schema, out);
                out.write("if (typeof window !== 'undefined') {\n");
                out.write("  window['cssSchema'] = cssSchema;\n");
                out.write("}\n");
            }
            finally {
                ((Writer)out).close();
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Inspector {
        final EnumSet<CssPropBit> props = EnumSet.noneOf(CssPropBit.class);
        final Set<String> literals = Sets.newHashSet();
        final boolean complete;
        private final Bag<String> refsUsed;
        final JSRE spaces;
        final JSRE optSpaces;

        Inspector(boolean complete) {
            this(complete, Bag.newHashBag());
        }

        private Inspector(boolean complete, Bag<String> refsUsed) {
            this.complete = complete;
            this.refsUsed = refsUsed;
            this.spaces = complete ? SPACES : SPACES_NORMALIZED;
            this.optSpaces = complete ? OPT_SPACES : OPT_SPACES_NORMALIZED;
        }

        CssPropertyData cssPropertyToPattern(CssPropertySignature sig) {
            JSRE p = this.inspect(sig);
            String regex = null;
            if (p != null) {
                StringBuilder out = new StringBuilder();
                out.append('/');
                p.render(out);
                out.append("/i");
                regex = out.toString();
            }
            return new CssPropertyData(regex, EnumSet.copyOf(this.props), Sets.newHashSet(this.literals));
        }

        JSRE inspect(CssPropertySignature sig) {
            this.literals.clear();
            this.props.clear();
            JSREBuilder b = this.sigToPattern(false, sig);
            if (b == null) {
                return null;
            }
            return JSRE.cat(JSRE.raw("^"), this.optSpaces, b.p, this.optSpaces, JSRE.raw("$")).optimize();
        }

        private JSREBuilder sigToPattern(boolean identBefore, CssPropertySignature sig) {
            if (sig instanceof CssPropertySignature.LiteralSignature) {
                return this.litToPattern(identBefore, (CssPropertySignature.LiteralSignature)sig);
            }
            if (sig instanceof CssPropertySignature.RepeatedSignature) {
                return this.repToPattern(identBefore, (CssPropertySignature.RepeatedSignature)sig);
            }
            if (sig instanceof CssPropertySignature.PropertyRefSignature) {
                return this.refToPattern(identBefore, (CssPropertySignature.PropertyRefSignature)sig);
            }
            if (sig instanceof CssPropertySignature.SeriesSignature) {
                return this.seriesToPattern(identBefore, (CssPropertySignature.SeriesSignature)sig);
            }
            if (sig instanceof CssPropertySignature.SymbolSignature) {
                return this.symbolToPattern(identBefore, (CssPropertySignature.SymbolSignature)sig);
            }
            if (sig instanceof CssPropertySignature.SetSignature || sig instanceof CssPropertySignature.ExclusiveSetSignature) {
                return this.setToPattern(identBefore, sig);
            }
            if (sig instanceof CssPropertySignature.CallSignature) {
                return this.callToPattern(identBefore, (CssPropertySignature.CallSignature)sig);
            }
            return null;
        }

        private JSREBuilder litToPattern(boolean identBefore, CssPropertySignature.LiteralSignature lit) {
            String litValue = lit.getValue();
            this.literals.add(litValue);
            if (!this.complete) {
                return null;
            }
            boolean ident = CssPropertyPatterns.isIdentChar(litValue.charAt(litValue.length() - 1));
            JSRE p = JSRE.lit(litValue);
            if (p == null) {
                return null;
            }
            return new JSREBuilder(ident, JSRE.cat(ident && identBefore ? this.spaces : this.optSpaces, p));
        }

        private JSREBuilder repToPattern(boolean identBefore, CssPropertySignature.RepeatedSignature sig) {
            CssPropertySignature rep = sig.getRepeatedSignature();
            if (rep instanceof CssPropertySignature.ExclusiveSetSignature) {
                return this.exclusiveToPattern(identBefore, rep);
            }
            JSREBuilder repeatedPattern = this.sigToPattern(identBefore, rep);
            if (repeatedPattern == null) {
                return null;
            }
            int min = sig.minCount;
            int max = sig.maxCount;
            if (repeatedPattern.identBefore == identBefore || max == 1) {
                return new JSREBuilder(repeatedPattern.identBefore, JSRE.rep(repeatedPattern.p, min, max));
            }
            JSREBuilder tail = this.sigToPattern(repeatedPattern.identBefore, rep);
            if (max != Integer.MAX_VALUE) {
                --max;
            }
            JSRE spaceSeparated = JSRE.cat(repeatedPattern.p, JSRE.rep(tail.p, min != 0 ? min - 1 : 0, max));
            if (min == 0) {
                spaceSeparated = JSRE.opt(spaceSeparated);
            }
            return new JSREBuilder(tail.identBefore, spaceSeparated);
        }

        private JSREBuilder refToPattern(boolean identBefore, CssPropertySignature.PropertyRefSignature sig) {
            this.refsUsed.incr(sig.getPropertyName().getCanonicalForm());
            CssSchema.CssPropertyInfo p = CssPropertyPatterns.this.schema.getCssProperty(sig.getPropertyName());
            return p != null ? this.sigToPattern(identBefore, p.sig) : null;
        }

        private JSREBuilder seriesToPattern(boolean identBefore, CssPropertySignature.SeriesSignature sig) {
            List<JSRE> children = Lists.newArrayList();
            for (CssPropertySignature cssPropertySignature : sig.children()) {
                JSREBuilder b = this.sigToPattern(identBefore, cssPropertySignature);
                if (children == null) continue;
                if (b != null) {
                    children.add(b.p);
                    identBefore = b.identBefore;
                    continue;
                }
                if (!this.complete) continue;
                children = null;
            }
            if (children == null) {
                return null;
            }
            return new JSREBuilder(identBefore, JSRE.cat(children));
        }

        private JSREBuilder symbolToPattern(boolean identBefore, CssPropertySignature.SymbolSignature sig) {
            CssSchema.SymbolInfo standard;
            Name symbolName = sig.getValue();
            this.refsUsed.incr(symbolName.getCanonicalForm());
            JSRE builtinMatch = this.builtinToPattern(symbolName);
            if (builtinMatch != null) {
                String re = builtinMatch.toString();
                boolean ident = CssPropertyPatterns.isIdentChar(re.charAt(0));
                boolean identAfter = CssPropertyPatterns.isIdentChar(re.charAt(re.length() - 1));
                return new JSREBuilder(identAfter, JSRE.cat(identBefore && ident ? this.spaces : this.optSpaces, builtinMatch));
            }
            CssSchema.SymbolInfo s = CssPropertyPatterns.this.schema.getSymbol(symbolName);
            if (COLOR.equals(symbolName) && this.complete && (standard = CssPropertyPatterns.this.schema.getSymbol(STANDARD_COLOR)) != null) {
                s = standard;
            }
            return s != null ? this.sigToPattern(identBefore, s.sig) : null;
        }

        private JSREBuilder setToPattern(boolean identBefore, CssPropertySignature sig) {
            if (sig.children().isEmpty()) {
                return null;
            }
            List<JSRE> children = Lists.newArrayList();
            boolean identAfter = false;
            for (CssPropertySignature cssPropertySignature : sig.children()) {
                JSREBuilder b = this.sigToPattern(identBefore, cssPropertySignature);
                if (b == null) continue;
                children.add(b.p);
                identAfter |= b.identBefore;
            }
            if (children.isEmpty()) {
                return null;
            }
            return new JSREBuilder(identAfter, JSRE.alt(children));
        }

        private JSREBuilder callToPattern(boolean identBefore, CssPropertySignature.CallSignature sig) {
            Iterator<? extends CssPropertySignature> sigs = sig.children().iterator();
            List<JSRE> children = Lists.newArrayList();
            Inspector inspector = new Inspector(true, this.refsUsed);
            JSREBuilder fnPattern = inspector.sigToPattern(identBefore, sigs.next());
            if (fnPattern == null) {
                return null;
            }
            children.add(fnPattern.p);
            children.add(JSRE.lit("("));
            boolean first = true;
            while (sigs.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    children.add(JSRE.lit(","));
                }
                JSREBuilder actual = inspector.sigToPattern(false, sigs.next());
                if (actual == null) {
                    return null;
                }
                children.add(actual.p);
            }
            children.add(this.optSpaces);
            children.add(JSRE.lit(")"));
            return new JSREBuilder(false, JSRE.cat(children));
        }

        private JSREBuilder exclusiveToPattern(boolean identBefore, CssPropertySignature sig) {
            boolean bl;
            if (sig.children().isEmpty()) {
                return null;
            }
            List<JSRE> head = Lists.newArrayList();
            boolean identAfterHead = false;
            for (CssPropertySignature cssPropertySignature : sig.children()) {
                JSREBuilder b = this.sigToPattern(identBefore, cssPropertySignature);
                if (b == null) continue;
                head.add(b.p);
                identAfterHead = b.identBefore;
            }
            List<JSRE> tail = Lists.newArrayList();
            boolean bl2 = false;
            for (CssPropertySignature cssPropertySignature : sig.children()) {
                JSREBuilder b = this.sigToPattern(identAfterHead, cssPropertySignature);
                if (b == null) continue;
                tail.add(b.p);
                bl = b.identBefore;
            }
            if (tail.isEmpty()) {
                return null;
            }
            return new JSREBuilder(bl, JSRE.cat(JSRE.alt(head), JSRE.rep(JSRE.alt(tail), 0, tail.size() - 1)));
        }

        private JSRE builtinToPattern(Name name) {
            JSRE p;
            String key = name.getCanonicalForm();
            int colon = key.lastIndexOf(58);
            boolean negative = key.lastIndexOf(45) > colon;
            String baseKey = colon >= 0 ? key.substring(0, colon) : key;
            boolean zIndex = baseKey.equals("z-index");
            CssPropBit b = (CssPropBit)((Object)BUILTIN_PROP_BITS.get(baseKey));
            if (b != null) {
                this.props.add(b);
                if (b == CssPropBit.QUANTITY && (colon < 0 || negative)) {
                    this.props.add(CssPropBit.NEGATIVE_QUANTITY);
                }
                if (zIndex) {
                    this.props.add(CssPropBit.Z_INDEX);
                }
                if (!this.complete) {
                    return null;
                }
            }
            if ((p = (JSRE)BUILTINS.get(key)) == null && key != baseKey) {
                p = (JSRE)BUILTINS.get(baseKey);
            }
            return p;
        }
    }

    private static class JSREBuilder {
        final JSRE p;
        final boolean identBefore;

        JSREBuilder(boolean identBefore, JSRE p) {
            assert (p != null);
            this.identBefore = identBefore;
            this.p = p;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CssPropertyData {
        @Nullable
        final String regex;
        final EnumSet<CssPropBit> properties;
        final Set<String> literals;

        CssPropertyData(@Nullable String regex, EnumSet<CssPropBit> properties, Set<String> literals) {
            this.regex = regex;
            this.properties = properties;
            this.literals = literals;
        }
    }
}

