/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.CssSplitter;
import com.google.caja.lexer.CssTokenType;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import com.google.caja.lexer.TokenStream;
import com.google.caja.reporting.DevNullMessageQueue;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.util.Lists;
import com.google.caja.util.Strings;
import java.util.LinkedList;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CssLexer
implements TokenStream<CssTokenType> {
    private final CssSplitter splitter;
    private final LinkedList<Token<CssTokenType>> pending = Lists.newLinkedList();

    public CssLexer(CharProducer cp) {
        this(cp, DevNullMessageQueue.singleton(), false);
    }

    public CssLexer(CharProducer cp, MessageQueue mq, boolean allowSubstitutions) {
        assert (null != cp);
        this.splitter = new CssSplitter(cp, mq, allowSubstitutions);
    }

    @Override
    public boolean hasNext() throws ParseException {
        return !this.pending.isEmpty() || this.splitter.hasNext();
    }

    @Override
    public Token<CssTokenType> next() throws ParseException {
        this.produce();
        if (null == this.pending) {
            throw new NoSuchElementException();
        }
        return this.pending.removeFirst();
    }

    public boolean areSubstitutionsAllowed() {
        return this.splitter.areSubstitutionsAllowed();
    }

    public void allowSubstitutions(boolean allow) {
        this.splitter.allowSubstitutions(allow);
    }

    public static String decodeCssIdentifier(CharSequence ident) {
        StringBuilder sb = null;
        int pos = 0;
        int i = 0;
        int n = ident.length();
        while (i < n) {
            if (ident.charAt(i) == '\\') {
                if (sb == null) {
                    sb = new StringBuilder();
                }
                sb.append(ident, pos, i);
                int codepoint = 0;
                while (++i < n && CssLexer.isHexChar(ident.charAt(i))) {
                    char ch = ident.charAt(i);
                    codepoint <<= 4;
                    if (ch >= '0' && ch <= '9') {
                        codepoint |= ch - 48;
                        continue;
                    }
                    if (ch >= 'a' && ch <= 'f') {
                        codepoint |= ch + 10 - 97;
                        continue;
                    }
                    codepoint |= ch + 10 - 65;
                }
                sb.appendCodePoint(codepoint < 0x10FFFF ? codepoint : 65533);
                if (i >= n || CssLexer.isSpaceChar(ident.charAt(i))) {
                    // empty if block
                }
                pos = ++i;
                continue;
            }
            ++i;
        }
        if (sb == null) {
            return ((Object)ident).toString();
        }
        return sb.append(ident, pos, ident.length()).toString();
    }

    public static boolean isNmStart(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '\u0080' && ch <= '\u00ff' || ch == '_';
    }

    private void produce() throws ParseException {
        if (!this.pending.isEmpty()) {
            return;
        }
        if (!this.splitter.hasNext()) {
            return;
        }
        Token<CssTokenType> t = this.splitter.next();
        this.pending.add(t);
        if (t.type == CssTokenType.PUNCTUATION && this.splitter.hasNext()) {
            Token<CssTokenType> t2;
            if ("!".equals(t.text)) {
                Token<CssTokenType> t22 = this.splitter.next();
                while (t22 != null && (t22.type == CssTokenType.SPACE || t22.type == CssTokenType.COMMENT)) {
                    this.pending.add(t22);
                    t22 = this.splitter.hasNext() ? this.splitter.next() : null;
                }
                if (null != t22) {
                    this.pending.add(t22);
                    if (t22.type == CssTokenType.IDENT && Strings.eqIgnoreCase("important", CssLexer.decodeCssIdentifier(t22.text))) {
                        this.reduce(CssTokenType.DIRECTIVE);
                    }
                }
            } else if ("-".equals(t.text) && null != (t2 = this.splitter.next())) {
                this.pending.add(t2);
                if (t2.type == CssTokenType.IDENT) {
                    this.reduce(CssTokenType.IDENT);
                }
            }
        }
    }

    private void reduce(CssTokenType type) {
        StringBuilder sb = new StringBuilder();
        for (Token token : this.pending) {
            sb.append(token.text);
        }
        FilePosition fp = FilePosition.span(this.pending.getFirst().pos, this.pending.getLast().pos);
        this.pending.clear();
        this.pending.add(Token.instance(sb.toString(), type, fp));
    }

    public static boolean isSpaceChar(char ch) {
        switch (ch) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public static boolean isHexChar(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F';
    }
}

