/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.SourceBreaks;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessagePart;
import java.io.IOException;
import java.io.Serializable;
import javax.annotation.Nullable;

public final class FilePosition
implements MessagePart,
Serializable {
    private static final long serialVersionUID = 1867023076917057795L;
    public static final FilePosition UNKNOWN = FilePosition.instance(InputSource.UNKNOWN, 1, 0, 0);
    private final SourceBreaks breaks;
    private final int startCharInFile;
    private final int length;

    FilePosition(SourceBreaks breaks, int startCharInFile, int length) {
        assert (length >= 0) : "length = " + length + " < 0";
        this.breaks = breaks;
        breaks.makeImmutable();
        this.startCharInFile = startCharInFile;
        this.length = length;
    }

    SourceBreaks getBreaks() {
        return this.breaks;
    }

    public InputSource source() {
        return this.breaks.source();
    }

    public int startLineNo() {
        return this.breaks.lineAt(this.startCharInFile);
    }

    public int startCharInFile() {
        return this.startCharInFile;
    }

    public int startCharInLine() {
        return this.breaks.charInLineAt(this.startCharInFile);
    }

    public int endLineNo() {
        return this.breaks.lineAt(this.endCharInFile());
    }

    public int endCharInFile() {
        return this.startCharInFile + this.length;
    }

    public int endCharInLine() {
        return this.breaks.charInLineAt(this.endCharInFile());
    }

    public int length() {
        return this.length;
    }

    public FilePosition narrowTo(int offset, int length) {
        return this.breaks.toFilePosition(this.startCharInFile + offset, this.startCharInFile + offset + length);
    }

    public static FilePosition between(FilePosition a, FilePosition b) {
        if (a.getBreaks() != b.getBreaks()) {
            return UNKNOWN;
        }
        int start = a.startCharInFile() + a.length();
        return new FilePosition(a.getBreaks(), start, b.startCharInFile() - start);
    }

    public static FilePosition instance(InputSource source, int lineNo, int charInFile, int charInLine) {
        return FilePosition.instance(source, lineNo, charInFile, charInLine, 0);
    }

    public static FilePosition instance(InputSource source, int lineNo, int charInFile, int charInLine, int length) {
        SourceBreaks breaks = new SourceBreaks(source, lineNo - 1);
        breaks.lineStartsAt(charInFile - charInLine + 1);
        return breaks.toFilePosition(charInFile, charInFile + length);
    }

    public static FilePosition fromLinePositions(InputSource source, int startLineNo, int startCharInLine, int endLineNo, int endCharInLine) {
        int lineNo;
        SourceBreaks b = new SourceBreaks(source, lineNo);
        int charInFile = 1;
        int charInLine = 1;
        for (lineNo = startLineNo - 1; lineNo < startLineNo; ++lineNo) {
            b.lineStartsAt(++charInFile);
        }
        int delta = startCharInLine - charInLine;
        charInLine += delta;
        int startCharInFile = charInFile += delta;
        while (lineNo < endLineNo) {
            charInLine = 1;
            b.lineStartsAt(++charInFile);
            ++lineNo;
        }
        delta = endCharInLine - charInLine;
        charInLine += delta;
        int endCharInFile = charInFile += delta;
        return b.toFilePosition(startCharInFile, endCharInFile);
    }

    public static FilePosition startOfFile(InputSource source) {
        return FilePosition.instance(source, 1, 1, 1);
    }

    public static FilePosition span(FilePosition start, FilePosition end) {
        if (start == end) {
            return start;
        }
        if (!start.source().equalsAndNotUnknown(end.source())) {
            return UNKNOWN;
        }
        return start.getBreaks().toFilePosition(start.startCharInFile(), end.endCharInFile());
    }

    public static FilePosition startOf(FilePosition fp) {
        if (fp.length() == 0) {
            return fp;
        }
        return new FilePosition(fp.getBreaks(), fp.startCharInFile(), 0);
    }

    public static FilePosition endOf(FilePosition fp) {
        if (fp.length() == 0) {
            return fp;
        }
        return new FilePosition(fp.getBreaks(), fp.startCharInFile() + fp.length(), 0);
    }

    public static FilePosition endOfOrNull(@Nullable FilePosition fp) {
        return fp != null ? FilePosition.endOf(fp) : null;
    }

    public final void format(MessageContext context, Appendable out) throws IOException {
        this.source().format(context, out);
        out.append(":").append(String.valueOf(this.startLineNo())).append("+").append(String.valueOf(this.startCharInLine()));
        if (this.startCharInFile() != this.endCharInFile()) {
            out.append(" - ");
            if (this.startLineNo() != this.endLineNo()) {
                out.append(String.valueOf(this.endLineNo())).append("+");
            }
            out.append(String.valueOf(this.endCharInLine()));
        }
    }

    public final void formatShort(Appendable out) throws IOException {
        MessageContext mc = new MessageContext();
        InputSource is = this.source();
        mc.addInputSource(is);
        out.append(mc.abbreviate(is)).append(":").append(String.valueOf(this.startLineNo()));
    }

    public final String toString() {
        String fn = this.source().getUri().toString();
        StringBuilder sb = new StringBuilder();
        sb.append(fn.substring(fn.lastIndexOf(47) + 1)).append(':').append(this.startLineNo()).append('+').append(this.startCharInLine()).append('@').append(this.startCharInFile());
        if (this.startCharInFile() != this.endCharInFile()) {
            sb.append(" - ");
            if (this.endLineNo() != this.startLineNo()) {
                sb.append(this.endLineNo()).append('+');
            }
            sb.append(this.endCharInLine()).append('@').append(this.endCharInFile());
        }
        return sb.toString();
    }

    public final boolean equals(@Nullable Object o) {
        if (!(o instanceof FilePosition)) {
            return false;
        }
        FilePosition that = (FilePosition)o;
        return this.startCharInFile == that.startCharInFile && this.length == that.length && this.source().equals(that.source());
    }

    public final int hashCode() {
        return this.source().hashCode() ^ this.startCharInFile ^ this.length;
    }
}

