/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.css;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.Token;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParseTreeNodeVisitor;
import com.google.caja.parser.ParseTreeNodes;
import com.google.caja.parser.Visitor;
import com.google.caja.parser.css.CssParser;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsPrettyPrinter;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Callback;
import com.google.caja.util.Name;
import com.google.caja.util.Pair;
import com.google.caja.util.SyntheticAttributeKey;
import com.google.caja.util.SyntheticAttributes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CssPropertySignature
implements ParseTreeNode {
    private final List<CssPropertySignature> children;
    private CssPropertySignature parent;
    private CssPropertySignature nextSibling;
    private CssPropertySignature prevSibling;
    private SyntheticAttributes attribs;
    private static final boolean DEBUG = false;

    @Override
    public boolean makeImmutable() {
        return false;
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    CssPropertySignature(List<? extends CssPropertySignature> children) {
        this.children = children.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<CssPropertySignature>(children));
        CssPropertySignature last = null;
        for (CssPropertySignature cssPropertySignature : children) {
            cssPropertySignature.parent = this;
            cssPropertySignature.prevSibling = last;
            if (null != last) {
                last.nextSibling = cssPropertySignature;
            }
            last = cssPropertySignature;
        }
        assert (!this.children.contains(null));
    }

    @Override
    public CssPropertySignature clone() {
        return (CssPropertySignature)ParseTreeNodes.newNodeInstance(this.getClass(), this.getFilePosition(), this.getValue(), this.children());
    }

    @Override
    public final TokenConsumer makeRenderer(Appendable out, Callback<IOException> exHandler) {
        return new JsPrettyPrinter(new Concatenator(out, exHandler));
    }

    public ParseTreeNode getParent() {
        return this.parent;
    }

    public ParseTreeNode getNextSibling() {
        return this.nextSibling;
    }

    public ParseTreeNode getPrevSibling() {
        return this.prevSibling;
    }

    @Override
    public FilePosition getFilePosition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Token<?>> getComments() {
        return Collections.emptyList();
    }

    @Override
    public SyntheticAttributes getAttributes() {
        throw new UnsupportedOperationException();
    }

    public List<? extends CssPropertySignature> children() {
        return this.children;
    }

    @Override
    public final boolean acceptPreOrder(Visitor v, AncestorChain<?> ancestors) {
        if (!v.visit(ancestors = AncestorChain.instance(ancestors, this))) {
            return false;
        }
        for (CssPropertySignature child : this.children) {
            child.acceptPreOrder(v, ancestors);
        }
        return true;
    }

    @Override
    public final boolean acceptPostOrder(Visitor v, AncestorChain<?> ancestors) {
        ancestors = AncestorChain.instance(ancestors, this);
        for (CssPropertySignature child : this.children) {
            if (child.acceptPostOrder(v, ancestors)) continue;
            return false;
        }
        return v.visit(ancestors);
    }

    @Override
    public final boolean visitPreOrder(ParseTreeNodeVisitor v) {
        if (!v.visit(this)) {
            return false;
        }
        for (CssPropertySignature child : this.children) {
            child.visitPreOrder(v);
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        RenderContext rc = new RenderContext(this.makeRenderer(sb, null));
        this.render(rc);
        rc.getOut().noMoreTokens();
        return sb.toString();
    }

    protected void formatSelf(MessageContext context, Appendable out) throws IOException {
        out.append(this.getClass().getSimpleName());
        Object value = this.getValue();
        if (null != value) {
            out.append(" : ");
            if (value instanceof MessagePart) {
                ((MessagePart)value).format(context, out);
            } else {
                out.append(value.toString());
            }
        }
        if (null != this.attribs && !context.relevantKeys.isEmpty()) {
            for (SyntheticAttributeKey k : this.attribs.keySet()) {
                if (!context.relevantKeys.contains(k)) continue;
                out.append(" ; ").append(k.getName()).append('=');
                Object attribValue = this.attribs.get(k);
                if (attribValue instanceof MessagePart) {
                    ((MessagePart)attribValue).format(context, out);
                    continue;
                }
                out.append(String.valueOf(attribValue));
            }
        }
    }

    @Override
    public void format(MessageContext context, Appendable out) throws IOException {
        this.formatTree(context, 0, out);
    }

    @Override
    public void formatTree(MessageContext context, int depth, Appendable out) throws IOException {
        int d = depth;
        while (--d >= 0) {
            out.append("  ");
        }
        this.formatSelf(context, out);
        for (CssPropertySignature cssPropertySignature : this.children()) {
            out.append("\n");
            cssPropertySignature.formatTree(context, depth + 1, out);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Parser {
        private static Pattern[] TOKENS = new Pattern[]{Pattern.compile("^\\s+"), Pattern.compile("^(<[a-zA-Z][\\w\\-]*(?:\\:-?\\d+,-?\\d*)?>)"), Pattern.compile("^('[a-zA-Z][\\w\\-]*')"), Pattern.compile("^(-?[a-zA-Z][\\w\\-]*)"), Pattern.compile("^(\"[^\"]*\")"), Pattern.compile("^(-?[0-9]+)\\b"), Pattern.compile("^(\\|\\|)"), Pattern.compile("^([\\(\\)=\\{\\}\\*\\+\\,\\/\\|\\[\\]\\?\\.:])")};
        private static final Pattern DOTTED_NAME = Pattern.compile("^[a-z][a-z0-9_]*(\\.[a-z][a-z0-9_]*)*$", 2);

        static ListIterator<String> tokenizeSignature(String sig) {
            ArrayList<String> toks = new ArrayList<String>();
            while (!"".equals(sig)) {
                boolean match = false;
                for (Pattern p : TOKENS) {
                    Matcher m = p.matcher(sig);
                    if (!m.find()) continue;
                    if (m.groupCount() > 0) {
                        toks.add(m.group(1));
                    }
                    sig = sig.substring(m.end(0));
                    match = true;
                    break;
                }
                if (match) continue;
                throw new IllegalArgumentException(sig);
            }
            return toks.listIterator();
        }

        public static CssPropertySignature parseSignature(String sig) {
            ListIterator<String> toks = Parser.tokenizeSignature(sig);
            CssPropertySignature signature = Parser.parseSignature(toks);
            if (toks.hasNext()) {
                throw new IllegalArgumentException(Parser.unroll(toks));
            }
            return signature;
        }

        static CssPropertySignature parseSignature(ListIterator<String> toks) {
            CssPropertySignature child = Parser.parseSeries(toks);
            if (toks.hasNext()) {
                String s = toks.next();
                if ("||".equals(s) || "|".equals(s)) {
                    ArrayList<CssPropertySignature> children;
                    block6: {
                        children = new ArrayList<CssPropertySignature>();
                        children.add(child);
                        do {
                            children.add(Parser.parseSeries(toks));
                            if (!toks.hasNext()) break block6;
                        } while (s.equals(toks.next()));
                        toks.previous();
                    }
                    if ("||".equals(s)) {
                        child = new ExclusiveSetSignature(children);
                        child = new RepeatedSignature(child, 1, children.size());
                    } else {
                        child = new SetSignature(children);
                    }
                } else {
                    toks.previous();
                }
            }
            return child;
        }

        static CssPropertySignature parseSeries(ListIterator<String> toks) {
            CssPropertySignature first = Parser.parseSignatureAtom(toks);
            if (!toks.hasNext()) {
                return first;
            }
            String s = toks.next();
            if ("]".equals(s) || "|".equals(s) || "||".equals(s) || ")".equals(s)) {
                toks.previous();
                return first;
            }
            ArrayList<CssPropertySignature> children = new ArrayList<CssPropertySignature>();
            children.add(first);
            toks.previous();
            do {
                children.add(Parser.parseSignatureAtom(toks));
                if (!toks.hasNext()) break;
                s = toks.next();
                toks.previous();
            } while (!"]".equals(s) && !"|".equals(s) && !"||".equals(s) && !")".equals(s));
            return new SeriesSignature(children);
        }

        static CssPropertySignature parseSignatureAtom(ListIterator<String> toks) {
            CssPropertySignature sig;
            String s = toks.next();
            if ("[".equals(s)) {
                sig = Parser.parseSignature(toks);
                Parser.expect(toks, "]");
            } else if (Name.css("progid").equals(Name.css(s))) {
                if (":".equals(toks.next())) {
                    sig = Parser.parseProgId(toks);
                } else {
                    toks.previous();
                    sig = new LiteralSignature(s);
                }
            } else {
                char ch0 = s.charAt(0);
                sig = Character.isLetter(ch0) ? new LiteralSignature(s) : (ch0 == '\'' ? new PropertyRefSignature(Name.css(s.substring(1, s.length() - 1))) : (ch0 == '\"' ? new QuotedLiteralSignature(CssParser.unescape(s.substring(1, s.length() - 1), false)) : (ch0 == '<' ? new SymbolSignature(Name.css(s.substring(1, s.length() - 1))) : new LiteralSignature(s))));
            }
            return Parser.parsePostOp(Parser.parseBracketOp(sig, toks), toks);
        }

        static CssPropertySignature parsePostOp(CssPropertySignature sig, ListIterator<String> toks) {
            int max;
            int min;
            if (!toks.hasNext()) {
                return sig;
            }
            String s = toks.next();
            if (s.equals("{")) {
                try {
                    min = Integer.parseInt(toks.next());
                    s = toks.next();
                    max = ",".equals(s) ? Integer.parseInt(toks.next()) : min;
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException(Parser.unroll(toks), ex);
                }
                if (!"}".equals(toks.next())) {
                    throw new IllegalArgumentException(Parser.unroll(toks));
                }
            } else if (s.equals("*")) {
                min = 0;
                max = Integer.MAX_VALUE;
            } else if (s.equals("?")) {
                min = 0;
                max = 1;
            } else if (s.equals("+")) {
                min = 1;
                max = Integer.MAX_VALUE;
            } else {
                toks.previous();
                return sig;
            }
            if (sig instanceof RepeatedSignature) {
                RepeatedSignature rsig = (RepeatedSignature)sig;
                sig = rsig.children().get(0);
                min = Math.min(min, rsig.minCount);
                long lmax = max * rsig.maxCount;
                max = lmax > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)lmax;
            }
            return new RepeatedSignature(sig, min, max);
        }

        static CssPropertySignature parseBracketOp(CssPropertySignature sig, ListIterator<String> toks) {
            if (!toks.hasNext()) {
                return sig;
            }
            if ("(".equals(toks.next())) {
                ArrayList<CssPropertySignature> children = new ArrayList<CssPropertySignature>();
                children.add(sig);
                if (!")".equals(toks.next())) {
                    toks.previous();
                    children.add(Parser.parseSignature(toks));
                    if (!")".equals(toks.next())) {
                        throw new IllegalArgumentException(Parser.unroll(toks));
                    }
                }
                return new CallSignature(children);
            }
            toks.previous();
            return sig;
        }

        static ProgIdSignature parseProgId(ListIterator<String> toks) {
            String t;
            StringBuilder name = new StringBuilder();
            while (!"(".equals(t = toks.next())) {
                name.append(t);
            }
            if (!DOTTED_NAME.matcher(name).matches()) {
                throw new IllegalArgumentException("Not dotted name: " + name.toString());
            }
            ArrayList<ProgIdAttrSignature> attrs = new ArrayList<ProgIdAttrSignature>();
            String t2 = toks.next();
            if (!")".equals(t2)) {
                while (true) {
                    if (!Character.isLetter(t2.charAt(0))) {
                        throw new IllegalArgumentException("Not attr name: " + t2);
                    }
                    Name attrName = Name.css(t2);
                    t2 = toks.next();
                    if (!"=".equals(t2)) {
                        throw new IllegalArgumentException("Not '=':" + t2);
                    }
                    CssPropertySignature valueSig = Parser.parseSignatureAtom(toks);
                    attrs.add(new ProgIdAttrSignature(attrName, valueSig));
                    t2 = toks.next();
                    if (")".equals(t2)) break;
                    if (!",".equals(t2)) {
                        throw new IllegalArgumentException("Not comma: " + t2);
                    }
                    t2 = toks.next();
                }
            }
            return new ProgIdSignature(Name.css(name.toString()), attrs);
        }

        private static String unroll(ListIterator<?> it) {
            if (it.hasPrevious()) {
                it.previous();
            }
            if (!it.hasNext()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(it.next());
            while (it.hasNext()) {
                sb.append(' ').append(it.next());
            }
            return sb.toString();
        }

        private static void expect(ListIterator<String> it, String tok) {
            if (!it.hasNext()) {
                throw new IllegalArgumentException("Expected " + tok + ", not end of sig");
            }
            String next = it.next();
            if (!tok.equals(next)) {
                throw new IllegalArgumentException("Expected " + tok + ", not " + next + " : " + Parser.unroll(it));
            }
        }

        private Parser() {
        }
    }

    public static final class ProgIdAttrSignature
    extends CssPropertySignature {
        private final Name name;

        private ProgIdAttrSignature(Name name, CssPropertySignature valueSig) {
            super(Collections.singletonList(valueSig));
            this.name = name;
        }

        public Name getValue() {
            return this.name;
        }

        public Name getName() {
            return this.name;
        }

        public CssPropertySignature getValueSig() {
            return this.children().get(0);
        }

        public void render(RenderContext r) {
            TokenConsumer out = r.getOut();
            out.consume(this.name.getCanonicalForm());
            out.consume("=");
            this.children().get(0).render(r);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ProgIdSignature
    extends CssPropertySignature {
        private final Name name;

        private ProgIdSignature(Name name, List<ProgIdAttrSignature> attrs) {
            super(attrs);
            this.name = name;
        }

        @Override
        public Name getValue() {
            return this.name;
        }

        public Name getName() {
            return this.name;
        }

        @Override
        public void render(RenderContext r) {
            TokenConsumer out = r.getOut();
            out.consume("progid");
            out.consume(":");
            out.consume(this.name.getCanonicalForm());
            out.consume("(");
            boolean comma = false;
            for (CssPropertySignature cssPropertySignature : this.children()) {
                if (comma) {
                    out.consume(",");
                }
                comma = true;
                cssPropertySignature.render(r);
            }
            out.consume(")");
        }

        public ProgIdAttrSignature getProgIdAttr(Name attrName) {
            for (CssPropertySignature cssPropertySignature : this.children()) {
                ProgIdAttrSignature attr = (ProgIdAttrSignature)cssPropertySignature;
                if (!attrName.equals(attr.getName())) continue;
                return attr;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CallSignature
    extends CssPropertySignature {
        private CallSignature(List<CssPropertySignature> children) {
            super(children);
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public void render(RenderContext r) {
            TokenConsumer out = r.getOut();
            ListIterator<? extends CssPropertySignature> childIt = this.children().listIterator();
            childIt.next().render(r);
            out.consume("(");
            while (childIt.hasNext()) {
                out.consume(" ");
                childIt.next().render(r);
            }
            out.consume(")");
        }
    }

    public static final class SymbolSignature
    extends CssPropertySignature {
        public final Name symbolName;

        private SymbolSignature(Name symbolName) {
            super(Collections.emptyList());
            this.symbolName = symbolName;
        }

        public Name getValue() {
            return this.symbolName;
        }

        public void render(RenderContext r) {
            TokenConsumer out = r.getOut();
            out.consume("<");
            out.consume(this.symbolName.getCanonicalForm());
            out.consume(">");
        }
    }

    public static final class PropertyRefSignature
    extends CssPropertySignature {
        public final Name name;

        private PropertyRefSignature(Name name) {
            super(Collections.emptyList());
            this.name = name;
        }

        public Name getValue() {
            return this.name;
        }

        public Name getPropertyName() {
            return this.name;
        }

        public void render(RenderContext r) {
            r.getOut().consume("'" + this.name + "'");
        }
    }

    public static final class QuotedLiteralSignature
    extends CssPropertySignature {
        public final String value;

        private QuotedLiteralSignature(String value) {
            super(Collections.emptyList());
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void render(RenderContext r) {
            StringBuilder sb = new StringBuilder(this.value.length() + 16);
            sb.append('\"');
            Escaping.escapeCssString((CharSequence)this.value, sb);
            sb.append('\"');
            r.getOut().consume(sb.toString());
        }
    }

    public static final class LiteralSignature
    extends CssPropertySignature {
        public final String value;

        private LiteralSignature(String value) {
            super(Collections.emptyList());
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void render(RenderContext r) {
            r.getOut().consume(this.value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SeriesSignature
    extends CssPropertySignature {
        private SeriesSignature(List<CssPropertySignature> children) {
            super(children);
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public void render(RenderContext r) {
            TokenConsumer out = r.getOut();
            out.consume("[");
            boolean first = true;
            for (CssPropertySignature cssPropertySignature : this.children()) {
                if (!first) {
                    out.consume(" ");
                } else {
                    first = false;
                }
                cssPropertySignature.render(r);
            }
            out.consume("]");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ExclusiveSetSignature
    extends SetSignature {
        private ExclusiveSetSignature(List<CssPropertySignature> alternatives) {
            super(alternatives);
        }

        @Override
        public void render(RenderContext r) {
            TokenConsumer out = r.getOut();
            out.consume("[");
            boolean first = true;
            for (CssPropertySignature cssPropertySignature : this.children()) {
                if (!first) {
                    out.consume("||");
                } else {
                    first = false;
                }
                cssPropertySignature.render(r);
            }
            out.consume("]");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetSignature
    extends CssPropertySignature {
        private SetSignature(List<CssPropertySignature> alternatives) {
            super(alternatives);
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public void render(RenderContext r) {
            TokenConsumer out = r.getOut();
            out.consume("[");
            boolean first = true;
            for (CssPropertySignature cssPropertySignature : this.children()) {
                if (!first) {
                    out.consume("|");
                } else {
                    first = false;
                }
                cssPropertySignature.render(r);
            }
            out.consume("]");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class RepeatedSignature
    extends CssPropertySignature {
        public final int minCount;
        public final int maxCount;

        private RepeatedSignature(CssPropertySignature sig, int minCount, int maxCount) {
            super(Collections.singletonList(sig));
            this.minCount = minCount;
            this.maxCount = maxCount;
        }

        @Override
        public Pair<Integer, Integer> getValue() {
            return Pair.pair(this.minCount, this.maxCount);
        }

        public CssPropertySignature getRepeatedSignature() {
            return this.children().get(0);
        }

        @Override
        public void render(RenderContext r) {
            TokenConsumer out = r.getOut();
            this.children().get(0).render(r);
            out.consume("{");
            out.consume(String.valueOf(this.minCount));
            if (this.minCount != this.maxCount) {
                out.consume(",");
                if (Integer.MAX_VALUE != this.maxCount) {
                    out.consume(String.valueOf(this.maxCount));
                }
            }
            out.consume("}");
        }
    }
}

