/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.JsonMLCompatible;
import com.google.caja.parser.js.LabeledStatement;
import com.google.caja.parser.js.NestedScope;
import com.google.caja.parser.js.Statement;
import com.google.caja.reporting.RenderContext;
import com.google.javascript.jscomp.jsonml.JsonML;
import com.google.javascript.jscomp.jsonml.TagType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ForEachLoop
extends LabeledStatement
implements NestedScope {
    private static final long serialVersionUID = 5611785542136135478L;
    private Statement keyReceiver;
    private Expression container;
    private Statement body;

    @ParseTreeNode.ReflectiveCtor
    public ForEachLoop(FilePosition pos, String value, List<? extends ParseTreeNode> children) {
        super(pos, value, ParseTreeNode.class);
        this.createMutation().appendChildren(children).execute();
    }

    public ForEachLoop(FilePosition pos, String label, Declaration var, Expression container, Statement body) {
        super(pos, label, ParseTreeNode.class);
        this.createMutation().appendChild(var).appendChild(container).appendChild(body).execute();
    }

    public ForEachLoop(FilePosition pos, String label, Expression lvalue, Expression container, Statement body) {
        super(pos, label, ParseTreeNode.class);
        ExpressionStmt varStmt = new ExpressionStmt(lvalue.getFilePosition(), lvalue);
        this.createMutation().appendChild(varStmt).appendChild(container).appendChild(body).execute();
    }

    public Statement getKeyReceiver() {
        return this.keyReceiver;
    }

    public Expression getContainer() {
        return this.container;
    }

    public Statement getBody() {
        return this.body;
    }

    @Override
    public boolean isTargetForContinue() {
        return true;
    }

    @Override
    protected void childrenChanged() {
        Expression e;
        super.childrenChanged();
        List<? extends ParseTreeNode> children = this.children();
        this.keyReceiver = (Statement)children.get(0);
        if (this.keyReceiver instanceof ExpressionStmt && !(e = ((ExpressionStmt)this.keyReceiver).getExpression()).isLeftHandSide()) {
            throw new IllegalArgumentException("Not an lvalue: " + e);
        }
        this.container = (Expression)children.get(1);
        this.body = (Statement)children.get(2);
    }

    @Override
    public void render(RenderContext rc) {
        TokenConsumer out = rc.getOut();
        out.mark(this.getFilePosition());
        String label = this.getRenderedLabel(rc);
        if (null != label) {
            out.consume(label);
            out.consume(":");
        }
        out.consume("for");
        out.consume("(");
        this.keyReceiver.render(rc);
        out.consume("in");
        this.container.render(rc);
        out.consume(")");
        this.body.renderBlock(rc, false);
    }

    @Override
    public boolean hasHangingConditional() {
        return this.body.hasHangingConditional();
    }

    @Override
    public JsonML toJsonML() {
        return this.wrapIfLabelled(JsonMLCompatible.JsonMLBuilder.builder(TagType.ForInStmt, this.getFilePosition()).addChild(this.keyReceiver).addChild(this.container).addChild(this.body).build());
    }
}

