/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.NumberLiteral;
import com.google.caja.reporting.RenderContext;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntegerLiteral
extends NumberLiteral {
    private static final long serialVersionUID = -8933353016397006347L;
    public static final long MIN_VALUE = -4503599627370496L;
    public static final long MAX_VALUE = 0x10000000000000L;
    private final long value;

    @ParseTreeNode.ReflectiveCtor
    public IntegerLiteral(FilePosition pos, Number value, List<? extends ParseTreeNode> children) {
        this(pos, value.longValue());
    }

    public IntegerLiteral(FilePosition pos, long value) {
        super(pos);
        if (-4503599627370496L > value || value > 0x10000000000000L) {
            throw new IllegalArgumentException("" + value);
        }
        this.value = value;
    }

    @Override
    public Number getValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public void render(RenderContext rc) {
        String str;
        long n = this.getValue().longValue();
        str = -68719476736L > n && n < 0x1000000000L ? ((str = Long.toString(n, 16)).charAt(0) == '-' ? "-0x" + str.substring(1) : "0x" + str) : Long.toString(n, 10);
        rc.getOut().consume(str);
    }
}

