/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.util.Lists;
import com.google.javascript.jscomp.jsonml.JsonML;
import com.google.javascript.jscomp.jsonml.TagAttr;
import com.google.javascript.jscomp.jsonml.TagType;
import java.util.EnumMap;
import java.util.List;

public interface JsonMLCompatible {
    public JsonML toJsonML();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class JsonMLBuilder {
        private final TagType type;
        private final EnumMap<TagAttr, Object> attrs = new EnumMap(TagAttr.class);
        private final List<JsonML> children = Lists.newArrayList();

        private JsonMLBuilder(TagType type, FilePosition pos) {
            this.type = type;
            if (!FilePosition.UNKNOWN.equals(pos)) {
                this.attrs.put(TagAttr.SOURCE, (Object)pos.source().getUri().toString());
                int packedPosition = pos.startCharInFile() << 16 | Math.min(65535, pos.length());
                this.attrs.put(TagAttr.OPAQUE_POSITION, (Object)packedPosition);
            }
        }

        public static JsonMLBuilder builder(TagType type, FilePosition pos) {
            return new JsonMLBuilder(type, pos);
        }

        public JsonMLBuilder setAttribute(TagAttr a, Object value) {
            assert (!this.attrs.containsKey(a));
            this.attrs.put(a, value);
            return this;
        }

        public JsonMLBuilder setAttributeIfNotBlank(TagAttr a, Object value) {
            return value != null && !"".equals(value) ? this.setAttribute(a, value) : this;
        }

        public JsonMLBuilder addChild(JsonML child) {
            assert (child != null);
            this.children.add(child);
            return this;
        }

        public JsonMLBuilder addChild(JsonMLCompatible child) {
            return this.addChild(child.toJsonML());
        }

        public JsonMLBuilder addChildIfNotNull(JsonMLCompatible child) {
            return child != null ? this.addChild(child.toJsonML()) : this;
        }

        public JsonMLBuilder addChildren(Iterable<? extends JsonMLCompatible> children) {
            for (JsonMLCompatible jsonMLCompatible : children) {
                this.addChild(jsonMLCompatible);
            }
            return this;
        }

        public boolean hasChildren() {
            return !this.children.isEmpty();
        }

        public JsonML build() {
            return new JsonML(this.type, this.attrs, this.children);
        }
    }
}

